<?php
// Load Laravel environment
require __DIR__.'/vendor/autoload.php';
$app = require __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Http\Controllers\Api\AuthController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

echo "--- Simulating Registration ---\n";
$email = 'verify' . time() . '@test.com';

// Ensure Standard plan is default
$default = DB::table('user_plans')->where('is_default', true)->first();
echo "Current Default Plan in DB: " . ($default ? $default->plan_name : 'NONE') . "\n";

$request = Request::create('/api/v1/auth/register', 'POST', [
    'name' => 'VerifyUser',
    'email' => $email,
    'password' => 'password123',
    'password_confirmation' => 'password123',
    'privacy_policy' => 1
]);

$controller = app(AuthController::class);

try {
    $response = $controller->register($request);
    
    // Handle response if it's a JsonResponse or similar
    $content = method_exists($response, 'getContent') ? $response->getContent() : json_encode($response);
    $data = json_decode($content, true);

    if (isset($data['plan'])) {
        echo "SUCCESS: Plan returned in response.\n";
        echo "Plan Name: " . $data['plan']['name'] . "\n";
        
        $user = \App\Models\User::where('email', $email)->first();
        echo "User DB Plan ID: " . $user->current_plan_id . "\n";
        echo "User DB Membership: " . $user->membership_type . "\n";
    } else {
        echo "FAILURE: Plan missing from response.\n";
        print_r($data);
    }
} catch (\Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}
