<?php

// File generated from our OpenAPI spec

namespace Stripe\V2\Core;

/**
 * A V2 Account is a representation of a company or individual that a Stripe user does business with. Accounts contain the contact details, Legal Entity information, and configuration required to enable the Account for use across Stripe products.
 *
 * @property string $id Unique identifier for the Account.
 * @property string $object String representing the object's type. Objects of the same type share the same value of the object field.
 * @property string[] $applied_configurations The configurations that have been applied to this account.
 * @property null|bool $closed Indicates whether the account has been closed.
 * @property null|(object{customer?: (object{applied: bool, automatic_indirect_tax?: (object{exempt?: string, ip_address?: string, location?: (object{country?: string, state?: string}&\Stripe\StripeObject), location_source?: string}&\Stripe\StripeObject), billing?: (object{default_payment_method?: string, invoice?: (object{custom_fields: (object{name: string, value: string}&\Stripe\StripeObject)[], footer?: string, next_sequence?: int, prefix?: string, rendering?: (object{amount_tax_display?: string, template?: string}&\Stripe\StripeObject)}&\Stripe\StripeObject)}&\Stripe\StripeObject), capabilities?: (object{automatic_indirect_tax?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject)}&\Stripe\StripeObject), shipping?: (object{address?: (object{city?: string, country?: string, line1?: string, line2?: string, postal_code?: string, state?: string}&\Stripe\StripeObject), name?: string, phone?: string}&\Stripe\StripeObject), test_clock?: string}&\Stripe\StripeObject), merchant?: (object{applied: bool, bacs_debit_payments?: (object{display_name?: string, service_user_number?: string}&\Stripe\StripeObject), branding?: (object{icon?: string, logo?: string, primary_color?: string, secondary_color?: string}&\Stripe\StripeObject), capabilities?: (object{ach_debit_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), acss_debit_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), affirm_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), afterpay_clearpay_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), alma_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), amazon_pay_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), au_becs_debit_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), bacs_debit_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), bancontact_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), blik_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), boleto_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), card_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), cartes_bancaires_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), cashapp_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), eps_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), fpx_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), gb_bank_transfer_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), grabpay_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), ideal_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), jcb_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), jp_bank_transfer_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), kakao_pay_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), klarna_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), konbini_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), kr_card_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), link_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), mobilepay_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), multibanco_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), mx_bank_transfer_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), naver_pay_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), oxxo_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), p24_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), pay_by_bank_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), payco_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), paynow_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), promptpay_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), revolut_pay_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), samsung_pay_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), sepa_bank_transfer_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), sepa_debit_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), stripe_balance?: (object{payouts?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject)}&\Stripe\StripeObject), swish_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), twint_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), us_bank_transfer_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), zip_payments?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject)}&\Stripe\StripeObject), card_payments?: (object{decline_on?: (object{avs_failure?: bool, cvc_failure?: bool}&\Stripe\StripeObject)}&\Stripe\StripeObject), konbini_payments?: (object{support?: (object{email?: string, hours?: (object{end_time?: string, start_time?: string}&\Stripe\StripeObject), phone?: string}&\Stripe\StripeObject)}&\Stripe\StripeObject), mcc?: string, script_statement_descriptor?: (object{kana?: (object{descriptor?: string, prefix?: string}&\Stripe\StripeObject), kanji?: (object{descriptor?: string, prefix?: string}&\Stripe\StripeObject)}&\Stripe\StripeObject), sepa_debit_payments?: (object{creditor_id?: string}&\Stripe\StripeObject), statement_descriptor?: (object{descriptor?: string, prefix?: string}&\Stripe\StripeObject), support?: (object{address?: (object{city?: string, country?: string, line1?: string, line2?: string, postal_code?: string, state?: string, town?: string}&\Stripe\StripeObject), email?: string, phone?: string, url?: string}&\Stripe\StripeObject)}&\Stripe\StripeObject), recipient?: (object{applied: bool, capabilities?: (object{stripe_balance?: (object{payouts?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), stripe_transfers?: (object{status: string, status_details: (object{code: string, resolution: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject)}&\Stripe\StripeObject)}&\Stripe\StripeObject)}&\Stripe\StripeObject)}&\Stripe\StripeObject) $configuration An Account represents a company, individual, or other entity that a user interacts with. Accounts store identity information and one or more configurations that enable product-specific capabilities. You can assign configurations at creation or add them later.
 * @property null|string $contact_email The default contact email address for the Account. Required when configuring the account as a merchant or recipient.
 * @property int $created Time at which the object was created. Represented as a RFC 3339 date &amp; time UTC value in millisecond precision, for example: 2022-09-18T13:22:18.123Z.
 * @property null|string $dashboard A value indicating the Stripe dashboard this Account has access to. This will depend on which configurations are enabled for this account.
 * @property null|(object{currency?: string, locales?: string[], profile?: (object{business_url?: string, doing_business_as?: string, product_description?: string}&\Stripe\StripeObject), responsibilities: (object{fees_collector?: string, losses_collector?: string, requirements_collector: string}&\Stripe\StripeObject)}&\Stripe\StripeObject) $defaults Default values for settings shared across Account configurations.
 * @property null|string $display_name A descriptive name for the Account. This name will be surfaced in the Stripe Dashboard and on any invoices sent to the Account.
 * @property null|(object{entries?: (object{awaiting_action_from: string, description: string, errors: (object{code: string, description: string}&\Stripe\StripeObject)[], impact: (object{restricts_capabilities?: (object{capability: string, configuration: string, deadline: (object{status: string}&\Stripe\StripeObject)}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), minimum_deadline: (object{status: string}&\Stripe\StripeObject), reference?: (object{inquiry?: string, resource?: string, type: string}&\Stripe\StripeObject), requested_reasons: (object{code: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject)[], minimum_transition_date?: int, summary?: (object{minimum_deadline?: (object{status: string, time?: int}&\Stripe\StripeObject)}&\Stripe\StripeObject)}&\Stripe\StripeObject) $future_requirements Information about the future requirements for the Account that will eventually come into effect, including what information needs to be collected, and by when.
 * @property null|(object{attestations?: (object{directorship_declaration?: (object{date?: int, ip?: string, user_agent?: string}&\Stripe\StripeObject), ownership_declaration?: (object{date?: int, ip?: string, user_agent?: string}&\Stripe\StripeObject), persons_provided?: (object{directors?: bool, executives?: bool, owners?: bool, ownership_exemption_reason?: string}&\Stripe\StripeObject), representative_declaration?: (object{date?: int, ip?: string, user_agent?: string}&\Stripe\StripeObject), terms_of_service?: (object{account?: (object{date?: int, ip?: string, user_agent?: string}&\Stripe\StripeObject)}&\Stripe\StripeObject)}&\Stripe\StripeObject), business_details?: (object{address?: (object{city?: string, country?: string, line1?: string, line2?: string, postal_code?: string, state?: string, town?: string}&\Stripe\StripeObject), annual_revenue?: (object{amount?: (object{value?: int, currency?: string}&\Stripe\StripeObject), fiscal_year_end?: string}&\Stripe\StripeObject), documents?: (object{bank_account_ownership_verification?: (object{files: string[], type: string}&\Stripe\StripeObject), company_license?: (object{files: string[], type: string}&\Stripe\StripeObject), company_memorandum_of_association?: (object{files: string[], type: string}&\Stripe\StripeObject), company_ministerial_decree?: (object{files: string[], type: string}&\Stripe\StripeObject), company_registration_verification?: (object{files: string[], type: string}&\Stripe\StripeObject), company_tax_id_verification?: (object{files: string[], type: string}&\Stripe\StripeObject), primary_verification?: (object{front_back: (object{back?: string, front: string}&\Stripe\StripeObject), type: string}&\Stripe\StripeObject), proof_of_address?: (object{files: string[], type: string}&\Stripe\StripeObject), proof_of_registration?: (object{files: string[], type: string}&\Stripe\StripeObject), proof_of_ultimate_beneficial_ownership?: (object{files: string[], type: string}&\Stripe\StripeObject)}&\Stripe\StripeObject), estimated_worker_count?: int, id_numbers?: (object{registrar?: string, type: string}&\Stripe\StripeObject)[], monthly_estimated_revenue?: (object{amount?: (object{value?: int, currency?: string}&\Stripe\StripeObject)}&\Stripe\StripeObject), phone?: string, registered_name?: string, script_addresses?: (object{kana?: (object{city?: string, country?: string, line1?: string, line2?: string, postal_code?: string, state?: string, town?: string}&\Stripe\StripeObject), kanji?: (object{city?: string, country?: string, line1?: string, line2?: string, postal_code?: string, state?: string, town?: string}&\Stripe\StripeObject)}&\Stripe\StripeObject), script_names?: (object{kana?: (object{registered_name?: string}&\Stripe\StripeObject), kanji?: (object{registered_name?: string}&\Stripe\StripeObject)}&\Stripe\StripeObject), structure?: string}&\Stripe\StripeObject), country?: string, entity_type?: string, individual?: (object{account: string, additional_addresses?: (object{city?: string, country?: string, line1?: string, line2?: string, postal_code?: string, purpose: string, state?: string, town?: string}&\Stripe\StripeObject)[], additional_names?: (object{full_name?: string, given_name?: string, purpose: string, surname?: string}&\Stripe\StripeObject)[], additional_terms_of_service?: (object{account?: (object{date?: int, ip?: string, user_agent?: string}&\Stripe\StripeObject)}&\Stripe\StripeObject), address?: (object{city?: string, country?: string, line1?: string, line2?: string, postal_code?: string, state?: string, town?: string}&\Stripe\StripeObject), created: int, date_of_birth?: (object{day: int, month: int, year: int}&\Stripe\StripeObject), documents?: (object{company_authorization?: (object{files: string[], type: string}&\Stripe\StripeObject), passport?: (object{files: string[], type: string}&\Stripe\StripeObject), primary_verification?: (object{front_back: (object{back?: string, front: string}&\Stripe\StripeObject), type: string}&\Stripe\StripeObject), secondary_verification?: (object{front_back: (object{back?: string, front: string}&\Stripe\StripeObject), type: string}&\Stripe\StripeObject), visa?: (object{files: string[], type: string}&\Stripe\StripeObject)}&\Stripe\StripeObject), email?: string, given_name?: string, id: string, id_numbers?: (object{type: string}&\Stripe\StripeObject)[], legal_gender?: string, metadata?: \Stripe\StripeObject, nationalities?: string[], object: string, phone?: string, political_exposure?: string, relationship?: (object{authorizer?: bool, director?: bool, executive?: bool, legal_guardian?: bool, owner?: bool, percent_ownership?: string, representative?: bool, title?: string}&\Stripe\StripeObject), script_addresses?: (object{kana?: (object{city?: string, country?: string, line1?: string, line2?: string, postal_code?: string, state?: string, town?: string}&\Stripe\StripeObject), kanji?: (object{city?: string, country?: string, line1?: string, line2?: string, postal_code?: string, state?: string, town?: string}&\Stripe\StripeObject)}&\Stripe\StripeObject), script_names?: (object{kana?: (object{given_name?: string, surname?: string}&\Stripe\StripeObject), kanji?: (object{given_name?: string, surname?: string}&\Stripe\StripeObject)}&\Stripe\StripeObject), surname?: string, updated: int}&\Stripe\StripeObject)}&\Stripe\StripeObject) $identity Information about the company, individual, and business represented by the Account.
 * @property bool $livemode Has the value <code>true</code> if the object exists in live mode or the value <code>false</code> if the object exists in test mode.
 * @property null|\Stripe\StripeObject $metadata Set of key-value pairs that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
 * @property null|(object{entries?: (object{awaiting_action_from: string, description: string, errors: (object{code: string, description: string}&\Stripe\StripeObject)[], impact: (object{restricts_capabilities?: (object{capability: string, configuration: string, deadline: (object{status: string}&\Stripe\StripeObject)}&\Stripe\StripeObject)[]}&\Stripe\StripeObject), minimum_deadline: (object{status: string}&\Stripe\StripeObject), reference?: (object{inquiry?: string, resource?: string, type: string}&\Stripe\StripeObject), requested_reasons: (object{code: string}&\Stripe\StripeObject)[]}&\Stripe\StripeObject)[], summary?: (object{minimum_deadline?: (object{status: string, time?: int}&\Stripe\StripeObject)}&\Stripe\StripeObject)}&\Stripe\StripeObject) $requirements Information about the active requirements for the Account, including what information needs to be collected, and by when.
 */
class Account extends \Stripe\ApiResource
{
    const OBJECT_NAME = 'v2.core.account';

    const DASHBOARD_EXPRESS = 'express';
    const DASHBOARD_FULL = 'full';
    const DASHBOARD_NONE = 'none';
}
