<?php

require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\User;
use Illuminate\Http\Request;

// Mock Authenticated User
$user = User::where('email', 'test@clxpro.in')->first();
if (!$user) {
    echo "Test user not found.\n";
    exit(1);
}

// Request to /api/user
// We need to simulate the sanctum auth or just check what $request->user() returns when eager loaded
// Best way is to see how the object is serialized to JSON

// Eager load current plan like API would if we modified it, or check default serialization
$user->load('currentPlan');

echo "User JSON:\n";
echo json_encode($user, JSON_PRETTY_PRINT) . "\n";
