<?php

require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\UserPlan;
use Illuminate\Http\Request;
use App\Http\Controllers\Admin\PlansController;

// 1. Get the Standard Plan (or any plan)
$plan = UserPlan::where('plan_name', 'Standard')->first();

if (!$plan) {
    echo "Standard plan not found.\n";
    exit(1);
}

echo "Current Plan Data:\n";
echo "ID: {$plan->id}\n";
echo "Name: {$plan->plan_name}\n";
echo "Price: {$plan->price}\n";
echo "Discount %: " . ($plan->discount_percentage ?? 'NULL') . "\n";

// 2. Simulate Request to update discount to 100%
$controller = new PlansController();

$request = Request::create('/admin/plans/api-update/' . $plan->id, 'POST', [
    'plan_name' => $plan->plan_name,
    'price' => $plan->price,
    'duration_days' => $plan->duration_days,
    'analytics_tier' => $plan->analytics_tier,
    'validity_days' => $plan->validity_days,
    'status' => 'Active',
    'discount_percentage' => 100, // Setting to 100%
    'ad_free' => $plan->ad_free,
    'has_analytics' => $plan->has_analytics,
    'verified_badge' => $plan->verified_badge,
]);

echo "\nUpdating discount to 100%...\n";

try {
    $response = $controller->apiUpdate($request, $plan);
    $content = $response->getContent();
    echo "Response: " . $content . "\n";
    
    // 3. Verify Update
    $updatedPlan = UserPlan::find($plan->id);
    echo "\nUpdated Plan Data:\n";
    echo "Discount %: " . ($updatedPlan->discount_percentage ?? 'NULL') . "\n";
    
    if ($updatedPlan->discount_percentage == 100) {
        echo "✅ Update Successful! Backend Logic works.\n";
    } else {
        echo "❌ Update Failed! Backend Logic broken.\n";
    }
    
} catch (\Exception $e) {
    echo "❌ Exception: " . $e->getMessage() . "\n";
    echo $e->getTraceAsString();
}
