<?php

// Simple test to check pages API
require __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';

$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

echo "Testing Pages API...\n\n";

// Test 1: Get all pages
echo "1. Testing GET /api/pages\n";
$pages = \App\Models\Page::active()->showInApp()->ordered()->get(['id', 'title', 'slug', 'order', 'meta']);
echo "Found: " . $pages->count() . " pages\n";
foreach ($pages as $page) {
    echo "  - {$page->title} ({$page->slug})\n";
}
echo "\n";

// Test 2: Get specific page by slug
echo "2. Testing individual pages:\n";
$slugs = ['privacy-policy', 'terms-of-service', 'community-guidelines'];
foreach ($slugs as $slug) {
    $page = \App\Models\Page::where('slug', $slug)->active()->first();
    if ($page) {
        echo "  ✓ {$slug}: Found - {$page->title}\n";
    } else {
        echo "  ✗ {$slug}: NOT FOUND\n";
    }
}
echo "\n";

// Test 3: Check database structure
echo "3. Checking database structure:\n";
$columns = \Illuminate\Support\Facades\Schema::getColumnListing('pages');
echo "Pages table columns: " . implode(', ', $columns) . "\n";
