<?php

require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\User;
use App\Models\Notification;
use App\Models\NotificationDelivery;
use App\Services\FirebaseService;

// Get first user and add a dummy token for testing
$user = User::first();
if (!$user) {
    echo "No users found in database.\n";
    exit(1);
}

// For Windows testing, we'll use a dummy token since Firebase doesn't support Windows
// In production, the mobile app will provide real tokens
$user->device_token = 'test_dummy_token_windows';
$user->device_type = 'test';
$user->save();

echo "User: {$user->name} ({$user->email})\n";
echo "Device Token: {$user->device_token}\n\n";

// Create a test notification
$notification = Notification::create([
    'title' => 'Test Notification',
    'message' => 'This is a test notification from CLX Platform!',
    'category' => 'general',
    'priority' => 'high',
    'type' => 'broadcast',
    'target_type' => 'all',
    'status' => 'draft',
    'scheduled_at' => now(),
]);

echo "Created notification ID: {$notification->id}\n";

// Create delivery record
$delivery = NotificationDelivery::create([
    'notification_id' => $notification->id,
    'user_id' => $user->id,
    'status' => 'pending'
]);

echo "Created delivery record ID: {$delivery->id}\n\n";

// Attempt to send
echo "Attempting to send notification...\n";
$firebaseService = new FirebaseService();

try {
    $result = $firebaseService->sendPushNotification($user, $notification, $delivery);
    
    if ($result) {
        echo "✅ SUCCESS: Notification sent successfully!\n";
        $delivery->refresh();
        echo "Delivery status: {$delivery->status}\n";
    } else {
        echo "❌ FAILED: Could not send notification.\n";
        echo "Check logs for details: storage/logs/laravel.log\n";
    }
} catch (\Exception $e) {
    echo "❌ ERROR: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}
