<?php

require __DIR__.'/vendor/autoload.php';

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

$app = require_once __DIR__.'/bootstrap/app.php';

echo "Testing Login Functionality\n\n";

// Test database connection
try {
    DB::connection()->getPdo();
    echo "✅ Database connected\n";
} catch (\Exception $e) {
    echo "❌ Database connection failed: " . $e->getMessage() . "\n";
    exit(1);
}

// Check if user exists
$user = DB::table('users')->where('email', 'raj@example.com')->first();
if ($user) {
    echo "✅ User found: {$user->name} (ID: {$user->id})\n";
    
    // Check password
    if (Hash::check('password123', $user->password)) {
        echo "✅ Password matches\n";
    } else {
        echo "❌ Password does not match\n";
    }
} else {
    echo "❌ User not found\n";
    exit(1);
}

// Check settings
$emailLogin = DB::table('settings'')->where('key', 'enable_email_login')->value('value');
echo "✅ Email login setting: " . ($emailLogin ?? 'not set') . "\n";

// Test Auth attempt
try {
    $credentials = ['email' => 'raj@example.com', 'password' => 'password123'];
    if (Auth::attempt($credentials)) {
        echo "✅ Auth::attempt() succeeded\n";
        
        $user = App\Models\User::where('email', 'raj@example.com')->first();
        $token = $user->createToken('test_token')->plainTextToken;
        echo "✅ Token created: " . substr($token, 0, 20) . "...\n";
    } else {
        echo "❌ Auth::attempt() failed\n";
    }
} catch (\Exception $e) {
    echo "❌ Auth test failed: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}

echo "\n✅ All tests completed\n";
