<?php

use App\Models\UserPlan;
use App\Http\Controllers\Admin\AlgorithmController;

echo "--- TESTING USER PLANS ---\n";
$plans = UserPlan::all();
foreach ($plans as $plan) {
    echo "Plan: {$plan->plan_name} | Price: {$plan->price} | Theme: {$plan->theme}\n";
    $savings = $plan->calculateSavings('yearly');
    echo "  Yearly Savings: {$savings['percentage']}%\n";
}

echo "\n--- TESTING ALGORITHM MOCK ---\n";
$controller = new AlgorithmController();
// Use reflection to access protected method if needed, or just call the public mocked endpoint
// Actually, let's call the public method getVIPSettings which returns mocked data from private method
$response = $controller->getVIPSettings();
echo "VIP Settings Response: " . json_encode($response->getData()) . "\n";

echo "\n--- TESTING AD LOGIC (Mock Ad) ---\n";
// Create a fake ad in memory to test model methods if possible, 
// strictly we'd need a DB record but we can inspect the model class presence
if (class_exists('App\Models\Ad')) {
    echo "Ad Model exists.\n";
}
