<?php

require __DIR__.'/vendor/autoload.php';

use App\Services\FirebaseService;
use Illuminate\Support\Facades\Log;

try {
    $service = new FirebaseService();
    
    echo "Checking configuration...\n";
    if (!$service->validateConfiguration()) {
        echo "FAIL: Configuration invalid.\n";
        exit(1);
    }
    echo "Configuration valid.\n";

    echo "Attempting to generate access token...\n";
    
    // We need to reflect to test the private getAccessToken method or just trust it works if we can instantiate credentials
    $credentialsFile = storage_path('app/firebase_credentials.json');
    if (!file_exists($credentialsFile)) {
        throw new Exception("File not found: $credentialsFile");
    }

    $json = json_decode(file_get_contents($credentialsFile), true);
    if (!isset($json['project_id'])) {
        throw new Exception("project_id missing in JSON");
    }
    
    echo "Project ID: " . $json['project_id'] . "\n";
    echo "Client Email: " . $json['client_email'] . "\n";
    echo "SUCCESS: Credentials file parses correctly.\n";

} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    exit(1);
}
