<?php

require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Api\PlansController;
use Illuminate\Support\Facades\DB;

// Mock Authenticated User
$user = User::where('email', 'test@clxpro.in')->first();
if (!$user) {
    echo "Test user not found.\n";
    exit(1);
}

// Find a plan to test (VIP Buyer). If not found, use any plan.
$plan = DB::table('user_plans')->where('plan_name', 'VIP Buyer')->first();
if (!$plan) {
    $plan = DB::table('user_plans')->first();
}

echo "Testing Activation for Plan: {$plan->plan_name} (ID: {$plan->id})\n";
echo "Original Price: {$plan->price}\n";
echo "Discount: {$plan->discount_percentage}%\n";

// Force Discount to 100% for this test if not already
if ($plan->discount_percentage != 100) {
    echo "Forcing discount to 100% for testing...\n";
    DB::table('user_plans')->where('id', $plan->id)->update(['discount_percentage' => 100]);
    $plan = DB::table('user_plans')->find($plan->id); // Reload
}

$request = Request::create("/api/plans/{$plan->id}/activate", 'POST');
$request->setUserResolver(function () use ($user) {
    return $user;
});

echo "Calling Activate API...\n";

try {
    $controller = new PlansController();
    $response = $controller->activate($request, $plan->id);
    
    echo "Status Code: " . $response->getStatusCode() . "\n";
    echo "Content:\n";
    echo $response->getContent() . "\n";

} catch (\Exception $e) {
    echo "❌ Exception: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . " Line: " . $e->getLine() . "\n";
    echo $e->getTraceAsString();
}
