

<?php $__env->startSection('title', 'Notifications'); ?>

<?php $__env->startSection('content'); ?>
<div class="dashboard-grid">
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">Notification Overview</h2>
            <div class="stat-icon">🔔</div>
        </div>
        <div class="card-value"><?php echo e($notifications->total()); ?></div>
        <div class="card-change">Total Notifications</div>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">Drafts</h2>
            <div class="stat-icon">📝</div>
        </div>
        <div class="card-value"><?php echo e($notifications->where('status', 'draft')->count()); ?></div>
        <div class="card-change">Ready to Send</div>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">Scheduled</h2>
            <div class="stat-icon">⏰</div>
        </div>
        <div class="card-value"><?php echo e($notifications->where('status', 'scheduled')->count()); ?></div>
        <div class="card-change">Upcoming</div>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">Sent</h2>
            <div class="stat-icon">✅</div>
        </div>
        <div class="card-value"><?php echo e($notifications->whereIn('status', ['sent', 'failed'])->count()); ?></div>
        <div class="card-change">Delivered</div>
    </div>
</div>

<div class="content-grid">
    <div class="chart-card">
        <div class="card-header">
            <h2 class="card-title">Notifications Management</h2>
            <div style="display: flex; gap: 8px;">
                <a href="<?php echo e(route('admin.notifications.create')); ?>" class="btn btn-primary">Create Notification</a>
                <a href="<?php echo e(route('admin.notifications.scheduled')); ?>" class="btn btn-secondary">Scheduled</a>
                <a href="<?php echo e(route('admin.notifications.sent')); ?>" class="btn btn-secondary">Sent</a>
            </div>
        </div>
        
        <?php if(!$firebaseConfigured): ?>
            <div style="background: #fef3c7; border: 1px solid #f59e0b; padding: 16px; border-radius: 8px; margin-bottom: 16px;">
                <div style="display: flex; align-items: center; gap: 12px;">
                    <span style="font-size: 24px;">⚠️</span>
                    <div>
                        <strong>Firebase Not Configured</strong>
                        <p style="margin: 4px 0 0 0; color: #7c2d12;">Push notifications require Firebase configuration. Please configure Firebase in Settings.</p>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Search and Filter Form -->
        <form method="GET" action="<?php echo e(route('admin.notifications.index')); ?>" style="margin-bottom: 20px; display: flex; gap: 12px; flex-wrap: wrap;">
            <div style="flex: 1; min-width: 300px;">
                <input type="text" name="search" value="<?php echo e(request('search')); ?>" placeholder="Search notifications..." style="width: 100%; padding: 8px 12px; border: 1px solid var(--border-color); border-radius: 6px;">
            </div>
            <div>
                <select name="status" style="padding: 8px 12px; border: 1px solid var(--border-color); border-radius: 6px;">
                    <option value="">All Status</option>
                    <option value="draft" <?php echo e(request('status') == 'draft' ? 'selected' : ''); ?>>Draft</option>
                    <option value="scheduled" <?php echo e(request('status') == 'scheduled' ? 'selected' : ''); ?>>Scheduled</option>
                    <option value="sending" <?php echo e(request('status') == 'sending' ? 'selected' : ''); ?>>Sending</option>
                    <option value="sent" <?php echo e(request('status') == 'sent' ? 'selected' : ''); ?>>Sent</option>
                    <option value="failed" <?php echo e(request('status') == 'failed' ? 'selected' : ''); ?>>Failed</option>
                </select>
            </div>
            <div>
                <select name="target_type" style="padding: 8px 12px; border: 1px solid var(--border-color); border-radius: 6px;">
                    <option value="">All Targets</option>
                    <option value="all" <?php echo e(request('target_type') == 'all' ? 'selected' : ''); ?>>All Users</option>
                    <option value="single_user" <?php echo e(request('target_type') == 'single_user' ? 'selected' : ''); ?>>Single User</option>
                    <option value="premium_plan" <?php echo e(request('target_type') == 'premium_plan' ? 'selected' : ''); ?>>Premium Plans</option>
                    <option value="custom" <?php echo e(request('target_type') == 'custom' ? 'selected' : ''); ?>>Custom</option>
                </select>
            </div>
            <div>
                <button type="submit" style="padding: 8px 16px; background: var(--primary-color); color: white; border: none; border-radius: 6px; cursor: pointer;">Filter</button>
                <a href="<?php echo e(route('admin.notifications.index')); ?>" style="padding: 8px 16px; background: var(--text-secondary); color: white; border: none; border-radius: 6px; cursor: pointer; text-decoration: none; margin-left: 8px;">Reset</a>
            </div>
        </form>

        <!-- Notifications Table -->
        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th>Title</th>
                        <th>Type</th>
                        <th>Target</th>
                        <th>Status</th>
                        <th>Scheduled</th>
                        <th>Sent</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <div>
                                    <strong><?php echo e($notification->title); ?></strong>
                                    <br><small style="color: var(--text-secondary);"><?php echo e(Str::limit($notification->message, 50)); ?></small>
                                </div>
                            </td>
                            <td>
                                <span class="status-badge" style="background: #e0e7ff; color: #3730a3;"><?php echo e($notification->targetTypeLabel); ?></span>
                            </td>
                            <td>
                                <?php if($notification->target_type === 'premium_plan'): ?>
                                    <?php if($notification->target_value && isset($notification->target_value['plan_types'])): ?>
                                        <?php $__currentLoopData = $notification->target_value['plan_types']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="status-badge" style="background: #f3e8ff; color: #7c3aed;"><?php echo e($plan); ?></span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <span class="status-badge" style="background: #f3e8ff; color: #7c3aed;">All Plans</span>
                                    <?php endif; ?>
                                <?php elseif($notification->target_type === 'single_user'): ?>
                                    <span class="status-badge" style="background: #dcfce7; color: #166534;">Single User</span>
                                <?php else: ?>
                                    <span class="status-badge" style="background: #e0f2fe; color: #0369a1;"><?php echo e(ucfirst($notification->target_type)); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php switch($notification->status):
                                    case ('draft'): ?>
                                        <span class="status-badge" style="background: #f3e8ff; color: #7c3aed;">Draft</span>
                                        <?php break; ?>
                                    <?php case ('scheduled'): ?>
                                        <span class="status-badge" style="background: #fef3c7; color: #d97706;">Scheduled</span>
                                        <?php break; ?>
                                    <?php case ('sending'): ?>
                                        <span class="status-badge" style="background: #e0e7ff; color: #3730a3;">Sending</span>
                                        <?php break; ?>
                                    <?php case ('sent'): ?>
                                        <span class="status-badge" style="background: #dcfce7; color: #166534;">Sent</span>
                                        <?php break; ?>
                                    <?php case ('failed'): ?>
                                        <span class="status-badge" style="background: #fee2e2; color: #dc2626;">Failed</span>
                                        <?php break; ?>
                                    <?php default: ?>
                                        <span class="status-badge" style="background: #e5e7eb; color: #374151;">Unknown</span>
                                <?php endswitch; ?>
                            </td>
                            <td><?php echo e($notification->scheduled_at ? $notification->scheduled_at->format('M d, Y H:i') : 'N/A'); ?></td>
                            <td><?php echo e($notification->sent_at ? $notification->sent_at->format('M d, Y H:i') : 'N/A'); ?></td>
                            <td>
                                <div style="display: flex; gap: 8px;">
                                    <a href="<?php echo e(route('admin.notifications.show', $notification)); ?>" class="btn btn-sm" style="background: #3b82f6; color: white; padding: 4px 8px; border-radius: 4px; text-decoration: none; font-size: 12px;">View</a>
                                    
                                    <?php if($notification->status === 'draft'): ?>
                                        <a href="<?php echo e(route('admin.notifications.edit', $notification)); ?>" class="btn btn-sm" style="background: #10b981; color: white; padding: 4px 8px; border-radius: 4px; text-decoration: none; font-size: 12px;">Edit</a>
                                        <form action="<?php echo e(route('admin.notifications.send', $notification)); ?>" method="POST" style="display: inline;">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="btn btn-sm" style="background: #8b5cf6; color: white; padding: 4px 8px; border-radius: 4px; border: none; font-size: 12px;">Send Now</button>
                                        </form>
                                    <?php endif; ?>
                                    
                                    <?php if($notification->status === 'scheduled'): ?>
                                        <a href="<?php echo e(route('admin.notifications.analytics', $notification)); ?>" class="btn btn-sm" style="background: #f59e0b; color: white; padding: 4px 8px; border-radius: 4px; text-decoration: none; font-size: 12px;">Analytics</a>
                                    <?php endif; ?>
                                    
                                    <form action="<?php echo e(route('admin.notifications.destroy', $notification)); ?>" method="POST" style="display: inline;">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm" style="background: #ef4444; color: white; padding: 4px 8px; border-radius: 4px; border: none; font-size: 12px;" onclick="return confirm('Are you sure?')">Delete</button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" style="text-align: center; color: var(--text-secondary); padding: 40px;">No notifications found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div style="margin-top: 20px;">
            <?php echo e($notifications->links()); ?>

        </div>
    </div>

    <div class="table-card">
        <div class="card-header">
            <h2 class="card-title">Quick Actions</h2>
        </div>
        
        <div style="display: flex; flex-direction: column; gap: 16px;">
            <div>
                <h3 style="margin: 0 0 12px 0; font-size: 1rem;">Create New Notification</h3>
                <p style="color: var(--text-secondary); margin: 0 0 16px 0;">Send targeted messages to your users with advanced targeting options.</p>
                <ul style="list-style: none; padding: 0; margin: 0;">
                    <li style="padding: 8px 0; border-bottom: 1px solid var(--border-color);">
                        <span style="font-weight: 600;">🎯 Targeting:</span> All users, specific users, or premium plan holders
                    </li>
                    <li style="padding: 8px 0; border-bottom: 1px solid var(--border-color);">
                        <span style="font-weight: 600;">⏰ Scheduling:</span> Send immediately or schedule for later
                    </li>
                    <li style="padding: 8px 0; border-bottom: 1px solid var(--border-color);">
                        <span style="font-weight: 600;">🔗 Deep Links:</span> Navigate users to specific app screens
                    </li>
                    <li style="padding: 8px 0;">
                        <span style="font-weight: 600;">📊 Analytics:</span> Track delivery, opens, and clicks
                    </li>
                </ul>
            </div>

            <div>
                <h3 style="margin: 0 0 12px 0; font-size: 1rem;">Targeting Examples</h3>
                <div style="display: grid; grid-template-columns: 1fr; gap: 8px;">
                    <div style="padding: 12px; background: var(--bg-color); border-radius: 8px;">
                        <strong>VIP Buyer Plan Users:</strong><br>
                        <small style="color: var(--text-secondary);">Target only users with VIP Buyer subscriptions</small>
                    </div>
                    <div style="padding: 12px; background: var(--bg-color); border-radius: 8px;">
                        <strong>Location-Based:</strong><br>
                        <small style="color: var(--text-secondary);">Send notifications to users in specific cities</small>
                    </div>
                    <div style="padding: 12px; background: var(--bg-color); border-radius: 8px;">
                        <strong>Category Interests:</strong><br>
                        <small style="color: var(--text-secondary);">Target users interested in specific ad categories</small>
                    </div>
                </div>
            </div>

            <div>
                <h3 style="margin: 0 0 12px 0; font-size: 1rem;">Firebase Status</h3>
                <div style="padding: 12px; border-radius: 8px; <?php echo e($firebaseConfigured ? 'background: #dcfce7; color: #166534; border: 1px solid #10b981;' : 'background: #fee2e2; color: #dc2626; border: 1px solid #ef4444;'); ?>">
                    <strong><?php echo e($firebaseConfigured ? '✅ Firebase Configured' : '❌ Firebase Not Configured'); ?></strong><br>
                    <small><?php echo e($firebaseConfigured ? 'Push notifications are ready to send.' : 'Configure Firebase in Settings to enable push notifications.'); ?></small>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
// Auto-refresh notifications status every 30 seconds
setInterval(function() {
    location.reload();
}, 30000);
</script>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\DND\Apps\CLXpro\clx_backend\resources\views/admin/notifications/index.blade.php ENDPATH**/ ?>