

<?php $__env->startSection('title', 'Payment Gateways'); ?>

<?php $__env->startSection('content'); ?>
<div class="dashboard-grid" style="grid-template-columns: 1fr; gap: 24px;">
    
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 8px;">
        <div>
            <h2 style="margin: 0; font-size: 1.5rem; font-weight: 600; color: var(--text-primary);">Payment Settings</h2>
            <p style="margin: 4px 0 0 0; color: var(--text-secondary); font-size: 14px;">Manage payment gateways and configurations</p>
        </div>
        <a href="<?php echo e(route('admin.settings.index')); ?>" style="padding: 10px 20px; background: var(--bg-color); color: var(--text-secondary); border: 1px solid var(--border-color); border-radius: 8px; cursor: pointer; font-weight: 600; text-decoration: none; display: flex; align-items: center; gap: 8px;">
            <span>⬅️</span> Back to Settings
        </a>
    </div>

    <?php if(session('success')): ?>
        <div style="padding: 16px; background: #dcfce7; border: 1px solid #86efac; border-radius: 8px; color: #166534; margin-bottom: 16px;">
            ✅ <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <div class="dashboard-grid" style="grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 20px;">
        <?php $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="card" style="display: flex; flex-direction: column; height: 100%;">
                <div class="card-header" style="padding: 20px; border-bottom: 1px solid var(--border-color);">
                    <div style="display: flex; align-items: center; gap: 12px;">
                        <div style="width: 40px; height: 40px; background: #f3f4f6; border-radius: 8px; display: flex; align-items: center; justify-content: center; font-size: 20px;">
                            <?php if($gateway->slug == 'stripe'): ?> 💳 
                            <?php elseif($gateway->slug == 'razorpay'): ?> 🇮🇳 
                            <?php elseif($gateway->slug == 'paypal'): ?> 🅿️ 
                            <?php elseif($gateway->slug == 'paytm'): ?> 🛍️ 
                            <?php elseif($gateway->slug == 'phonepe'): ?> 📱 
                            <?php else: ?> 💰 <?php endif; ?>
                        </div>
                        <div>
                            <h3 style="margin: 0; font-size: 1.1rem; color: var(--text-primary);"><?php echo e($gateway->name); ?></h3>
                            <div style="display: flex; align-items: center; gap: 6px; margin-top: 4px;">
                                <?php if($gateway->is_active): ?>
                                    <span class="status-badge status-active">Active</span>
                                <?php else: ?>
                                    <span class="status-badge status-inactive">Inactive</span>
                                <?php endif; ?>
                                
                                <?php if($gateway->is_test_mode): ?>
                                    <span style="font-size: 11px; padding: 2px 6px; background: #fef3c7; color: #d97706; border-radius: 4px; font-weight: 600;">TEST MODE</span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div style="padding: 20px; flex: 1;">
                    <p style="margin: 0 0 16px 0; color: var(--text-secondary); font-size: 14px; line-height: 1.5;">
                        <?php echo e($gateway->description); ?>

                    </p>
                    
                    <div style="margin-bottom: 16px;">
                        <div style="font-size: 13px; font-weight: 600; color: var(--text-primary); margin-bottom: 8px;">Supported Currencies</div>
                        <div style="display: flex; flex-wrap: wrap; gap: 6px;">
                            <?php if($gateway->supported_currencies): ?>
                                <?php $__currentLoopData = $gateway->supported_currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span style="font-size: 11px; padding: 2px 8px; background: var(--bg-color); border: 1px solid var(--border-color); border-radius: 4px; color: var(--text-secondary);"><?php echo e($currency); ?></span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <div style="padding: 20px; border-top: 1px solid var(--border-color); display: flex; gap: 12px;">
                    <a href="<?php echo e(route('admin.payment-gateways.edit', $gateway)); ?>" style="flex: 1; padding: 10px; background: var(--primary-color); color: white; text-align: center; border-radius: 6px; text-decoration: none; font-weight: 600;">
                        Manage Settings
                    </a>
                    
                    <form action="<?php echo e(route('admin.payment-gateways.toggle-status', $gateway)); ?>" method="POST" style="display: inline;">
                        <?php echo csrf_field(); ?>
                        <button type="button" onclick="toggleGatewayStatus('<?php echo e($gateway->id); ?>')" style="padding: 10px; background: var(--bg-color); border: 1px solid var(--border-color); border-radius: 6px; cursor: pointer;" title="Toggle Status">
                            <?php if($gateway->is_active): ?> 🛑 <?php else: ?> ▶️ <?php endif; ?>
                        </button>
                    </form>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>

<script>
function toggleGatewayStatus(id) {
    if(confirm('Are you sure you want to change the status of this gateway?')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = `/admin/payment-gateways/${id}/toggle-status`;
        
        const csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = '_token';
        csrfToken.value = '<?php echo e(csrf_token()); ?>';
        form.appendChild(csrfToken);
        
        document.body.appendChild(form);
        
        // Use fetch instead of submitting form to handle JSON response if needed, 
        // but for now simple refresh is fine
        fetch(form.action, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Content-Type': 'application/json',
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if(data.success) {
                window.location.reload();
            } else {
                alert('Error: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred');
        });
    }
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\DND\Apps\CLXpro\clx_backend\resources\views/admin/payment_gateways/index.blade.php ENDPATH**/ ?>