

<?php $__env->startSection('title', 'Safety & Security'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12 mb-4">
        <h3>Safety & Security Dashboard</h3>
        <p class="text-muted">Manage platform safety, algorithms, and user reports.</p>
    </div>
</div>

<div class="dashboard-grid">
    <!-- Ad Reports -->
    <a href="<?php echo e(route('admin.safety.reports')); ?>" class="card" style="text-decoration: none;">
        <div class="card-header">
            <div>
                <div class="card-title">Ad Reports</div>
                <div class="card-value"><?php echo e(\App\Models\AdReport::where('status', 'pending')->count()); ?></div>
            </div>
            <div class="stat-icon">🚩</div>
        </div>
        <div class="card-change">Pending Reports</div>
    </a>

    <!-- Algorithm Settings -->
    <a href="<?php echo e(route('admin.safety.algorithm_settings')); ?>" class="card" style="text-decoration: none;">
        <div class="card-header">
            <div>
                <div class="card-title">Algorithm Settings</div>
                <div class="card-value">⚙️</div>
            </div>
            <div class="stat-icon">🤖</div>
        </div>
        <div class="card-change">Configure Safety Algo</div>
    </a>

    <!-- Trust Management -->
    <a href="<?php echo e(route('admin.safety.trust_management')); ?>" class="card" style="text-decoration: none;">
        <div class="card-header">
            <div>
                <div class="card-title">Trust Management</div>
                <div class="card-value">🛡️</div>
            </div>
            <div class="stat-icon">✅</div>
        </div>
        <div class="card-change">User Trust Scores</div>
    </a>
</div>

<div class="row mt-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h3>System Status</h3>
            </div>
            <div class="card-body">
                <div class="d-flex align-items-center gap-3">
                    <div class="status-badge status-active">System Active</div>
                    <div class="text-muted">Safety algorithm is running normally.</div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\DND\Apps\CLXpro\clx_backend\resources\views/admin/safety/index.blade.php ENDPATH**/ ?>