

<?php $__env->startSection('title', 'Trust Score Management'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card" style="margin-bottom: 24px;">
        <div class="card-header">
            <h3 style="margin: 0; font-size: 1.1rem; color: var(--text-primary);">Trust Score Management</h3>
            <div style="font-size: 0.875rem; color: var(--text-secondary);">Manually manage and edit user trust scores</div>
        </div>
        
        <div style="padding: 20px;">
            <div style="display: flex; flex-wrap: wrap; gap: 16px; align-items: center; margin-bottom: 20px;">
                <!-- Search and Filter Controls -->
                <div style="display: flex; gap: 8px; align-items: center; flex: 1; min-width: 300px;">
                    <input type="text" id="userSearch" placeholder="Search users by name or email..." style="flex: 1; padding: 8px 12px; border: 1px solid var(--border-color); border-radius: 6px;">
                    <button onclick="searchUsers()" style="padding: 8px 16px; background: #3b82f6; color: white; border: none; border-radius: 6px; cursor: pointer;">Search</button>
                    <button onclick="clearSearch()" style="padding: 8px 16px; background: #6b7280; color: white; border: none; border-radius: 6px; cursor: pointer;">Clear</button>
                </div>

                <div style="display: flex; gap: 8px; align-items: center;">
                    <label style="font-size: 0.875rem; color: var(--text-secondary); font-weight: 600;">Filter by Tier:</label>
                    <select id="tierFilter" style="padding: 8px 12px; border: 1px solid var(--border-color); border-radius: 6px;">
                        <option value="all">All Tiers</option>
                        <option value="legend">Legend (85-100)</option>
                        <option value="elite">Elite (70-84)</option>
                        <option value="highly_trusted">Highly Trusted (50-69)</option>
                        <option value="trusted">Trusted (30-49)</option>
                        <option value="new">New (0-29)</option>
                    </select>
                </div>

                <div style="display: flex; gap: 8px; align-items: center;">
                    <label style="font-size: 0.875rem; color: var(--text-secondary); font-weight: 600;">Sort by:</label>
                    <select id="sortFilter" style="padding: 8px 12px; border: 1px solid var(--border-color); border-radius: 6px;">
                        <option value="score_desc">Score (High to Low)</option>
                        <option value="score_asc">Score (Low to High)</option>
                        <option value="name_asc">Name (A to Z)</option>
                        <option value="name_desc">Name (Z to A)</option>
                        <option value="last_updated">Last Updated</option>
                    </select>
                </div>
            </div>

            <!-- Bulk Actions -->
            <div style="display: flex; gap: 12px; align-items: center; margin-bottom: 20px; padding: 16px; background: #f8fafc; border-radius: 8px; border: 1px solid var(--border-color);">
                <label style="font-weight: 600; color: var(--text-primary);">Bulk Actions:</label>
                <select id="bulkAction" style="padding: 8px 12px; border: 1px solid var(--border-color); border-radius: 6px;">
                    <option value="">Select Action</option>
                    <option value="adjust_score">Adjust Trust Score</option>
                    <option value="reset_penalties">Reset Penalty Points</option>
                    <option value="promote_tier">Promote to Higher Tier</option>
                    <option value="demote_tier">Demote to Lower Tier</option>
                    <option value="suspend_user">Suspend User</option>
                    <option value="unsuspend_user">Unsuspend User</option>
                </select>
                <input type="number" id="bulkScoreAdjustment" placeholder="Score adjustment" style="width: 150px; padding: 8px 12px; border: 1px solid var(--border-color); border-radius: 6px; display: none;">
                <input type="number" id="bulkSuspensionDays" placeholder="Suspension days" style="width: 150px; padding: 8px 12px; border: 1px solid var(--border-color); border-radius: 6px; display: none;">
                <button onclick="applyBulkAction()" style="padding: 8px 16px; background: #10b981; color: white; border: none; border-radius: 6px; cursor: pointer;">Apply to Selected</button>
                <button onclick="selectAllUsers()" style="padding: 8px 16px; background: #3b82f6; color: white; border: none; border-radius: 6px; cursor: pointer;">Select All</button>
                <button onclick="clearSelection()" style="padding: 8px 16px; background: #6b7280; color: white; border: none; border-radius: 6px; cursor: pointer;">Clear Selection</button>
            </div>

            <!-- Trust Score Statistics -->
            <div class="dashboard-grid" style="margin-bottom: 24px;">
                <div class="card">
                    <div class="card-header">
                        <h4 style="margin: 0; font-size: 1rem; color: var(--text-primary);">Legend Users</h4>
                        <div style="font-size: 0.875rem; color: var(--text-secondary);">Users with 85+ trust score</div>
                    </div>
                    <div style="padding: 16px;">
                        <div style="text-align: center; padding: 20px;">
                            <div style="font-size: 2rem; font-weight: 700; color: #FFD700; margin-bottom: 8px;" id="legendCount">0</div>
                            <div style="font-size: 0.875rem; color: var(--text-secondary);">Legend Tier Users</div>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h4 style="margin: 0; font-size: 1rem; color: var(--text-primary);">High Risk Users</h4>
                        <div style="font-size: 0.875rem; color: var(--text-secondary);">Users with 0-29 trust score</div>
                    </div>
                    <div style="padding: 16px;">
                        <div style="text-align: center; padding: 20px;">
                            <div style="font-size: 2rem; font-weight: 700; color: var(--danger-color); margin-bottom: 8px;" id="highRiskCount">0</div>
                            <div style="font-size: 0.875rem; color: var(--text-secondary);">High Risk Users</div>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h4 style="margin: 0; font-size: 1rem; color: var(--text-primary);">Average Trust Score</h4>
                        <div style="font-size: 0.875rem; color: var(--text-secondary);">Platform average</div>
                    </div>
                    <div style="padding: 16px;">
                        <div style="text-align: center; padding: 20px;">
                            <div style="font-size: 2rem; font-weight: 700; color: var(--primary-color); margin-bottom: 8px;" id="averageScore">0</div>
                            <div style="font-size: 0.875rem; color: var(--text-secondary);">Average Score</div>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h4 style="margin: 0; font-size: 1rem; color: var(--text-primary);">Total Users</h4>
                        <div style="font-size: 0.875rem; color: var(--text-secondary);">Users with trust scores</div>
                    </div>
                    <div style="padding: 16px;">
                        <div style="text-align: center; padding: 20px;">
                            <div style="font-size: 2rem; font-weight: 700; color: var(--text-primary); margin-bottom: 8px;" id="totalUsers">0</div>
                            <div style="font-size: 0.875rem; color: var(--text-secondary);">Total Users</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- User Trust Score Table -->
            <div class="table-card" style="border: none; padding: 0;">
                <table class="table">
                    <thead>
                        <tr>
                            <th style="width: 50px;">
                                <input type="checkbox" id="selectAllUsers" style="width: 16px; height: 16px;">
                            </th>
                            <th>User</th>
                            <th>Trust Score</th>
                            <th>Tier</th>
                            <th>Breakdown</th>
                            <th>Penalty Points</th>
                            <th>Status</th>
                            <th>Last Updated</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody id="trustScoresTableBody">
                        <!-- Trust scores will be loaded here -->
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div style="display: flex; justify-content: space-between; align-items: center; margin-top: 20px; padding-top: 20px; border-top: 1px solid var(--border-color);">
                <div style="color: var(--text-secondary); font-size: 0.875rem;">
                    Showing <span id="trustShowingStart">1</span> to <span id="trustShowingEnd">20</span> of <span id="trustTotalCount">0</span> users
                </div>
                <div style="display: flex; gap: 8px; align-items: center;">
                    <button id="prevTrustPage" onclick="changeTrustPage(-1)" style="padding: 6px 12px; border: 1px solid var(--border-color); border-radius: 6px; background: white; cursor: pointer;">Previous</button>
                    <div id="trustPageNumbers" style="display: flex; gap: 4px;">
                        <!-- Page numbers will be generated here -->
                    </div>
                    <button id="nextTrustPage" onclick="changeTrustPage(1)" style="padding: 6px 12px; border: 1px solid var(--border-color); border-radius: 6px; background: white; cursor: pointer;">Next</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Trust Score Edit Modal -->
    <div id="editTrustScoreModal" class="modal" style="display: none;">
        <div class="modal-content" style="max-width: 600px;">
            <div class="modal-header">
                <h3 style="margin: 0;">Edit Trust Score</h3>
                <button onclick="hideEditTrustScoreModal()" style="background: none; border: none; font-size: 24px; cursor: pointer;">×</button>
            </div>
            <div id="editTrustScoreContent" style="padding: 20px;">
                <!-- Content will be loaded here -->
            </div>
        </div>
    </div>

    <script>
        // State management
        let trustScores = [];
        let filteredScores = [];
        let currentPage = 1;
        let pageSize = 20;
        let selectedUsers = new Set();

        // Initialize dashboard
        document.addEventListener('DOMContentLoaded', function() {
            loadTrustScores();
            setupEventListeners();
        });

        // Load Trust Scores
        function loadTrustScores() {
            const tierFilter = document.getElementById('tierFilter').value;
            const sortFilter = document.getElementById('sortFilter').value;
            
            let url = '/api/admin/safety/trust-scores';
            if (tierFilter !== 'all') url += `?tier=${tierFilter}`;
            if (sortFilter) url += tierFilter !== 'all' ? `&sort=${sortFilter}` : `?sort=${sortFilter}`;

            fetch(url)
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        trustScores = data.trust_scores;
                        filteredScores = [...trustScores];
                        updateStatistics();
                        applySort();
                        renderTrustScores();
                        updatePagination();
                    }
                })
                .catch(error => console.error('Error loading trust scores:', error));
        }

        // Update Statistics
        function updateStatistics() {
            const legendCount = trustScores.filter(s => s.score >= 85).length;
            const highRiskCount = trustScores.filter(s => s.score < 30).length;
            const averageScore = trustScores.length > 0 ? Math.round(trustScores.reduce((sum, s) => sum + s.score, 0) / trustScores.length) : 0;
            const totalUsers = trustScores.length;

            document.getElementById('legendCount').textContent = legendCount;
            document.getElementById('highRiskCount').textContent = highRiskCount;
            document.getElementById('averageScore').textContent = averageScore;
            document.getElementById('totalUsers').textContent = totalUsers;
        }

        // Apply Sort
        function applySort() {
            const sortValue = document.getElementById('sortFilter').value;
            
            filteredScores.sort((a, b) => {
                switch (sortValue) {
                    case 'score_desc':
                        return b.score - a.score;
                    case 'score_asc':
                        return a.score - b.score;
                    case 'name_asc':
                        return (a.user?.name || '').localeCompare(b.user?.name || '');
                    case 'name_desc':
                        return (b.user?.name || '').localeCompare(a.user?.name || '');
                    case 'last_updated':
                        return new Date(b.last_calculated) - new Date(a.last_calculated);
                    default:
                        return 0;
                }
            });
        }

        // Render Trust Scores Table
        function renderTrustScores() {
            const tbody = document.getElementById('trustScoresTableBody');
            tbody.innerHTML = '';

            const startIndex = (currentPage - 1) * pageSize;
            const endIndex = startIndex + pageSize;
            const pageScores = filteredScores.slice(startIndex, endIndex);

            pageScores.forEach(score => {
                const row = document.createElement('tr');
                row.innerHTML = `
                    <td><input type="checkbox" class="user-checkbox" data-user-id="${score.user_id}" style="width: 16px; height: 16px;"></td>
                    <td>
                        <div style="font-weight: 600; color: var(--text-primary);">${score.user?.name || 'Unknown'}</div>
                        <div style="font-size: 0.875rem; color: var(--text-secondary);">${score.user?.email || ''}</div>
                    </td>
                    <td style="font-weight: 600; color: ${getTrustScoreColor(score.score)};">${score.score}</td>
                    <td><span class="status-badge ${getTierClass(score.tier)}">${score.tier}</span></td>
                    <td>
                        <div style="font-size: 0.875rem; color: var(--text-secondary);">History: ${score.breakdown?.transaction_history || 0}</div>
                        <div style="font-size: 0.875rem; color: var(--text-secondary);">Quality: ${score.breakdown?.content_quality || 0}</div>
                        <div style="font-size: 0.875rem; color: var(--text-secondary);">Behavior: ${score.breakdown?.behavior || 0}</div>
                    </td>
                    <td style="font-weight: 600; color: var(--text-primary);">${score.penalty_points}</td>
                    <td>
                        <span class="status-badge ${score.user?.is_suspended ? 'status-inactive' : 'status-active'}">
                            ${score.user?.is_suspended ? 'Suspended' : 'Active'}
                        </span>
                    </td>
                    <td style="font-size: 0.875rem; color: var(--text-secondary);">${formatDate(score.last_calculated)}</td>
                    <td>
                        <div style="display: flex; gap: 8px;">
                            <button onclick="editTrustScore(${score.user_id})" style="padding: 4px 8px; background: #10b981; color: white; border: none; border-radius: 4px; font-size: 0.75rem; cursor: pointer;">Edit</button>
                            <button onclick="adjustTrustScore(${score.user_id})" style="padding: 4px 8px; background: #f59e0b; color: white; border: none; border-radius: 4px; font-size: 0.75rem; cursor: pointer;">Adjust</button>
                            <button onclick="resetPenalties(${score.user_id})" style="padding: 4px 8px; background: #3b82f6; color: white; border: none; border-radius: 4px; font-size: 0.75rem; cursor: pointer;">Reset Penalties</button>
                        </div>
                    </td>
                `;
                tbody.appendChild(row);
            });

            // Update select all checkbox
            const checkboxes = document.querySelectorAll('.user-checkbox');
            const selectAll = document.getElementById('selectAllUsers');
            selectAll.checked = checkboxes.length > 0 && Array.from(checkboxes).every(cb => cb.checked);
        }

        // Edit Trust Score
        function editTrustScore(userId) {
            const score = trustScores.find(s => s.user_id === userId);
            if (!score) return;

            const modal = document.getElementById('editTrustScoreModal');
            const content = document.getElementById('editTrustScoreContent');
            
            content.innerHTML = `
                <div style="display: grid; gap: 16px;">
                    <div>
                        <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">User: ${score.user?.name || 'Unknown'}</label>
                        <div style="font-size: 0.875rem; color: var(--text-secondary);">${score.user?.email || ''}</div>
                    </div>

                    <div>
                        <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Current Trust Score: ${score.score}</label>
                        <input type="range" id="editScore" min="0" max="100" value="${score.score}" style="width: 100%;">
                        <div style="display: flex; justify-content: space-between; font-size: 0.875rem; color: var(--text-secondary);">
                            <span>0</span>
                            <span id="editScoreValue">${score.score}</span>
                            <span>100</span>
                        </div>
                    </div>

                    <div>
                        <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Penalty Points: ${score.penalty_points}</label>
                        <input type="number" id="editPenaltyPoints" value="${score.penalty_points}" style="width: 100%; padding: 8px 12px; border: 1px solid var(--border-color); border-radius: 6px;">
                    </div>

                    <div>
                        <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Breakdown Analysis</label>
                        <div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 12px; background: #f8fafc; padding: 12px; border-radius: 8px; border: 1px solid var(--border-color);">
                            <div>
                                <label style="font-size: 0.875rem; color: var(--text-secondary);">Transaction History</label>
                                <input type="number" id="editTransaction" value="${score.breakdown?.transaction_history || 0}" min="0" max="30" style="width: 100%; padding: 6px; border: 1px solid var(--border-color); border-radius: 4px;">
                            </div>
                            <div>
                                <label style="font-size: 0.875rem; color: var(--text-secondary);">Account Maturity</label>
                                <input type="number" id="editMaturity" value="${score.breakdown?.account_maturity || 0}" min="0" max="20" style="width: 100%; padding: 6px; border: 1px solid var(--border-color); border-radius: 4px;">
                            </div>
                            <div>
                                <label style="font-size: 0.875rem; color: var(--text-secondary);">Content Quality</label>
                                <input type="number" id="editContent" value="${score.breakdown?.content_quality || 0}" min="0" max="25" style="width: 100%; padding: 6px; border: 1px solid var(--border-color); border-radius: 4px;">
                            </div>
                            <div>
                                <label style="font-size: 0.875rem; color: var(--text-secondary);">Behavior Analysis</label>
                                <input type="number" id="editBehavior" value="${score.breakdown?.behavior || 0}" min="0" max="15" style="width: 100%; padding: 6px; border: 1px solid var(--border-color); border-radius: 4px;">
                            </div>
                            <div>
                                <label style="font-size: 0.875rem; color: var(--text-secondary);">Security Features</label>
                                <input type="number" id="editSecurity" value="${score.breakdown?.security || 0}" min="0" max="10" style="width: 100%; padding: 6px; border: 1px solid var(--border-color); border-radius: 4px;">
                            </div>
                            <div>
                                <label style="font-size: 0.875rem; color: var(--text-secondary);">Total</label>
                                <div id="editTotal" style="padding: 6px; background: white; border: 1px solid var(--border-color); border-radius: 4px; font-weight: 600;">${score.score}</div>
                            </div>
                        </div>
                    </div>

                    <div>
                        <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Reason for Change</label>
                        <textarea id="editReason" rows="3" placeholder="Enter reason for trust score change..." style="width: 100%; padding: 8px 12px; border: 1px solid var(--border-color); border-radius: 6px;"></textarea>
                    </div>

                    <div style="display: flex; gap: 12px; justify-content: flex-end;">
                        <button onclick="hideEditTrustScoreModal()" style="padding: 8px 16px; background: #6b7280; color: white; border: none; border-radius: 6px; cursor: pointer;">Cancel</button>
                        <button onclick="saveTrustScoreEdit(${userId})" style="padding: 8px 16px; background: #10b981; color: white; border: none; border-radius: 6px; cursor: pointer;">Save Changes</button>
                    </div>
                </div>
            `;

            // Setup event listeners for the edit form
            document.getElementById('editScore').addEventListener('input', function(e) {
                document.getElementById('editScoreValue').textContent = e.target.value;
            });

            ['editTransaction', 'editMaturity', 'editContent', 'editBehavior', 'editSecurity'].forEach(id => {
                document.getElementById(id).addEventListener('input', updateEditTotal);
            });

            modal.style.display = 'flex';
        }

        function updateEditTotal() {
            const total = ['editTransaction', 'editMaturity', 'editContent', 'editBehavior', 'editSecurity']
                .reduce((sum, id) => sum + parseInt(document.getElementById(id).value || 0), 0);
            document.getElementById('editTotal').textContent = total;
        }

        function saveTrustScoreEdit(userId) {
            const newScore = parseInt(document.getElementById('editScore').value);
            const penaltyPoints = parseInt(document.getElementById('editPenaltyPoints').value);
            const reason = document.getElementById('editReason').value;
            
            const breakdown = {
                transaction_history: parseInt(document.getElementById('editTransaction').value),
                account_maturity: parseInt(document.getElementById('editMaturity').value),
                content_quality: parseInt(document.getElementById('editContent').value),
                behavior: parseInt(document.getElementById('editBehavior').value),
                security: parseInt(document.getElementById('editSecurity').value)
            };

            // In a real implementation, this would make an API call
            console.log('Saving trust score edit:', { userId, newScore, penaltyPoints, reason, breakdown });
            alert('Trust score updated successfully!');
            hideEditTrustScoreModal();
            loadTrustScores();
        }

        function hideEditTrustScoreModal() {
            document.getElementById('editTrustScoreModal').style.display = 'none';
        }

        // Helper Functions
        function getTrustScoreColor(score) {
            if (score >= 85) return '#FFD700';
            if (score >= 70) return '#4F46E5';
            if (score >= 50) return '#10B981';
            if (score >= 30) return '#3B82F6';
            return '#6B7280';
        }

        function getTierClass(tier) {
            const classes = {
                'legend': 'status-active',
                'elite': 'status-active',
                'highly_trusted': 'status-active',
                'trusted': 'status-pending',
                'new': 'status-expired'
            };
            return classes[tier] || 'status-expired';
        }

        function formatDate(dateString) {
            if (!dateString) return 'Never';
            const date = new Date(dateString);
            return date.toLocaleDateString('en-US', { month: 'short', day: 'numeric', year: 'numeric' });
        }

        // Event Listeners
        function setupEventListeners() {
            document.getElementById('tierFilter').addEventListener('change', function() {
                filteredScores = trustScores.filter(s => this.value === 'all' || s.tier === this.value);
                applySort();
                currentPage = 1;
                renderTrustScores();
                updatePagination();
            });

            document.getElementById('sortFilter').addEventListener('change', function() {
                applySort();
                renderTrustScores();
            });

            document.getElementById('selectAllUsers').addEventListener('change', function() {
                const checkboxes = document.querySelectorAll('.user-checkbox');
                checkboxes.forEach(cb => {
                    cb.checked = this.checked;
                    if (this.checked) {
                        selectedUsers.add(parseInt(cb.dataset.userId));
                    } else {
                        selectedUsers.clear();
                    }
                });
            });

            document.getElementById('bulkAction').addEventListener('change', function() {
                const adjustmentInput = document.getElementById('bulkScoreAdjustment');
                const suspensionInput = document.getElementById('bulkSuspensionDays');
                
                adjustmentInput.style.display = this.value === 'adjust_score' ? 'block' : 'none';
                suspensionInput.style.display = this.value.includes('suspend') ? 'block' : 'none';
            });
        }

        // Bulk Actions
        function selectAllUsers() {
            const checkboxes = document.querySelectorAll('.user-checkbox');
            checkboxes.forEach(cb => {
                cb.checked = true;
                selectedUsers.add(parseInt(cb.dataset.userId));
            });
        }

        function clearSelection() {
            const checkboxes = document.querySelectorAll('.user-checkbox');
            checkboxes.forEach(cb => {
                cb.checked = false;
            });
            selectedUsers.clear();
        }

        function applyBulkAction() {
            const action = document.getElementById('bulkAction').value;
            const adjustment = parseInt(document.getElementById('bulkScoreAdjustment').value) || 0;
            const suspensionDays = parseInt(document.getElementById('bulkSuspensionDays').value) || 0;

            if (selectedUsers.size === 0) {
                alert('Please select users first.');
                return;
            }

            if (action === 'adjust_score' && adjustment === 0) {
                alert('Please enter a score adjustment value.');
                return;
            }

            if (action.includes('suspend') && suspensionDays === 0) {
                alert('Please enter suspension days.');
                return;
            }

            // In a real implementation, this would make API calls
            console.log('Applying bulk action:', { action, adjustment, suspensionDays, users: Array.from(selectedUsers) });
            alert(`Bulk action "${action}" applied to ${selectedUsers.size} users.`);
            loadTrustScores();
        }

        // Placeholder functions for other actions
        function adjustTrustScore(userId) {
            alert('Adjust trust score for user: ' + userId);
        }

        function resetPenalties(userId) {
            alert('Reset penalties for user: ' + userId);
        }

        function searchUsers() {
            alert('Search functionality would be implemented here.');
        }

        function clearSearch() {
            alert('Clear search functionality would be implemented here.');
        }

        function changeTrustPage(direction) {
            const totalPages = Math.ceil(filteredScores.length / pageSize);
            currentPage = Math.max(1, Math.min(totalPages, currentPage + direction));
            renderTrustScores();
            updatePagination();
        }

        function updatePagination() {
            const totalPages = Math.ceil(filteredScores.length / pageSize);
            const startIndex = (currentPage - 1) * pageSize + 1;
            const endIndex = Math.min(startIndex + pageSize - 1, filteredScores.length);
            const total = filteredScores.length;

            document.getElementById('trustShowingStart').textContent = startIndex;
            document.getElementById('trustShowingEnd').textContent = endIndex;
            document.getElementById('trustTotalCount').textContent = total;

            // Update pagination buttons
            document.getElementById('prevTrustPage').disabled = currentPage === 1;
            document.getElementById('nextTrustPage').disabled = currentPage === totalPages;
        }
    </script>

    <style>
        /* Modal styles */
        .modal {
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            display: flex;
            justify-content: center;
            align-items: center;
            backdrop-filter: blur(2px);
        }

        .modal-content {
            background-color: var(--card-bg);
            border-radius: 12px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.3);
            border: 1px solid var(--border-color);
            max-width: 90vw;
            max-height: 90vh;
            overflow-y: auto;
            animation: modalSlideIn 0.3s ease-out;
            position: relative;
            margin: 0 auto;
        }

        @keyframes modalSlideIn {
            from {
                opacity: 0;
                transform: translateY(-20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .modal-header {
            padding: 20px 20px;
            border-bottom: 1px solid var(--border-color);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\DND\Apps\CLXpro\clx_backend\resources\views/admin/safety/trust_management.blade.php ENDPATH**/ ?>