

<?php $__env->startSection('title', 'Safety Algorithm Settings'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card" style="margin-bottom: 24px;">
        <div class="card-header">
            <h3 style="margin: 0; font-size: 1.1rem; color: var(--text-primary);">Safety Algorithm Configuration</h3>
            <div style="font-size: 0.875rem; color: var(--text-secondary);">Configure and fine-tune the AI-powered safety detection algorithms</div>
        </div>
        
        <div style="padding: 20px;">
            <form id="algorithmSettingsForm">
                <div class="dashboard-grid">
                    <!-- Scam Detection Thresholds -->
                    <div class="card">
                        <div class="card-header">
                            <h4 style="margin: 0; font-size: 1rem; color: var(--text-primary);">Scam Detection Thresholds</h4>
                            <div style="font-size: 0.875rem; color: var(--text-secondary);">Configure confidence levels for automated actions</div>
                        </div>
                        <div style="padding: 16px;">
                            <div style="display: grid; gap: 16px;">
                                <div>
                                    <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">High Confidence Threshold</label>
                                    <input type="range" id="highConfidenceThreshold" min="70" max="95" value="80" style="width: 100%;">
                                    <div style="display: flex; justify-content: space-between; font-size: 0.875rem; color: var(--text-secondary);">
                                        <span>70%</span>
                                        <span id="highConfidenceValue">80%</span>
                                        <span>95%</span>
                                    </div>
                                    <div style="font-size: 0.75rem; color: var(--text-secondary); margin-top: 4px;">Auto-suspend users (no manual review)</div>
                                </div>

                                <div>
                                    <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Medium Confidence Threshold</label>
                                    <input type="range" id="mediumConfidenceThreshold" min="40" max="80" value="60" style="width: 100%;">
                                    <div style="display: flex; justify-content: space-between; font-size: 0.875rem; color: var(--text-secondary);">
                                        <span>40%</span>
                                        <span id="mediumConfidenceValue">60%</span>
                                        <span>80%</span>
                                    </div>
                                    <div style="font-size: 0.75rem; color: var(--text-secondary); margin-top: 4px;">Auto-suspend + manual review required</div>
                                </div>

                                <div>
                                    <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Low Confidence Threshold</label>
                                    <input type="range" id="lowConfidenceThreshold" min="20" max="60" value="40" style="width: 100%;">
                                    <div style="display: flex; justify-content: space-between; font-size: 0.875rem; color: var(--text-secondary);">
                                        <span>20%</span>
                                        <span id="lowConfidenceValue">40%</span>
                                        <span>60%</span>
                                    </div>
                                    <div style="font-size: 0.75rem; color: var(--text-secondary); margin-top: 4px;">Warning + monitoring</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Trust Score Weights -->
                    <div class="card">
                        <div class="card-header">
                            <h4 style="margin: 0; font-size: 1rem; color: var(--text-primary);">Trust Score Weights</h4>
                            <div style="font-size: 0.875rem; color: var(--text-secondary);">Configure scoring algorithm weights (must total 100%)</div>
                        </div>
                        <div style="padding: 16px;">
                            <div style="display: grid; gap: 16px;">
                                <div>
                                    <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Transaction History (20%)</label>
                                    <input type="range" id="transactionWeight" min="10" max="50" value="20" style="width: 100%;">
                                    <div style="display: flex; justify-content: space-between; font-size: 0.875rem; color: var(--text-secondary);">
                                        <span>10%</span>
                                        <span id="transactionWeightValue">20%</span>
                                        <span>50%</span>
                                    </div>
                                    <div style="font-size: 0.75rem; color: var(--text-secondary); margin-top: 4px;">Completed sales and transaction volume</div>
                                </div>

                                <div>
                                    <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Reputation & Reviews (20%)</label>
                                    <input type="range" id="reputationWeight" min="5" max="40" value="20" style="width: 100%;">
                                    <div style="display: flex; justify-content: space-between; font-size: 0.875rem; color: var(--text-secondary);">
                                        <span>5%</span>
                                        <span id="reputationWeightValue">20%</span>
                                        <span>40%</span>
                                    </div>
                                    <div style="font-size: 0.75rem; color: var(--text-secondary); margin-top: 4px;">Average rating and review volume</div>
                                </div>

                                <div>
                                    <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Account Maturity (15%)</label>
                                    <input type="range" id="maturityWeight" min="5" max="30" value="15" style="width: 100%;">
                                    <div style="display: flex; justify-content: space-between; font-size: 0.875rem; color: var(--text-secondary);">
                                        <span>5%</span>
                                        <span id="maturityWeightValue">15%</span>
                                        <span>30%</span>
                                    </div>
                                    <div style="font-size: 0.75rem; color: var(--text-secondary); margin-top: 4px;">Account age and activity history</div>
                                </div>

                                <div>
                                    <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Content Quality (20%)</label>
                                    <input type="range" id="contentWeight" min="10" max="40" value="20" style="width: 100%;">
                                    <div style="display: flex; justify-content: space-between; font-size: 0.875rem; color: var(--text-secondary);">
                                        <span>10%</span>
                                        <span id="contentWeightValue">20%</span>
                                        <span>40%</span>
                                    </div>
                                    <div style="font-size: 0.75rem; color: var(--text-secondary); margin-top: 4px;">Ad quality and description completeness</div>
                                </div>

                                <div>
                                    <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Behavior Analysis (15%)</label>
                                    <input type="range" id="behaviorWeight" min="5" max="30" value="15" style="width: 100%;">
                                    <div style="display: flex; justify-content: space-between; font-size: 0.875rem; color: var(--text-secondary);">
                                        <span>5%</span>
                                        <span id="behaviorWeightValue">15%</span>
                                        <span>30%</span>
                                    </div>
                                    <div style="font-size: 0.75rem; color: var(--text-secondary); margin-top: 4px;">User behavior and safety reports</div>
                                </div>

                                <div>
                                    <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Security Features (10%)</label>
                                    <input type="range" id="securityWeight" min="0" max="20" value="10" style="width: 100%;">
                                    <div style="display: flex; justify-content: space-between; font-size: 0.875rem; color: var(--text-secondary);">
                                        <span>0%</span>
                                        <span id="securityWeightValue">10%</span>
                                        <span>20%</span>
                                    </div>
                                    <div style="font-size: 0.75rem; color: var(--text-secondary); margin-top: 4px;">Phone verification and ID verification</div>
                                </div>

                                <div style="padding: 12px; background: #f8fafc; border-radius: 8px; border: 1px solid var(--border-color);">
                                    <div style="display: flex; justify-content: space-between; font-weight: 600;">
                                        <span>Total Weight:</span>
                                        <span id="totalWeight" style="color: var(--success-color);">100%</span>
                                    </div>
                                    <div id="weightStatus" style="font-size: 0.875rem; color: var(--text-secondary); margin-top: 4px;">Weights are balanced</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Scam Keywords -->
                    <div class="card" style="grid-column: span 2;">
                        <div class="card-header">
                            <h4 style="margin: 0; font-size: 1rem; color: var(--text-primary);">Scam Keyword Detection</h4>
                            <div style="font-size: 0.875rem; color: var(--text-secondary);">Manage keywords that trigger scam detection</div>
                        </div>
                        <div style="padding: 16px;">
                            <div style="display: flex; gap: 16px; margin-bottom: 16px;">
                                <input type="text" id="newKeyword" placeholder="Add new scam keyword..." style="flex: 1; padding: 8px 12px; border: 1px solid var(--border-color); border-radius: 6px;">
                                <button type="button" onclick="addScamKeyword()" style="padding: 8px 16px; background: #3b82f6; color: white; border: none; border-radius: 6px; cursor: pointer;">Add Keyword</button>
                            </div>
                            
                            <div id="keywordList" style="display: grid; grid-template-columns: repeat(4, 1fr); gap: 8px;">
                                <!-- Keywords will be loaded here -->
                            </div>
                        </div>
                    </div>

                    <!-- Penalty Points Configuration -->
                    <div class="card">
                        <div class="card-header">
                            <h4 style="margin: 0; font-size: 1rem; color: var(--text-primary);">Penalty Points System</h4>
                            <div style="font-size: 0.875rem; color: var(--text-secondary);">Configure penalty point values for different violations</div>
                        </div>
                        <div style="padding: 16px;">
                            <div style="display: grid; gap: 16px;">
                                <div>
                                    <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Safety Report Penalty</label>
                                    <input type="range" id="reportPenalty" min="1" max="20" value="10" style="width: 100%;">
                                    <div style="display: flex; justify-content: space-between; font-size: 0.875rem; color: var(--text-secondary);">
                                        <span>1 point</span>
                                        <span id="reportPenaltyValue">10 points</span>
                                        <span>20 points</span>
                                    </div>
                                </div>

                                <div>
                                    <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Warning Penalty</label>
                                    <input type="range" id="warningPenalty" min="1" max="15" value="5" style="width: 100%;">
                                    <div style="display: flex; justify-content: space-between; font-size: 0.875rem; color: var(--text-secondary);">
                                        <span>1 point</span>
                                        <span id="warningPenaltyValue">5 points</span>
                                        <span>15 points</span>
                                    </div>
                                </div>

                                <div>
                                    <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Suspension Penalty</label>
                                    <input type="range" id="suspensionPenalty" min="5" max="50" value="25" style="width: 100%;">
                                    <div style="display: flex; justify-content: space-between; font-size: 0.875rem; color: var(--text-secondary);">
                                        <span>5 points</span>
                                        <span id="suspensionPenaltyValue">25 points</span>
                                        <span>50 points</span>
                                    </div>
                                </div>

                                <div>
                                    <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Active Suspension Multiplier</label>
                                    <input type="range" id="suspensionMultiplier" min="1" max="5" value="2" style="width: 100%;">
                                    <div style="display: flex; justify-content: space-between; font-size: 0.875rem; color: var(--text-secondary);">
                                        <span>x1</span>
                                        <span id="suspensionMultiplierValue">x2</span>
                                        <span>x5</span>
                                    </div>
                                    <div style="font-size: 0.75rem; color: var(--text-secondary); margin-top: 4px;">Multiplier applied to penalties for active suspensions</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Trust Tier Thresholds -->
                    <div class="card">
                        <div class="card-header">
                            <h4 style="margin: 0; font-size: 1rem; color: var(--text-primary);">Trust Tier Thresholds</h4>
                            <div style="font-size: 0.875rem; color: var(--text-secondary);">Configure score ranges for each trust tier</div>
                        </div>
                        <div style="padding: 16px;">
                            <div style="display: grid; gap: 16px;">
                                <div>
                                    <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Legend Tier (85-100)</label>
                                    <input type="range" id="legendThreshold" min="75" max="95" value="85" style="width: 100%;">
                                    <div style="display: flex; justify-content: space-between; font-size: 0.875rem; color: var(--text-secondary);">
                                        <span>75%</span>
                                        <span id="legendThresholdValue">85%</span>
                                        <span>95%</span>
                                    </div>
                                </div>

                                <div>
                                    <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Elite Tier (70-84)</label>
                                    <input type="range" id="eliteThreshold" min="60" max="80" value="70" style="width: 100%;">
                                    <div style="display: flex; justify-content: space-between; font-size: 0.875rem; color: var(--text-secondary);">
                                        <span>60%</span>
                                        <span id="eliteThresholdValue">70%</span>
                                        <span>80%</span>
                                    </div>
                                </div>

                                <div>
                                    <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Highly Trusted (50-69)</label>
                                    <input type="range" id="highlyTrustedThreshold" min="40" max="65" value="50" style="width: 100%;">
                                    <div style="display: flex; justify-content: space-between; font-size: 0.875rem; color: var(--text-secondary);">
                                        <span>40%</span>
                                        <span id="highlyTrustedThresholdValue">50%</span>
                                        <span>65%</span>
                                    </div>
                                </div>

                                <div>
                                    <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Trusted Tier (30-49)</label>
                                    <input type="range" id="trustedThreshold" min="20" max="50" value="30" style="width: 100%;">
                                    <div style="display: flex; justify-content: space-between; font-size: 0.875rem; color: var(--text-secondary);">
                                        <span>20%</span>
                                        <span id="trustedThresholdValue">30%</span>
                                        <span>50%</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Save Controls -->
                <div style="display: flex; justify-content: space-between; align-items: center; margin-top: 24px; padding-top: 20px; border-top: 1px solid var(--border-color);">
                    <div style="color: var(--text-secondary); font-size: 0.875rem;">
                        Changes are saved automatically. Algorithm updates take effect immediately.
                    </div>
                    <div style="display: flex; gap: 12px;">
                        <button type="button" onclick="resetToDefaults()" style="padding: 8px 16px; background: #ef4444; color: white; border: none; border-radius: 6px; cursor: pointer;">Reset to Defaults</button>
                        <button type="submit" style="padding: 8px 16px; background: #10b981; color: white; border: none; border-radius: 6px; cursor: pointer;">Save Settings</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Algorithm Performance Section -->
    <div class="card" style="margin-bottom: 24px;">
        <div class="card-header">
            <h3 style="margin: 0; font-size: 1.1rem; color: var(--text-primary);">Algorithm Performance</h3>
            <div style="font-size: 0.875rem; color: var(--text-secondary);">Monitor and analyze algorithm effectiveness</div>
        </div>
        
        <div style="padding: 20px;">
            <div class="dashboard-grid">
                <div class="card">
                    <div class="card-header">
                        <h4 style="margin: 0; font-size: 1rem; color: var(--text-primary);">Detection Accuracy</h4>
                        <div style="font-size: 0.875rem; color: var(--text-secondary);">Current algorithm performance metrics</div>
                    </div>
                    <div style="padding: 16px;">
                        <div style="text-align: center; padding: 20px;">
                            <div style="font-size: 2rem; font-weight: 700; color: var(--success-color); margin-bottom: 8px;">87%</div>
                            <div style="font-size: 0.875rem; color: var(--text-secondary);">Overall Detection Accuracy</div>
                            <div style="font-size: 0.75rem; color: var(--text-secondary); margin-top: 4px;">Based on last 1000 reports</div>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h4 style="margin: 0; font-size: 1rem; color: var(--text-primary);">False Positives</h4>
                        <div style="font-size: 0.875rem; color: var(--text-secondary);">Incorrect scam detections</div>
                    </div>
                    <div style="padding: 16px;">
                        <div style="text-align: center; padding: 20px;">
                            <div style="font-size: 2rem; font-weight: 700; color: var(--warning-color); margin-bottom: 8px;">3.2%</div>
                            <div style="font-size: 0.875rem; color: var(--text-secondary);">False Positive Rate</div>
                            <div style="font-size: 0.75rem; color: var(--text-secondary); margin-top: 4px;">Within acceptable range</div>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h4 style="margin: 0; font-size: 1rem; color: var(--text-primary);">Response Time</h4>
                        <div style="font-size: 0.875rem; color: var(--text-secondary);">Average processing time</div>
                    </div>
                    <div style="padding: 16px;">
                        <div style="text-align: center; padding: 20px;">
                            <div style="font-size: 2rem; font-weight: 700; color: var(--primary-color); margin-bottom: 8px;">2.1s</div>
                            <div style="font-size: 0.875rem; color: var(--text-secondary);">Average Processing Time</div>
                            <div style="font-size: 0.75rem; color: var(--text-secondary); margin-top: 4px;">Real-time detection</div>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h4 style="margin: 0; font-size: 1rem; color: var(--text-primary);">Coverage</h4>
                        <div style="font-size: 0.875rem; color: var(--text-secondary);">Reports processed automatically</div>
                    </div>
                    <div style="padding: 16px;">
                        <div style="text-align: center; padding: 20px;">
                            <div style="font-size: 2rem; font-weight: 700; color: var(--text-primary); margin-bottom: 8px;">94%</div>
                            <div style="font-size: 0.875rem; color: var(--text-secondary);">Automated Processing</div>
                            <div style="font-size: 0.75rem; color: var(--text-secondary); margin-top: 4px;">Manual review required for complex cases</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Algorithm Settings Management
        let currentSettings = {
            thresholds: {
                high: 80,
                medium: 60,
                low: 40
            },
            weights: {
                transaction: 30,
                maturity: 20,
                content: 25,
                behavior: 15,
                security: 10
            },
            penalties: {
                report: 10,
                warning: 5,
                suspension: 25,
                multiplier: 2
            },
            tiers: {
                legend: 85,
                elite: 70,
                highlyTrusted: 50,
                trusted: 30
            },
            keywords: [
                'urgent', 'too good', 'send money', 'wire transfer', 'advance fee',
                'lottery', 'inheritance', 'prize', 'winner', 'congratulations',
                'act now', 'limited time', 'immediate payment', 'bank transfer',
                'western union', 'gift card', 'paypal', 'bitcoin', 'crypto'
            ]
        };

        // Initialize form values
        document.addEventListener('DOMContentLoaded', function() {
            loadCurrentSettings();
            updateKeywordList();
            setupEventListeners();
        });

        function loadCurrentSettings() {
            // Load from localStorage or use defaults
            const saved = localStorage.getItem('safetyAlgorithmSettings');
            if (saved) {
                currentSettings = JSON.parse(saved);
            }
            updateFormValues();
        }

        function updateFormValues() {
            // Update threshold values
            document.getElementById('highConfidenceThreshold').value = currentSettings.thresholds.high;
            document.getElementById('mediumConfidenceThreshold').value = currentSettings.thresholds.medium;
            document.getElementById('lowConfidenceThreshold').value = currentSettings.thresholds.low;

            // Update weight values
            document.getElementById('transactionWeight').value = currentSettings.weights.transaction;
            document.getElementById('maturityWeight').value = currentSettings.weights.maturity;
            document.getElementById('contentWeight').value = currentSettings.weights.content;
            document.getElementById('behaviorWeight').value = currentSettings.weights.behavior;
            document.getElementById('securityWeight').value = currentSettings.weights.security;

            // Update penalty values
            document.getElementById('reportPenalty').value = currentSettings.penalties.report;
            document.getElementById('warningPenalty').value = currentSettings.penalties.warning;
            document.getElementById('suspensionPenalty').value = currentSettings.penalties.suspension;
            document.getElementById('suspensionMultiplier').value = currentSettings.penalties.multiplier;

            // Update tier values
            document.getElementById('legendThreshold').value = currentSettings.tiers.legend;
            document.getElementById('eliteThreshold').value = currentSettings.tiers.elite;
            document.getElementById('highlyTrustedThreshold').value = currentSettings.tiers.highlyTrusted;
            document.getElementById('trustedThreshold').value = currentSettings.tiers.trusted;

            updateDisplayValues();
            updateWeightTotal();
        }

        function updateDisplayValues() {
            // Update threshold displays
            document.getElementById('highConfidenceValue').textContent = currentSettings.thresholds.high + '%';
            document.getElementById('mediumConfidenceValue').textContent = currentSettings.thresholds.medium + '%';
            document.getElementById('lowConfidenceValue').textContent = currentSettings.thresholds.low + '%';

            // Update weight displays
            document.getElementById('transactionWeightValue').textContent = currentSettings.weights.transaction + '%';
            document.getElementById('maturityWeightValue').textContent = currentSettings.weights.maturity + '%';
            document.getElementById('contentWeightValue').textContent = currentSettings.weights.content + '%';
            document.getElementById('behaviorWeightValue').textContent = currentSettings.weights.behavior + '%';
            document.getElementById('securityWeightValue').textContent = currentSettings.weights.security + '%';

            // Update penalty displays
            document.getElementById('reportPenaltyValue').textContent = currentSettings.penalties.report + ' points';
            document.getElementById('warningPenaltyValue').textContent = currentSettings.penalties.warning + ' points';
            document.getElementById('suspensionPenaltyValue').textContent = currentSettings.penalties.suspension + ' points';
            document.getElementById('suspensionMultiplierValue').textContent = 'x' + currentSettings.penalties.multiplier;

            // Update tier displays
            document.getElementById('legendThresholdValue').textContent = currentSettings.tiers.legend + '%';
            document.getElementById('eliteThresholdValue').textContent = currentSettings.tiers.elite + '%';
            document.getElementById('highlyTrustedThresholdValue').textContent = currentSettings.tiers.highlyTrusted + '%';
            document.getElementById('trustedThresholdValue').textContent = currentSettings.tiers.trusted + '%';
        }

        function updateWeightTotal() {
            const total = Object.values(currentSettings.weights).reduce((sum, weight) => sum + weight, 0);
            const totalElement = document.getElementById('totalWeight');
            const statusElement = document.getElementById('weightStatus');
            
            totalElement.textContent = total + '%';
            
            if (total === 100) {
                totalElement.style.color = 'var(--success-color)';
                statusElement.textContent = 'Weights are balanced';
                statusElement.style.color = 'var(--text-secondary)';
            } else {
                totalElement.style.color = 'var(--danger-color)';
                statusElement.textContent = 'Weights must total 100%';
                statusElement.style.color = 'var(--danger-color)';
            }
        }

        function setupEventListeners() {
            // Threshold listeners
            document.getElementById('highConfidenceThreshold').addEventListener('input', function(e) {
                currentSettings.thresholds.high = parseInt(e.target.value);
                updateDisplayValues();
            });

            document.getElementById('mediumConfidenceThreshold').addEventListener('input', function(e) {
                currentSettings.thresholds.medium = parseInt(e.target.value);
                updateDisplayValues();
            });

            document.getElementById('lowConfidenceThreshold').addEventListener('input', function(e) {
                currentSettings.thresholds.low = parseInt(e.target.value);
                updateDisplayValues();
            });

            // Weight listeners
            ['transactionWeight', 'maturityWeight', 'contentWeight', 'behaviorWeight', 'securityWeight'].forEach(id => {
                document.getElementById(id).addEventListener('input', function(e) {
                    const key = id.replace('Weight', '').toLowerCase();
                    currentSettings.weights[key] = parseInt(e.target.value);
                    updateDisplayValues();
                    updateWeightTotal();
                });
            });

            // Penalty listeners
            ['reportPenalty', 'warningPenalty', 'suspensionPenalty', 'suspensionMultiplier'].forEach(id => {
                document.getElementById(id).addEventListener('input', function(e) {
                    const key = id.replace('Penalty', '').replace('Multiplier', '');
                    currentSettings.penalties[key] = parseInt(e.target.value);
                    updateDisplayValues();
                });
            });

            // Tier listeners
            ['legendThreshold', 'eliteThreshold', 'highlyTrustedThreshold', 'trustedThreshold'].forEach(id => {
                document.getElementById(id).addEventListener('input', function(e) {
                    const key = id.replace('Threshold', '').toLowerCase();
                    currentSettings.tiers[key] = parseInt(e.target.value);
                    updateDisplayValues();
                });
            });
        }

        function addScamKeyword() {
            const input = document.getElementById('newKeyword');
            const keyword = input.value.trim().toLowerCase();
            
            if (keyword && !currentSettings.keywords.includes(keyword)) {
                currentSettings.keywords.push(keyword);
                input.value = '';
                updateKeywordList();
                saveSettings();
            }
        }

        function removeScamKeyword(keyword) {
            currentSettings.keywords = currentSettings.keywords.filter(k => k !== keyword);
            updateKeywordList();
            saveSettings();
        }

        function updateKeywordList() {
            const container = document.getElementById('keywordList');
            container.innerHTML = '';
            
            currentSettings.keywords.forEach(keyword => {
                const div = document.createElement('div');
                div.style.padding = '8px 12px';
                div.style.border = '1px solid var(--border-color)';
                div.style.borderRadius = '6px';
                div.style.display = 'flex';
                div.style.justifyContent = 'space-between';
                div.style.alignItems = 'center';
                div.style.background = '#f8fafc';
                
                div.innerHTML = `
                    <span style="font-weight: 500;">${keyword}</span>
                    <button onclick="removeScamKeyword('${keyword}')" style="background: none; border: none; color: var(--danger-color); cursor: pointer; font-size: 14px;">✕</button>
                `;
                
                container.appendChild(div);
            });
        }

        function saveSettings() {
            localStorage.setItem('safetyAlgorithmSettings', JSON.stringify(currentSettings));
            // In a real implementation, this would also save to the database
            console.log('Settings saved:', currentSettings);
        }

        function resetToDefaults() {
            if (confirm('Reset all algorithm settings to defaults? This cannot be undone.')) {
                currentSettings = {
                    thresholds: { high: 80, medium: 60, low: 40 },
                    weights: { transaction: 30, maturity: 20, content: 25, behavior: 15, security: 10 },
                    penalties: { report: 10, warning: 5, suspension: 25, multiplier: 2 },
                    tiers: { legend: 85, elite: 70, highlyTrusted: 50, trusted: 30 },
                    keywords: ['urgent', 'too good', 'send money', 'wire transfer', 'advance fee', 'lottery', 'inheritance', 'prize', 'winner', 'congratulations', 'act now', 'limited time', 'immediate payment', 'bank transfer', 'western union', 'gift card', 'paypal', 'bitcoin', 'crypto']
                };
                updateFormValues();
                updateKeywordList();
                saveSettings();
            }
        }

        // Form submission
        document.getElementById('algorithmSettingsForm').addEventListener('submit', function(e) {
            e.preventDefault();
            saveSettings();
            alert('Algorithm settings saved successfully!');
        });
    </script>

    <style>
        /* Additional styles for algorithm settings */
        .card-header h4 {
            margin: 0;
            font-size: 1rem;
            color: var(--text-primary);
        }
    </style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\DND\Apps\CLXpro\clx_backend\resources\views/admin/safety/algorithm_settings.blade.php ENDPATH**/ ?>