

<?php $__env->startSection('title', 'Location Settings'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card" style="margin-bottom: 24px;">
        <div class="card-header">
            <h3 style="margin: 0; font-size: 1.1rem; color: var(--text-primary);">Location Services Management</h3>
            <div style="font-size: 0.875rem; color: var(--text-secondary);">Configure location providers and services</div>
        </div>
        
        <div style="padding: 20px;">
            <!-- Location Provider Configuration -->
            <div style="margin-bottom: 32px;">
                <h4 style="margin: 0 0 16px 0; color: var(--text-primary); font-size: 1rem;">Location Provider Settings</h4>
                
                <!-- Location Range Configuration -->
                <div class="card" style="margin-bottom: 24px; padding: 20px;">
                    <div class="card-title" style="margin-bottom: 16px;">Search Radius Configuration</div>
                    <form action="<?php echo e(route('admin.settings.general.update')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 16px;">
                            <div>
                                <label>Min Range (km)</label>
                                <input type="number" name="location_range_min" value="<?php echo e($settings['location_range_min'] ?? 5); ?>" min="1">
                            </div>
                            <div>
                                <label>Max Range (km)</label>
                                <input type="number" name="location_range_max" value="<?php echo e($settings['location_range_max'] ?? 500); ?>" min="1">
                            </div>
                            <div>
                                <label>Default Range (km)</label>
                                <input type="number" name="location_range_default" value="<?php echo e($settings['location_range_default'] ?? 50); ?>" min="1">
                            </div>
                        </div>
                        <div style="margin-top: 16px; text-align: right;">
                             <button type="submit" style="padding: 10px 20px; background: var(--primary-color); color: white; border: none; border-radius: 6px; cursor: pointer;">Save Ranges</button>
                        </div>
                    </form>
                </div>
                
                <div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 16px;">
                    <!-- Free Location Service -->
                    <div class="card">
                        <div class="card-header">
                            <div>
                                <div class="card-title">Free Location Service</div>
                                <div class="card-value">OpenStreetMap</div>
                            </div>
                            <div class="stat-icon">🌍</div>
                        </div>
                        <div style="padding: 16px;">
                            <div style="display: flex; align-items: center; justify-content: space-between; margin-bottom: 12px;">
                                <span style="color: var(--text-secondary); font-size: 0.875rem;">Service Status</span>
                                <?php if(($settings['location_provider'] ?? 'osm') == 'osm'): ?>
                                    <span class="status-badge status-active">Active</span>
                                <?php else: ?>
                                    <span class="status-badge status-inactive">Inactive</span>
                                <?php endif; ?>
                            </div>
                            <div style="color: var(--text-secondary); font-size: 0.875rem; margin-bottom: 16px;">
                                Uses OpenStreetMap Nominatim API for free location services. No API key required.
                            </div>
                            <div style="display: flex; gap: 8px;">
                                <button style="padding: 8px 16px; background: #3b82f6; color: white; border: none; border-radius: 6px; cursor: pointer;">Test Service</button>
                                <button style="padding: 8px 16px; background: #ef4444; color: white; border: none; border-radius: 6px; cursor: pointer;">Disable</button>
                            </div>
                        </div>
                    </div>

                    <!-- Google Maps Service -->
                    <div class="card">
                        <div class="card-header">
                            <div>
                                <div class="card-title">Google Maps Service</div>
                                <div class="card-value">Premium</div>
                            </div>
                            <div class="stat-icon">🗺️</div>
                        </div>
                        <div style="padding: 16px;">
                            <div style="display: flex; align-items: center; justify-content: space-between; margin-bottom: 12px;">
                                <span style="color: var(--text-secondary); font-size: 0.875rem;">Service Status</span>
                                <?php if(($settings['location_provider'] ?? '') == 'google'): ?>
                                    <span class="status-badge status-active">Active</span>
                                <?php else: ?>
                                    <span class="status-badge status-inactive">Inactive</span>
                                <?php endif; ?>
                            </div>
                            <div style="color: var(--text-secondary); font-size: 0.875rem; margin-bottom: 16px;">
                                Uses Google Maps Geocoding API for premium location services. Requires API key.
                            </div>
                            <div style="display: flex; gap: 8px;">
                                <button style="padding: 8px 16px; background: #3b82f6; color: white; border: none; border-radius: 6px; cursor: pointer;">Configure</button>
                                <button style="padding: 8px 16px; background: #10b981; color: white; border: none; border-radius: 6px; cursor: pointer;">Enable</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Google Maps API Configuration -->
            <div style="margin-bottom: 32px;">
                <h4 style="margin: 0 0 16px 0; color: var(--text-primary); font-size: 1rem;">Google Maps API Configuration</h4>
                
                <div class="card">
                    <div style="padding: 20px;">
                        <form action="<?php echo e(route('admin.settings.general.update')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 16px;">
                                <div style="margin-bottom: 16px;">
                                    <label style="display: block; margin-bottom: 8px; font-weight: 600;">API Key</label>
                                    <input type="password" name="google_maps_api_key" value="<?php echo e($settings['google_maps_api_key'] ?? ''); ?>" placeholder="Enter Google Maps API Key" style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px;">
                                    <div style="margin-top: 8px; color: var(--text-secondary); font-size: 0.875rem;">
                                        Get your API key from <a href="https://console.cloud.google.com/" target="_blank" style="color: var(--primary-color);">Google Cloud Console</a>
                                    </div>
                                </div>
                                
                                <div style="margin-bottom: 16px;">
                                    <label style="display: block; margin-bottom: 8px; font-weight: 600;">Active Provider</label>
                                    <select name="location_provider" style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px;">
                                        <option value="osm" <?php echo e(($settings['location_provider'] ?? 'osm') == 'osm' ? 'selected' : ''); ?>>OpenStreetMap (Free)</option>
                                        <option value="google" <?php echo e(($settings['location_provider'] ?? '') == 'google' ? 'selected' : ''); ?>>Google Maps (Premium)</option>
                                    </select>
                                </div>
                            </div>

                            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 16px;">
                                <div style="margin-bottom: 16px;">
                                    <label style="display: block; margin-bottom: 8px; font-weight: 600;">Enabled Services</label>
                                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 8px;">
                                        <!-- Hidden inputs for unchecked state (must be before checkboxes) -->
                                        <input type="hidden" name="google_maps_geocoding_enabled" value="0">
                                        <input type="hidden" name="google_maps_places_enabled" value="0">
                                        <input type="hidden" name="google_maps_js_enabled" value="0">
                                        <input type="hidden" name="google_maps_geolocation_enabled" value="0">

                                        <label style="display: flex; align-items: center; gap: 8px; padding: 8px; border: 1px solid var(--border-color); border-radius: 6px;">
                                            <input type="checkbox" name="google_maps_geocoding_enabled" value="1" <?php echo e(($settings['google_maps_geocoding_enabled'] ?? '') ? 'checked' : ''); ?>>
                                            <span>Geocoding API</span>
                                        </label>
                                        <label style="display: flex; align-items: center; gap: 8px; padding: 8px; border: 1px solid var(--border-color); border-radius: 6px;">
                                            <input type="checkbox" name="google_maps_places_enabled" value="1" <?php echo e(($settings['google_maps_places_enabled'] ?? '') ? 'checked' : ''); ?>>
                                            <span>Places API</span>
                                        </label>
                                        <label style="display: flex; align-items: center; gap: 8px; padding: 8px; border: 1px solid var(--border-color); border-radius: 6px;">
                                            <input type="checkbox" name="google_maps_js_enabled" value="1" <?php echo e(($settings['google_maps_js_enabled'] ?? '') ? 'checked' : ''); ?>>
                                            <span>Maps JavaScript API</span>
                                        </label>
                                        <label style="display: flex; align-items: center; gap: 8px; padding: 8px; border: 1px solid var(--border-color); border-radius: 6px;">
                                            <input type="checkbox" name="google_maps_geolocation_enabled" value="1" <?php echo e(($settings['google_maps_geolocation_enabled'] ?? '') ? 'checked' : ''); ?>>
                                            <span>Geolocation API</span>
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <div style="display: flex; gap: 12px; justify-content: flex-end; margin-top: 20px;">
                                <button type="submit" style="padding: 12px 24px; background: var(--primary-color); color: white; border: none; border-radius: 8px; cursor: pointer;">Save Settings</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Location Service Status -->
            <div style="margin-bottom: 32px;">
                <h4 style="margin: 0 0 16px 0; color: var(--text-primary); font-size: 1rem;">Service Status & Monitoring</h4>
                <div class="dashboard-grid">
                    <div class="card">
                        <div class="card-header">
                            <div>
                                <div class="card-title">Provider Status</div>
                                <div class="card-value"><?php echo e(ucfirst($settings['location_provider'] ?? 'osm')); ?></div>
                            </div>
                            <div class="stat-icon">
                                <?php if(($settings['location_provider'] ?? 'osm') == 'google'): ?>
                                    🗺️
                                <?php else: ?>
                                    🌍
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="card-change">Currently Active</div>
                    </div>
                 </div>
            </div>

    <!-- Location Services Scripts -->
    <script>
        // Location Services Management
        document.addEventListener('DOMContentLoaded', function() {
             // Basic UI enhancements if needed
        });
    </script>

    <style>
        .status-badge {
            padding: 4px 8px;
            border-radius: 6px;
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
        }

        .status-active {
            background: #dcfce7;
            color: #10b981;
        }

        .status-inactive {
            background: #fee2e2;
            color: #ef4444;
        }

        .status-pending {
            background: #fef3c7;
            color: #f59e0b;
        }

        /* Enhanced card styling for location settings */
        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 16px;
        }

        .card-title {
            font-weight: 600;
            font-size: 1rem;
            color: var(--text-primary);
        }

        .card-value {
            font-size: 0.875rem;
            color: var(--text-secondary);
        }

        .stat-icon {
            font-size: 1.5rem;
            opacity: 0.8;
        }

        .card-change {
            font-size: 0.875rem;
            color: var(--text-secondary);
            margin-top: 4px;
        }

        /* Form styling */
        label {
            font-weight: 600;
            color: var(--text-primary);
            margin-bottom: 8px;
            display: block;
        }

        input[type="text"],
        input[type="password"],
        input[type="number"],
        select {
            width: 100%;
            padding: 12px;
            border: 1px solid var(--border-color);
            border-radius: 8px;
            font-size: 0.875rem;
            transition: border-color 0.2s ease;
        }

        input[type="text"]:focus,
        input[type="password"]:focus,
        input[type="number"]:focus,
        select:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
        }

        /* Mobile responsive */
        @media (max-width: 768px) {
            .dashboard-grid {
                grid-template-columns: 1fr;
            }
            
            .card-header {
                flex-direction: column;
                align-items: flex-start;
                gap: 8px;
            }
        }
    </style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\DND\Apps\CLXpro\clx_backend\resources\views/admin/settings/location.blade.php ENDPATH**/ ?>