

<?php $__env->startSection('title', 'Pages Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="dashboard-grid" style="grid-template-columns: 1fr; gap: 24px;">
    
    <!-- Header -->
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 16px;">
        <div>
            <h2 style="margin: 0; font-size: 1.5rem; font-weight: 600; color: var(--text-primary);">Pages Management</h2>
            <p style="margin: 4px 0 0 0; color: var(--text-secondary); font-size: 14px;">Manage static pages for your app</p>
        </div>
        <a href="<?php echo e(route('admin.pages.create')); ?>" style="padding: 10px 20px; background: var(--success-color); color: white; border: none; border-radius: 8px; cursor: pointer; font-weight: 600; text-decoration: none; display: flex; align-items: center; gap: 8px;">
            <span>➕</span> Add New Page
        </a>
    </div>

    <?php if(session('success')): ?>
        <div style="padding: 16px; background: #dcfce7; border: 1px solid #86efac; border-radius: 8px; color: #166534; margin-bottom: 16px;">
            ✅ <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <!-- Pages Table -->
    <div class="card">
        <?php if($pages->count() > 0): ?>
            <div style="overflow-x: auto;">
                <table class="table">
                    <thead>
                        <tr>
                            <th style="width: 5%;">Order</th>
                            <th style="width: 20%;">Title</th>
                            <th style="width: 20%;">Slug</th>
                            <th style="width: 10%;">Status</th>
                            <th style="width: 10%; text-align: center;">Show in App</th>
                            <th style="width: 15%;">Last Updated</th>
                            <th style="width: 15%; text-align: center;">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td style="font-weight: 600; color: var(--text-secondary);"><?php echo e($page->order); ?></td>
                                <td style="font-weight: 600;">
                                    <?php if($page->meta && isset($page->meta['icon'])): ?>
                                        <span style="margin-right: 6px;"><?php echo e($page->meta['icon']); ?></span>
                                    <?php endif; ?>
                                    <?php echo e($page->title); ?>

                                    <?php if($page->is_system_page): ?>
                                        <span style="display: inline-block; margin-left: 8px; padding: 2px 8px; background: #e0e7ff; color: #4338ca; border-radius: 4px; font-size: 11px; font-weight: 600;">SYSTEM</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <code style="background: var(--bg-color); padding: 4px 8px; border-radius: 4px; font-size: 12px;"><?php echo e($page->slug); ?></code>
                                </td>
                                <td>
                                    <?php if($page->is_active): ?>
                                        <span class="status-badge status-active">Active</span>
                                    <?php else: ?>
                                        <span class="status-badge status-inactive">Inactive</span>
                                    <?php endif; ?>
                                </td>
                                <td style="text-align: center;">
                                    <label class="toggle-switch" title="<?php echo e($page->show_in_app ? 'Visible in app' : 'Hidden from app'); ?>">
                                        <input type="checkbox" 
                                               data-page-id="<?php echo e($page->id); ?>" 
                                               class="show-in-app-toggle"
                                               <?php echo e($page->show_in_app ? 'checked' : ''); ?>>
                                        <span class="toggle-slider"></span>
                                    </label>
                                </td>
                                <td style="color: var(--text-secondary); font-size: 13px;">
                                    <?php echo e($page->updated_at->diffForHumans()); ?>

                                </td>
                                <td>
                                    <div style="display: flex; gap: 8px; justify-content: center;">
                                        <a href="<?php echo e(route('admin.pages.edit', $page)); ?>" style="padding: 6px 12px; background: var(--primary-color); color: white; border-radius: 6px; text-decoration: none; font-size: 13px; font-weight: 600;">
                                            ✏️ Edit
                                        </a>
                                        <?php if(!$page->is_system_page): ?>
                                            <form action="<?php echo e(route('admin.pages.destroy', $page)); ?>" method="POST" onsubmit="return confirm('Are you sure you want to delete this page?');" style="display: inline;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" style="padding: 6px 12px; background: var(--danger-color); color: white; border: none; border-radius: 6px; cursor: pointer; font-size: 13px; font-weight: 600;">
                                                    🗑️ Delete
                                                </button>
                                            </form>
                                        <?php else: ?>
                                            <button disabled title="System pages cannot be deleted" style="padding: 6px 12px; background: #d1d5db; color: #6b7280; border: none; border-radius: 6px; cursor: not-allowed; font-size: 13px; font-weight: 600; opacity: 0.6;">
                                                🔒 Protected
                                            </button>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div style="text-align: center; padding: 60px 20px; color: var(--text-secondary);">
                <div style="font-size: 48px; margin-bottom: 16px;">📄</div>
                <h3 style="margin: 0 0 8px 0; color: var(--text-primary);">No Pages Yet</h3>
                <p style="margin: 0 0 20px 0;">Create your first page to get started.</p>
                <a href="<?php echo e(route('admin.pages.create')); ?>" style="padding: 10px 20px; background: var(--success-color); color: white; border: none; border-radius: 8px; cursor: pointer; font-weight: 600; text-decoration: none; display: inline-flex; align-items: center; gap: 8px;">
                    <span>➕</span> Add New Page
                </a>
            </div>
        <?php endif; ?>
    </div>

    <!-- Info Card -->
    <div class="card" style="background: #f0f9ff; border: 1px solid #bae6fd;">
        <h4 style="margin: 0 0 12px 0; color: #0369a1; display: flex; align-items: center; gap: 8px;">
            <span>💡</span> Quick Tips
        </h4>
        <ul style="margin: 0; padding-left: 20px; color: #0c4a6e;">
            <li style="margin-bottom: 8px;">Pages are ordered by the "Order" field - lower numbers appear first</li>
            <li style="margin-bottom: 8px;">Inactive pages won't be visible in the mobile app</li>
            <li style="margin-bottom: 8px;">Page slugs are used in the app URL (e.g., /pages/about-us)</li>
            <li>You can add unlimited pages for FAQs, Help sections, etc.</li>
        </ul>
    </div>
</div>

    <style>
        /* Toggle Switch Styles */
        .toggle-switch {
            position: relative;
            display: inline-block;
            width: 48px;
            height: 24px;
            cursor: pointer;
        }

        .toggle-switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .toggle-slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #cbd5e0;
            transition: 0.3s;
            border-radius: 24px;
        }

        .toggle-slider:before {
            position: absolute;
            content: "";
            height: 18px;
            width: 18px;
            left: 3px;
            bottom: 3px;
            background-color: white;
            transition: 0.3s;
            border-radius: 50%;
        }

        input:checked + .toggle-slider {
            background-color: #10b981;
        }

        input:checked + .toggle-slider:before {
            transform: translateX(24px);
        }

        .toggle-slider:hover {
            opacity: 0.9;
        }
    </style>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const toggles = document.querySelectorAll('.show-in-app-toggle');
            
            toggles.forEach(toggle => {
                toggle.addEventListener('change', function() {
                    const pageId = this.dataset.pageId;
                    const showInApp = this.checked;
                    
                    // Send AJAX request to update the page
                    fetch(`/admin/pages/${pageId}/toggle-app-visibility`, {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                        },
                        body: JSON.stringify({
                            show_in_app: showInApp
                        })
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            // Show success feedback
                            const td = this.closest('td');
                            const label = this.closest('label');
                            label.title = showInApp ? 'Visible in app' : 'Hidden from app';
                            
                            // Optional: Show toast notification
                            console.log('Page visibility updated successfully');
                        } else {
                            // Revert toggle on error
                            this.checked = !showInApp;
                            alert('Failed to update page visibility');
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        this.checked = !showInApp;
                        alert('An error occurred while updating the page');
                    });
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\DND\Apps\CLXpro\clx_backend\resources\views/admin/pages/index.blade.php ENDPATH**/ ?>