

<?php $__env->startSection('title', 'Monetization'); ?>

<?php $__env->startSection('content'); ?>
<style>
    /* Network Toggle Switches */
    .network-toggle-switch {
        width: 50px;
        height: 26px;
        display: block;
        position: relative;
        cursor: pointer;
    }
    .network-toggle-switch input {
        opacity: 0;
        width: 0;
        height: 0;
    }
    .network-toggle-slider {
        position: absolute;
        cursor: pointer;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: #ccc;
        transition: .4s;
        border-radius: 34px;
    }
    .network-toggle-slider:before {
        position: absolute;
        content: "";
        height: 18px;
        width: 18px;
        left: 4px;
        bottom: 4px;
        background-color: white;
        transition: .4s;
        border-radius: 50%;
    }
    input:checked + .network-toggle-slider {
        background-color: var(--success-color) !important;
    }
    input:checked + .network-toggle-slider:before {
        transform: translateX(24px);
    }
</style>

<div class="dashboard-grid" style="grid-template-columns: 1fr; gap: 24px;">
    
    <!-- Network Settings Cards -->
    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(400px, 1fr)); gap: 24px;">
        
        <!-- Google AdMob Card -->
        <div class="card" style="border-top: 4px solid #EA4335;">
            <div class="card-header">
                <div style="display: flex; align-items: center; gap: 12px;">
                    <div style="background: #fce8e6; padding: 10px; border-radius: 12px; color: #EA4335; font-size: 24px;">
                        📉
                    </div>
                    <div>
                        <h3 class="card-title" style="margin: 0; color: #EA4335;">Google AdMob</h3>
                        <span style="font-size: 12px; color: var(--text-secondary);">Google Mobile Ads SDK</span>
                    </div>
                </div>
                <form action="<?php echo e(route('admin.monetization.network.update', $admob->id)); ?>" method="POST" id="form-admob-toggle">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <input type="hidden" name="app_id" value="<?php echo e($admob->app_id); ?>">
                    <label class="network-toggle-switch">
                        <input type="checkbox" name="is_active" value="1" onchange="this.form.submit()" <?php echo e($admob->is_active ? 'checked' : ''); ?>>
                        <span class="network-toggle-slider"></span>
                    </label>
                </form>
            </div>
            
            <form action="<?php echo e(route('admin.monetization.network.update', $admob->id)); ?>" method="POST" style="margin-top: 16px;">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <?php if($admob->is_active): ?>
                    <input type="hidden" name="is_active" value="1">
                <?php endif; ?>
                <label style="display: block; font-weight: 600; margin-bottom: 8px; font-size: 14px;">App ID (Android/iOS)</label>
                <div style="display: flex; gap: 8px;">
                    <input type="text" name="app_id" value="<?php echo e($admob->app_id); ?>" placeholder="ca-app-pub-xxxxxxxxxxxxxxxx~yyyyyyyyyy" 
                           style="flex: 2; padding: 10px; border: 1px solid var(--border-color); border-radius: 8px; background: var(--bg-color); color: var(--text-primary);">
                    <div style="display: flex; flex-direction: column; flex: 0.5;">
                         <label style="font-size: 11px; margin-bottom: 2px;">Priority</label>
                         <input type="number" name="priority" value="<?php echo e($admob->priority); ?>" min="0" style="padding: 10px; border: 1px solid var(--border-color); border-radius: 8px;">
                    </div>
                    <button type="submit" style="padding: 10px 16px; background: var(--primary-color); color: white; border: none; border-radius: 8px; cursor: pointer; font-weight: 600;">Save</button>
                </div>
            </form>
        </div>

        <!-- Facebook Audience Network Card -->
        <div class="card" style="border-top: 4px solid #1877F2;">
            <div class="card-header">
                <div style="display: flex; align-items: center; gap: 12px;">
                    <div style="background: #e7f3ff; padding: 10px; border-radius: 12px; color: #1877F2; font-size: 24px;">
                        📘
                    </div>
                    <div>
                        <h3 class="card-title" style="margin: 0; color: #1877F2;">Audience Network</h3>
                        <span style="font-size: 12px; color: var(--text-secondary);">Meta Business Monetization</span>
                    </div>
                </div>
                <form action="<?php echo e(route('admin.monetization.network.update', $facebook->id)); ?>" method="POST" id="form-fan-toggle">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <input type="hidden" name="app_id" value="<?php echo e($facebook->app_id); ?>">
                    <label class="network-toggle-switch">
                        <input type="checkbox" name="is_active" value="1" onchange="this.form.submit()" <?php echo e($facebook->is_active ? 'checked' : ''); ?>>
                        <span class="network-toggle-slider"></span>
                    </label>
                </form>
            </div>
            
            <form action="<?php echo e(route('admin.monetization.network.update', $facebook->id)); ?>" method="POST" style="margin-top: 16px;">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <?php if($facebook->is_active): ?>
                    <input type="hidden" name="is_active" value="1">
                <?php endif; ?>
                <label style="display: block; font-weight: 600; margin-bottom: 8px; font-size: 14px;">App ID / Placement Prefix</label>
                <div style="display: flex; gap: 8px;">
                    <input type="text" name="app_id" value="<?php echo e($facebook->app_id); ?>" placeholder="Enter App ID" 
                           style="flex: 2; padding: 10px; border: 1px solid var(--border-color); border-radius: 8px; background: var(--bg-color); color: var(--text-primary);">
                     <div style="display: flex; flex-direction: column; flex: 0.5;">
                         <label style="font-size: 11px; margin-bottom: 2px;">Priority</label>
                         <input type="number" name="priority" value="<?php echo e($facebook->priority); ?>" min="0" style="padding: 10px; border: 1px solid var(--border-color); border-radius: 8px;">
                    </div>
                    <button type="submit" style="padding: 10px 16px; background: var(--primary-color); color: white; border: none; border-radius: 8px; cursor: pointer; font-weight: 600;">Save</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Ad Units Configuration - Simplified View -->
    <div class="card">
        <div class="card-header">
            <div>
                <h2 class="card-title" style="font-size: 1.25rem; color: var(--text-primary); margin-bottom: 4px;">Ad Units Configuration</h2>
                <p style="font-size: 14px; color: var(--text-secondary); margin: 0;">Configure Ad Unit IDs for each placement in your app</p>
            </div>
        </div>

        <?php
            // Group ad units by placement
            $groupedUnits = [];
            foreach($networks as $network) {
                foreach($network->adUnits as $unit) {
                    $groupedUnits[$unit->placement_identifier][$network->name] = $unit;
                }
            }
        ?>

        <?php if(count($groupedUnits) > 0): ?>
            <div style="overflow-x: auto;">
                <table class="table">
                    <thead>
                        <tr>
                            <th style="width: 25%;">Placement</th>
                            <th style="width: 10%;">Type</th>
                            <th style="width: 25%;">AdMob Unit ID</th>
                            <th style="width: 25%;">Facebook Unit ID</th>
                            <th style="width: 10%;" title="List Frequency / Grid Frequency">Freq (List/Grid)</th>
                            <th style="width: 5%; text-align: center;">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $placements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $placementKey => $placementLabel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $units = $groupedUnits[$placementKey] ?? [];
                                $admobUnit = $units['admob'] ?? null;
                                $facebookUnit = $units['facebook'] ?? null;
                                // Determine type logic (fallback to 'banner' if we can't guess, or map from placement name)
                                $placementType = 'banner';
                                if(str_contains($placementKey, 'interstitial')) $placementType = 'interstitial';
                                elseif(str_contains($placementKey, 'native')) $placementType = 'native';
                                elseif(str_contains($placementKey, 'rewarded')) $placementType = 'rewarded';
                                elseif(str_contains($placementKey, 'app_open')) $placementType = 'app_open';
                                
                                $unitType = $admobUnit ? $admobUnit->type : ($facebookUnit ? $facebookUnit->type : $placementType);
                            ?>
                            <tr>
                                <td style="font-weight: 600;">
                                    <?php echo e($placementLabel); ?>

                                </td>
                                <td>
                                    <span style="padding: 4px 8px; background: #e0e7ff; color: #4338ca; border-radius: 4px; font-size: 11px; font-weight: 600; text-transform: uppercase;">
                                        <?php echo e($unitType); ?>

                                    </span>
                                </td>
                                <td>
                                    <?php if($admobUnit): ?>
                                        <form action="<?php echo e(route('admin.monetization.ad_unit.update', $admobUnit->id)); ?>" method="POST" style="margin: 0;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PUT'); ?>
                                            <input type="hidden" name="name" value="<?php echo e($admobUnit->name); ?>">
                                            <div style="display: flex; gap: 4px; align-items: center;">
                                                <input type="text" 
                                                       name="ad_unit_id" 
                                                       value="<?php echo e($admobUnit->ad_unit_id); ?>" 
                                                       style="flex: 1; padding: 6px 8px; border: 1px solid var(--border-color); border-radius: 6px; background: var(--bg-color); color: var(--text-primary); font-size: 12px; font-family: monospace;">
                                                
                                                <!-- Hidden inputs for frequency, we update them via the main form or shared form if better designed, but for now lets put frequency in the row or handle separately. 
                                                     Actually, since both facebook and admob units share the 'placement concept' but are separate DB rows, we should probably allow setting frequency on the AdMob unit as the 'primary' controller or duplicate it.
                                                     Simpler approach: Just put frequency fields in the AdMob column or a separate column that updates BOTH or just the primary?
                                                     Let's put inputs in a separate column and have them update the AdMob unit (primary).
                                                -->
                                                <input type="hidden" name="frequency" value="<?php echo e($admobUnit->frequency); ?>">
                                                <input type="hidden" name="grid_frequency" value="<?php echo e($admobUnit->grid_frequency); ?>">

                                                <label style="display: flex; align-items: center; gap: 4px; cursor: pointer;" title="Active">
                                                    <input type="checkbox" name="is_active" value="1" <?php echo e($admobUnit->is_active ? 'checked' : ''); ?> style="width: 16px; height: 16px;">
                                                </label>
                                                <button type="submit" style="padding: 6px 12px; background: #EA4335; color: white; border: none; border-radius: 6px; cursor: pointer; font-size: 11px; font-weight: 600;">Save</button>
                                            </div>
                                        </form>
                                    <?php elseif($admob): ?>
                                        <form action="<?php echo e(route('admin.monetization.ad_unit.store')); ?>" method="POST" style="margin: 0;">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="ad_network_id" value="<?php echo e($admob->id); ?>">
                                            <input type="hidden" name="name" value="AdMob <?php echo e($placementLabel); ?>">
                                            <input type="hidden" name="placement_identifier" value="<?php echo e($placementKey); ?>">
                                            <input type="hidden" name="type" value="<?php echo e($unitType); ?>">
                                            <input type="hidden" name="is_active" value="1">
                                            
                                            <!-- Default frequency values for creation -->
                                            <input type="hidden" name="frequency" value="10">
                                            <input type="hidden" name="grid_frequency" value="8">

                                            <div style="display: flex; gap: 4px; align-items: center;">
                                                <input type="text" name="ad_unit_id" placeholder="Create Unit ID" style="flex: 1; padding: 6px 8px; border: 1px solid var(--border-color); border-radius: 6px; font-size: 12px;">
                                                <button type="submit" style="padding: 6px 12px; background: #EA4335; color: white; border: none; border-radius: 6px; cursor: pointer; font-size: 11px; font-weight: 600;">Add</button>
                                            </div>
                                        </form>
                                    <?php else: ?>
                                        <small style="color:red">AdMob Missing</small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($facebookUnit): ?>
                                        <?php $isUnsupported = in_array($facebookUnit->type, ['rewarded', 'app_open']); ?>
                                        <?php if($isUnsupported): ?>
                                            <span style="color: #f59e0b; font-size: 12px; font-weight: 600;">⚠️ Not Supported</span>
                                        <?php else: ?>
                                            <form action="<?php echo e(route('admin.monetization.ad_unit.update', $facebookUnit->id)); ?>" method="POST" style="margin: 0;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PUT'); ?>
                                                <input type="hidden" name="name" value="<?php echo e($facebookUnit->name); ?>">
                                                <div style="display: flex; gap: 4px; align-items: center;">
                                                    <input type="text" 
                                                           name="ad_unit_id" 
                                                           value="<?php echo e($facebookUnit->ad_unit_id); ?>" 
                                                           style="flex: 1; padding: 6px 8px; border: 1px solid var(--border-color); border-radius: 6px; background: var(--bg-color); color: var(--text-primary); font-size: 12px; font-family: monospace;">
                                                    <label style="display: flex; align-items: center; gap: 4px; cursor: pointer;" title="Active">
                                                        <input type="checkbox" name="is_active" value="1" <?php echo e($facebookUnit->is_active ? 'checked' : ''); ?> style="width: 16px; height: 16px;">
                                                    </label>
                                                    <button type="submit" style="padding: 6px 12px; background: #1877F2; color: white; border: none; border-radius: 6px; cursor: pointer; font-size: 11px; font-weight: 600;">Save</button>
                                                </div>
                                            </form>
                                        <?php endif; ?>
                                    <?php elseif($facebook): ?>
                                        <?php if(in_array($unitType, ['rewarded', 'app_open'])): ?>
                                             <span style="color: #9ca3af; font-size: 12px;">Not Supported</span>
                                        <?php else: ?>
                                            <form action="<?php echo e(route('admin.monetization.ad_unit.store')); ?>" method="POST" style="margin: 0;">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="ad_network_id" value="<?php echo e($facebook->id); ?>">
                                                <input type="hidden" name="name" value="FAN <?php echo e($placementLabel); ?>">
                                                <input type="hidden" name="placement_identifier" value="<?php echo e($placementKey); ?>">
                                                <input type="hidden" name="type" value="<?php echo e($unitType); ?>">
                                                <input type="hidden" name="is_active" value="1">
                                                <div style="display: flex; gap: 4px; align-items: center;">
                                                    <input type="text" name="ad_unit_id" placeholder="Create Unit ID" style="flex: 1; padding: 6px 8px; border: 1px solid var(--border-color); border-radius: 6px; font-size: 12px;">
                                                    <button type="submit" style="padding: 6px 12px; background: #1877F2; color: white; border: none; border-radius: 6px; cursor: pointer; font-size: 11px; font-weight: 600;">Add</button>
                                                </div>
                                            </form>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <small style="color:red">FAN Missing</small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <!-- Frequency Controls (Primary tied to AdMob unit for simplicity or general config) -->
                                    <?php if($admobUnit): ?>
                                        <form id="freq-form-<?php echo e($admobUnit->id); ?>" action="<?php echo e(route('admin.monetization.ad_unit.update', $admobUnit->id)); ?>" method="POST" style="display: flex; gap: 2px; align-items: center;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PUT'); ?>
                                            <!-- Hidden fields to keep other values -->
                                            <input type="hidden" name="name" value="<?php echo e($admobUnit->name); ?>">
                                            <input type="hidden" name="ad_unit_id" value="<?php echo e($admobUnit->ad_unit_id); ?>">
                                            <?php if($admobUnit->is_active): ?>
                                                <input type="hidden" name="is_active" value="1">
                                            <?php endif; ?>

                                            <input type="number" name="frequency" value="<?php echo e($admobUnit->frequency); ?>" min="1" step="1" title="List Frequency (ID:<?php echo e($admobUnit->id); ?>)" style="width: 50px; padding: 4px; border: 1px solid #ddd; border-radius: 4px; font-size: 11px;" required>
                                            <input type="number" name="grid_frequency" value="<?php echo e($admobUnit->grid_frequency); ?>" min="1" step="1" title="Grid Frequency (ID:<?php echo e($admobUnit->id); ?>)" style="width: 50px; padding: 4px; border: 1px solid #ddd; border-radius: 4px; font-size: 11px;" required>
                                            <button type="submit" style="padding: 4px 8px; background: var(--primary-color); color: white; border: none; border-radius: 4px; cursor: pointer; font-size: 10px; font-weight: 600;" title="Save Frequency for <?php echo e($admobUnit->name); ?>">💾</button>
                                        </form>
                                    <?php else: ?>
                                        <span style="color: #ccc; font-size: 11px;">N/A</span>
                                    <?php endif; ?>
                                </td>
                                <td style="text-align: center;">
                                    <button onclick="showPlacementInfo('<?php echo e($placementKey); ?>')" style="border: none; background: none; cursor: pointer; font-size: 18px; opacity: 0.6;" title="Info">ℹ️</button>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            <!-- Legend -->
            <div style="padding: 16px; background: var(--bg-color); border-top: 1px solid var(--border-color); display: flex; gap: 24px; font-size: 13px;">
                <div style="display: flex; align-items: center; gap: 6px;">
                    <span style="color: var(--text-secondary);">💡 Tip:</span>
                    <span style="color: var(--text-primary);">Enter your Ad Unit IDs from AdMob/Facebook dashboards, check the box to activate, and click Save</span>
                </div>
            </div>
        <?php else: ?>
            <div style="text-align: center; padding: 40px; color: var(--text-secondary);">
                <div style="font-size: 40px; margin-bottom: 10px;">📉</div>
                <p>No ad units configured yet. Run the seeder to populate default placements.</p>
                <code style="background: var(--bg-color); padding: 8px 16px; border-radius: 6px; display: inline-block; margin-top: 12px;">
                    php artisan db:seed --class=MonetizationSeeder
                </code>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Info Modal -->
<div id="infoModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 1000; align-items: center; justify-content: center;">
    <div style="background: var(--card-bg); width: 100%; max-width: 500px; padding: 24px; border-radius: 12px; box-shadow: 0 10px 25px rgba(0,0,0,0.2);">
        <h3 style="margin-top: 0; color: var(--text-primary);">Placement Information</h3>
        <div id="placementInfo" style="color: var(--text-primary); line-height: 1.6;"></div>
        <button onclick="closeInfoModal()" style="margin-top: 20px; padding: 10px 20px; background: var(--primary-color); border: none; border-radius: 8px; color: white; font-weight: 600; cursor: pointer;">Close</button>
    </div>
</div>

<script>
    // Debug: Log all form submissions
    document.addEventListener('DOMContentLoaded', function() {
        const forms = document.querySelectorAll('form[id^="freq-form-"]');
        console.log('Found frequency forms:', forms.length);
        
        forms.forEach(form => {
            form.addEventListener('submit', function(e) {
                const formData = new FormData(form);
                console.log('Form submitting:', form.id);
                console.log('Frequency:', formData.get('frequency'));
                console.log('Grid Frequency:', formData.get('grid_frequency'));
                alert('Submitting form ' + form.id + '\nFrequency: ' + formData.get('frequency') + '\nGrid: ' + formData.get('grid_frequency'));
                // Let it continue to submit
            });
        });
    });

    const placementDescriptions = {
        'home_banner': 'Displayed at the top or bottom of the home screen. Shows when users first open the app.',
        'home_native': 'Blends with the home screen content feed. Appears between ad listings.',
        'home_interstitial': 'Full-screen ad shown when users navigate from home. Can be shown after a certain time interval.',
        'ad_details_banner': 'Shown at the bottom of ad detail pages when viewing a specific listing.',
        'ad_details_native': 'Integrated within ad details page, shown between the description and seller info.',
        'category_banner': 'Displayed when browsing categories of ads.',
        'category_native': 'Appears in the category listings feed.',
        'category_interstitial': 'Full-screen ad between category navigation.',
        'search_banner': 'Shown at the top or bottom of search results page.',
        'search_native': 'Embedded within search results listings.',
        'post_ad_interstitial': 'Full-screen ad shown after user successfully posts an ad.',
        'post_ad_rewarded': 'Rewarded video ad - users watch to get a boost or premium feature for their newly posted ad.',
        'profile_banner': 'Displayed on user profile pages.',
        'my_ads_banner': 'Shown on the "My Ads" screen where users manage their listings.',
        'app_open': 'Full-screen ad shown when app is launched or brought to foreground.',
        'chat_banner': 'Displayed in the chat/messaging screen.'
    };

    function showPlacementInfo(placement) {
        const description = placementDescriptions[placement] || 'No description available for this placement.';
        document.getElementById('placementInfo').innerHTML = `
            <p><strong>Placement:</strong> ${placement.replace(/_/g, ' ').toUpperCase()}</p>
            <p><strong>Description:</strong> ${description}</p>
        `;
        document.getElementById('infoModal').style.display = 'flex';
    }

    function closeInfoModal() {
        document.getElementById('infoModal').style.display = 'none';
    }

    // Close on click outside
    document.getElementById('infoModal').addEventListener('click', function(e) {
        if (e.target === this) closeInfoModal();
    });

    // Show success message if present
    <?php if(session('success')): ?>
        setTimeout(() => {
            const message = document.createElement('div');
            message.style.cssText = 'position: fixed; top: 80px; right: 20px; background: #10b981; color: white; padding: 16px 24px; border-radius: 8px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); z-index: 9999; animation: slideIn 0.3s ease;';
            message.textContent = '<?php echo e(session("success")); ?>';
            document.body.appendChild(message);
            
            setTimeout(() => {
                message.style.animation = 'slideOut 0.3s ease';
                setTimeout(() => message.remove(), 300);
            }, 3000);
        }, 100);
    <?php endif; ?>
</script>

<style>
    @keyframes slideIn {
        from { transform: translateX(400px); opacity: 0; }
        to { transform: translateX(0); opacity: 1; }
    }
    @keyframes slideOut {
        from { transform: translateX(0); opacity: 1; }
        to { transform: translateX(400px); opacity: 0; }
    }
</style>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\DND\Apps\CLXpro\clx_backend\resources\views/admin/monetization/index.blade.php ENDPATH**/ ?>