<?php

use App\Models\UserPlan;
use App\Models\User;
use Illuminate\Support\Facades\DB;

require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

// The mandated plans
$plansToAdd = [
    [
        'plan_name' => 'Standard',
        'price' => 0,
        'duration_days' => 36500, // Effectively lifetime/indefinite
        'status' => 'Active',
        'algorithm_boost' => 20, // Low boost
        'ad_free' => false,
        'verified_badge' => false,
    ],
    [
        'plan_name' => 'VIP Buyer',
        'price' => 20,
        'duration_days' => 30,
        'status' => 'Active',
        'algorithm_boost' => 50, // Medium boost
        'ad_free' => true,
        'verified_badge' => false,
    ],
    [
        'plan_name' => 'VIP Seller',
        'price' => 50,
        'duration_days' => 30,
        'status' => 'Active',
        'algorithm_boost' => 75, // High boost
        'ad_free' => true,
        'verified_badge' => true,
    ],
    [
        'plan_name' => 'VIP Pro',
        'price' => 100,
        'duration_days' => 30,
        'status' => 'Active',
        'algorithm_boost' => 100, // Max boost
        'ad_free' => true,
        'verified_badge' => true,
    ],
];

echo "Starting Plan Configuration...\n";

// 1. Create or Update Mandated Plans
$keptPlanIds = [];

foreach ($plansToAdd as $planData) {
    // algorithm_boost isn't in UserPlan table yet locally (it's in AlgorithmConfig logic),
    // but the Prompt implied "UserPlan having boost".
    // Actually, in previous steps we stored boost in AlgorithmConfig BY Plan ID.
    // So here we just create the plan.
    // We'll separate the boost logic update.
    
    $boost = $planData['algorithm_boost'] ?? 50;
    unset($planData['algorithm_boost']); // Remove non-column data
    
    $plan = UserPlan::updateOrCreate(
        ['plan_name' => $planData['plan_name']],
        $planData
    );
    
    $keptPlanIds[] = $plan->id;
    echo "Configured Plan: {$plan->plan_name} (ID: {$plan->id})\n";
}

// 2. Identify Standard Plan ID
$standardPlan = UserPlan::where('plan_name', 'Standard')->first();
if (!$standardPlan) {
    die("Error: Standard plan not created.\n");
}

// 3. Remap Users from Plans-to-be-deleted to Standard
$deletedPlans = UserPlan::whereNotIn('id', $keptPlanIds)->get();

if ($deletedPlans->count() > 0) {
    echo "Found {$deletedPlans->count()} plans to delete.\n";
    foreach ($deletedPlans as $delPlan) {
        $count = User::where('current_plan_id', $delPlan->id)->update(['current_plan_id' => $standardPlan->id]);
        echo "Remapped $count users from '{$delPlan->plan_name}' to 'Standard'.\n";
        $delPlan->delete();
    }
} else {
    echo "No extra plans found to delete.\n";
}

echo "Plan cleanup complete.\n";
