<?php

// Complete setup script for CLX Premium Classifieds Platform
// This script will:
// 1. Run database migrations
// 2. Seed the database with admin user and sample data
// 3. Create the admin user with your specified credentials

require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Hash;
use App\Models\User;

echo "=== CLX Premium Classifieds Platform Setup ===\n\n";

try {
    // Step 1: Run migrations
    echo "Step 1: Running database migrations...\n";
    Artisan::call('migrate', ['--force' => true]);
    echo "✅ Migrations completed successfully!\n\n";

    // Step 2: Run seeders
    echo "Step 2: Running database seeders...\n";
    Artisan::call('db:seed', ['--force' => true]);
    echo "✅ Database seeding completed successfully!\n\n";

    // Step 3: Verify admin user exists
    echo "Step 3: Verifying admin user...\n";
    $admin = User::where('email', 'admin@donebro.in')->first();

    if ($admin) {
        echo "✅ Admin user already exists!\n";
        echo "   Email: admin@donebro.in\n";
        echo "   Password: 123456\n";
        echo "   Admin ID: " . $admin->id . "\n";
    } else {
        // Create admin user if it doesn't exist
        $admin = User::create([
            'name' => 'Admin User',
            'email' => 'admin@donebro.in',
            'password' => Hash::make('123456'),
            'is_admin' => true,
            'is_verified' => true,
            'current_plan_id' => null,
        ]);
        
        echo "✅ Admin user created successfully!\n";
        echo "   Email: admin@donebro.in\n";
        echo "   Password: 123456\n";
        echo "   Admin ID: " . $admin->id . "\n";
    }

    echo "\n=== Setup Complete! ===\n";
    echo "You can now access the admin dashboard at: http://127.0.0.1:8000/admin/login\n";
    echo "Use the following credentials:\n";
    echo "   Email: admin@donebro.in\n";
    echo "   Password: 123456\n";

} catch (Exception $e) {
    echo "❌ Error during setup: " . $e->getMessage() . "\n";
    echo "Please check your database connection and try again.\n";
}
