<?php
use App\Models\AlgorithmConfig;
use App\Models\UserPlan;

require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

// Get Plan IDs
$pStd = UserPlan::where('plan_name', 'Standard')->first()->id;
$pBuy = UserPlan::where('plan_name', 'VIP Buyer')->first()->id;
$pSell = UserPlan::where('plan_name', 'VIP Seller')->first()->id;
$pPro = UserPlan::where('plan_name', 'VIP Pro')->first()->id;

echo "Setting Boosts for IDs: Std=$pStd, Buy=$pBuy, Sell=$pSell, Pro=$pPro\n";

$config = AlgorithmConfig::getDefault();
$vipTiers = $config->vip_settings['vip_tiers'] ?? [];

// Set Boosts
$vipTiers["plan_{$pStd}_boost"] = 20;
$vipTiers["plan_{$pBuy}_boost"] = 50;
$vipTiers["plan_{$pSell}_boost"] = 75;
$vipTiers["plan_{$pPro}_boost"] = 100;

// Ensure Priority Ranking is On
$vipTiers['priority_ranking'] = true;

$config->updateVIPSettings(['vip_tiers' => $vipTiers, 'priority_ranking' => true]);

echo "Boost Defaults Set.\n";
