<?php

use App\Models\Review;
use App\Models\User;
use Carbon\Carbon;

require __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

$userId = 78; // Michael Luxury
$validUserIds = [1, 56, 57, 58, 68];

// clear existing reviews for this user to start fresh
Review::where('reviewee_id', $userId)->forceDelete();

$reviews = [
    [
        'rating' => 5,
        'review_text' => 'Absolutely fantastic seller! The item was in perfect condition.',
        'transaction_type' => 'buyer',
    ],
    [
        'rating' => 4,
        'review_text' => 'Great communication, slightly delayed shipping but overall good.',
        'transaction_type' => 'buyer',
    ],
    [
        'rating' => 5,
        'review_text' => 'Highly recommended! Will buy again.',
        'transaction_type' => 'seller',
    ],
     [
        'rating' => 5,
        'review_text' => 'Smooth transaction.',
        'transaction_type' => 'buyer',
    ],
];

foreach ($reviews as $index => $data) {
    try {
        $reviewerId = $validUserIds[$index % count($validUserIds)]; // Cycle through valid IDs
        
        Review::create([
            'reviewer_id' => $reviewerId,
            'reviewee_id' => $userId,
            'ad_id' => null, // keeping it simple
            'rating' => $data['rating'],
            'review_text' => $data['review_text'],
            'ad_title' => 'Sample Item',
            'ad_category' => 'Electronics',
            'transaction_type' => $data['transaction_type'],
            'is_verified_purchase' => true,
            'created_at' => Carbon::now()->subDays(rand(1, 30)),
        ]);
        echo "Created review from user $reviewerId\n";
    } catch (\Exception $e) {
        echo "Error creating review: " . $e->getMessage() . "\n";
    }
}

// Recalculate and display expected rating
$avg = Review::where('reviewee_id', $userId)->avg('rating');
echo "Expected Average Rating: " . number_format($avg, 1) . "\n";
