<?php

require __DIR__ . '/vendor/autoload.php';

use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

// Bootstrap Laravel
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

// Seed sample reviews for user ID 1
$userId = 1; // The authenticated user

$sampleReviews = [
    [
        'reviewer_id' => 2,
        'reviewee_id' => $userId,
        'ad_id' => 1,
        'rating' => 5,
        'review_text' => 'Excellent seller! Very responsive and the item was exactly as described. Highly recommended!',
        'ad_title' => 'iPhone 13 Pro',
        'ad_category' => 'Electronics',
        'transaction_type' => 'buyer',
        'is_verified_purchase' => true,
        'created_at' => Carbon::now()->subDays(2),
    ],
    [
        'reviewer_id' => 3,
        'reviewee_id' => $userId,
        'ad_id' => 2,
        'rating' => 5,
        'review_text' => 'Great experience! Fast delivery and item in perfect condition.',
        'ad_title' => 'MacBook Pro 2021',
        'ad_category' => 'Computers',
        'transaction_type' => 'buyer',
        'is_verified_purchase' => true,
        'created_at' => Carbon::now()->subDays(5),
    ],
    [
        'reviewer_id' => 4,
        'reviewee_id' => $userId,
        'ad_id' => null, // Ad was deleted
        'rating' => 4,
        'review_text' => 'Good seller, item was as described. Delivery took a bit longer than expected but overall satisfied.',
        'ad_title' => 'Samsung Galaxy S21',
        'ad_category' => 'Electronics',
        'transaction_type' => 'buyer',
        'is_verified_purchase' => true,
        'created_at' => Carbon::now()->subDays(10),
    ],
    [
        'reviewer_id' => 5,
        'reviewee_id' => $userId,
        'ad_id' => 3,
        'rating' => 5,
        'review_text' => 'Amazing! Best seller I\'ve dealt with. Professional and trustworthy.',
        'ad_title' => 'Canon EOS R6',
        'ad_category' => 'Cameras',
        'transaction_type' => 'buyer',
        'is_verified_purchase' => true,
        'created_at' => Carbon::now()->subWeeks(2),
    ],
    [
        'reviewer_id' => 6,
        'reviewee_id' => $userId,
        'ad_id' => 4,
        'rating' => 4,
        'review_text' => 'Smooth transaction. Item in good condition.',
        'ad_title' => 'Gaming Chair',
        'ad_category' => 'Furniture',
        'transaction_type' => 'buyer',
        'is_verified_purchase' => false,
        'created_at' => Carbon::now()->subWeeks(3),
    ],
    [
        'reviewer_id' => 7,
        'reviewee_id' => $userId,
        'ad_id' => 5,
        'rating' => 3,
        'review_text' => 'Item was okay. Had some minor scratches that weren\'t mentioned in the description.',
        'ad_title' => 'iPad Air',
        'ad_category' => 'Tablets',
        'transaction_type' => 'buyer',
        'is_verified_purchase' => true,
        'created_at' => Carbon::now()->subMonth(),
    ],
    [
        'reviewer_id' => 8,
        'reviewee_id' => $userId,
        'ad_id' => null, // Ad deleted
        'rating' => 5,
        'review_text' => null, // No comment, just rating
        'ad_title' => 'Nike Air Max',
        'ad_category' => 'Shoes',
        'transaction_type' => 'buyer',
        'is_verified_purchase' => true,
        'created_at' => Carbon::now()->subMonths(2),
    ],
];

echo "Creating sample reviews...\n";

foreach ($sampleReviews as $review) {
    try {
        DB::table('reviews')->insert($review);
        echo "✓ Created review from user {$review['reviewer_id']} - Rating: {$review['rating']} stars\n";
    } catch (\Exception $e) {
        echo "✗ Failed to create review: " . $e->getMessage() . "\n";
    }
}

echo "\n✅ Sample reviews created successfully!\n";
echo "User ID $userId now has " . DB::table('reviews')->where('reviewee_id', $userId)->count() . " reviews\n";

// Display stats
$avgRating = DB::table('reviews')->where('reviewee_id', $userId)->avg('rating');
echo "Average Rating: " . number_format($avgRating, 1) . " ⭐\n\n";
