<?php

use App\Models\AdPackage;
use App\Models\PackagePricingTier;
use Illuminate\Support\Facades\DB;

require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

// Clear existing packages
DB::statement('SET FOREIGN_KEY_CHECKS=0;');
AdPackage::truncate();
PackagePricingTier::truncate();
DB::statement('SET FOREIGN_KEY_CHECKS=1;');

echo "Cleared existing packages.\n";

// 1. Post More Ads Packages
$multiAd = AdPackage::create([
    'name' => 'Bulk Post 5',
    'slug' => 'bulk-post-5',
    'type' => 'multiple_ads',
    'description' => 'Post 5 additional ads in any category.',
    'features' => ['post_limit' => 5],
    'algorithm_params' => [],
    'is_active' => true,
    'sort_order' => 1
]);
// Pricing for Bulk Post 5
$multiAd->pricingTiers()->create(['validity_days' => 30, 'base_price' => 199, 'discount_percentage' => 0]);
$multiAd->pricingTiers()->create(['validity_days' => 90, 'base_price' => 499, 'discount_percentage' => 20, 'is_popular' => true]);

$multiAd10 = AdPackage::create([
    'name' => 'Bulk Post 10',
    'slug' => 'bulk-post-10',
    'type' => 'multiple_ads',
    'description' => 'Post 10 additional ads in any category.',
    'features' => ['post_limit' => 10],
    'algorithm_params' => [],
    'is_active' => true,
    'sort_order' => 2
]);
$multiAd10->pricingTiers()->create(['validity_days' => 30, 'base_price' => 349, 'discount_percentage' => 0]);


// 2. Featured Ad Packages
$featured = AdPackage::create([
    'name' => 'Featured Ad Spotlight',
    'slug' => 'featured-ad',
    'type' => 'featured',
    'description' => 'Pin your ad to the top with a yellow Featured tag.',
    'features' => ['featured_duration_days' => 7], // Default to 7, overridden by validity really
    'algorithm_params' => [],
    'is_active' => true,
    'sort_order' => 3
]);
// 7 Days
$featured->pricingTiers()->create(['validity_days' => 7, 'base_price' => 299, 'discount_percentage' => 0]);
// 30 Days (Best Value)
$featured->pricingTiers()->create(['validity_days' => 30, 'base_price' => 999, 'discount_percentage' => 40, 'is_popular' => true]);


// 3. Boost To Top Packages
$boost = AdPackage::create([
    'name' => 'Boost to Top',
    'slug' => 'boost-top',
    'type' => 'boost',
    'description' => 'Push your ad to the top of the list instantly.',
    'features' => ['boost_count' => 1],
    'algorithm_params' => [],
    'is_active' => true,
    'sort_order' => 4
]);
// 1 Boost
$boost->pricingTiers()->create(['validity_days' => 30, 'base_price' => 49, 'discount_percentage' => 0]);
// 5 Boosts
$boost->pricingTiers()->create(['validity_days' => 90, 'base_price' => 199, 'discount_percentage' => 20, 'is_popular' => true]);


// 4. Combo Package
$combo = AdPackage::create([
    'name' => 'Power Seller Combo',
    'slug' => 'power-combo',
    'type' => 'combo',
    'description' => 'Post 10 Ads + 5 Boosts + 7 Days Featured!',
    'features' => [
        'post_limit' => 10,
        'boost_count' => 5,
        'featured_duration_days' => 7
    ],
    'algorithm_params' => [],
    'is_active' => true,
    'sort_order' => 5
]);
$combo->pricingTiers()->create(['validity_days' => 30, 'base_price' => 999, 'discount_percentage' => 50, 'is_popular' => true]);

echo "seeded " . AdPackage::count() . " packages with " . PackagePricingTier::count() . " pricing tiers.\n";
