<?php

use App\Models\Ad;

// Coordinate mapping for demo cities
$cities = [
    'New York' => ['lat' => 40.7128, 'lng' => -74.0060],
    'Los Angeles' => ['lat' => 34.0522, 'lng' => -118.2437],
    'Chicago' => ['lat' => 41.8781, 'lng' => -87.6298],
    'Houston' => ['lat' => 29.7604, 'lng' => -95.3698],
    'Phoenix' => ['lat' => 33.4484, 'lng' => -112.0740],
    'Philadelphia' => ['lat' => 39.9526, 'lng' => -75.1652],
    'San Antonio' => ['lat' => 29.4241, 'lng' => -98.4936],
    'San Diego' => ['lat' => 32.7157, 'lng' => -117.1611],
    'Dallas' => ['lat' => 32.7767, 'lng' => -96.7970],
    'San Jose' => ['lat' => 37.3382, 'lng' => -121.8863],
    'San Francisco' => ['lat' => 37.7749, 'lng' => -122.4194],
];

foreach ($cities as $city => $coords) {
    Ad::where('city', $city)->update([
        'latitude' => $coords['lat'],
        'longitude' => $coords['lng']
    ]);
    
    // Also randomize slightly for variety if needed, but strict center is fine for now
    echo "Updated ads in $city to {$coords['lat']}, {$coords['lng']}\n";
}

echo "Done seeding locations.\n";
