<?php

use App\Models\Ad;
use App\Models\User;
use App\Models\Category;
use Illuminate\Support\Carbon;

echo "Starting India Ad Seeding...\n";

// Ensure we have a user
$user = User::first();
if (!$user) {
    echo "No user found. Creating one...\n";
    $user = User::factory()->create();
}

// Ensure we have categories
$electronics = Category::firstOrCreate(['slug' => 'electronics'], ['name' => 'Electronics', 'icon' => 'fa-laptop']);
$cars = Category::firstOrCreate(['slug' => 'cars'], ['name' => 'Cars', 'icon' => 'fa-car']);
$furniture = Category::firstOrCreate(['slug' => 'furniture'], ['name' => 'Furniture', 'icon' => 'fa-couch']);
$properties = Category::firstOrCreate(['slug' => 'properties'], ['name' => 'Properties', 'icon' => 'fa-home']);

// Define locations
$locations = [
    // Bangalore (3 locations)
    [
        'city' => 'Bangalore',
        'location' => 'MG Road',
        'lat' => 12.9716,
        'lng' => 77.5946,
        'ads' => [
            ['title' => 'MacBook Pro M2 - Barely Used', 'price' => 120000, 'cat' => $electronics->id, 'desc' => 'Selling my MacBook Pro M2, only 2 months old. Perfect condition.'],
            ['title' => 'Luxury 3BHK Apartment on MG Road', 'price' => 25000000, 'cat' => $properties->id, 'desc' => 'Prime location, fully furnished 3BHK with city view.']
        ]
    ],
    [
        'city' => 'Bangalore',
        'location' => 'Indiranagar',
        'lat' => 12.9784,
        'lng' => 77.6408,
        'ads' => [
            ['title' => 'Royal Enfield Classic 350', 'price' => 180000, 'cat' => $cars->id, 'desc' => '2023 model, gunmetal grey, excellent condition.'],
        ]
    ],
    [
        'city' => 'Bangalore',
        'location' => 'Koramangala',
        'lat' => 12.9352,
        'lng' => 77.6245,
        'ads' => [
            ['title' => 'Designer Sofa Set - Teak Wood', 'price' => 45000, 'cat' => $furniture->id, 'desc' => 'Handcrafted teak wood sofa set. 3+1+1 seater.']
        ]
    ],
    
    // Mysore (2 locations)
    [
        'city' => 'Mysore',
        'location' => 'Mysore Palace Area',
        'lat' => 12.3051,
        'lng' => 76.6551,
        'ads' => [
            ['title' => 'Vintage Rosewood Dining Table', 'price' => 85000, 'cat' => $furniture->id, 'desc' => 'Antique rosewood dining table with 6 chairs.'],
            ['title' => 'Commercial Shop for Rent', 'price' => 15000, 'cat' => $properties->id, 'desc' => '200 sqft shop near Palace entrance. High footfall.']
        ]
    ],
    [
        'city' => 'Mysore',
        'location' => 'Jayalakshmipuram',
        'lat' => 12.3243,
        'lng' => 76.6341,
        'ads' => [
            ['title' => 'iPhone 14 - 128GB Blue', 'price' => 55000, 'cat' => $electronics->id, 'desc' => 'Mint condition iPhone 14, always used with case and screen guard.']
        ]
    ],

    // Delhi (2 locations)
    [
        'city' => 'Delhi',
        'location' => 'Connaught Place',
        'lat' => 28.6304,
        'lng' => 77.2177,
        'ads' => [
            ['title' => 'Canon 5D Mark IV Camera', 'price' => 150000, 'cat' => $electronics->id, 'desc' => 'Professional DSLR body only. Shutter count < 10k.'],
            ['title' => 'Office Space in CP', 'price' => 85000, 'cat' => $properties->id, 'desc' => 'Furnished office space available for lease immediately.']
        ]
    ],
    [
        'city' => 'Delhi',
        'location' => 'Hauz Khas',
        'lat' => 28.5494,
        'lng' => 77.2001,
        'ads' => [
            ['title' => 'Bohemian Art Decor', 'price' => 12000, 'cat' => $furniture->id, 'desc' => 'Unique wall art and decor pieces for modern homes.']
        ]
    ],

    // Tumkur (2 locations) - Near Bangalore
    [
        'city' => 'Tumkur',
        'location' => 'Tumkur City',
        'lat' => 13.3379,
        'lng' => 77.1173,
        'ads' => [
            ['title' => 'Agricultural Land - 2 Acres', 'price' => 4500000, 'cat' => $properties->id, 'desc' => 'Fertile agricultural land with borewell connection.']
        ]
    ],
    [
        'city' => 'Tumkur',
        'location' => 'University Area',
        'lat' => 13.3420,
        'lng' => 77.1000,
        'ads' => [
            ['title' => 'Study Table and Chair', 'price' => 3500, 'cat' => $furniture->id, 'desc' => 'Perfect for students. Good condition wooden table.']
        ]
    ],
];



echo "Cleaning up previous seed data...\n";
$titlesToDelete = [];
foreach ($locations as $loc) {
    foreach ($loc['ads'] as $adData) {
        $titlesToDelete[] = $adData['title'];
    }
}
Ad::whereIn('title', $titlesToDelete)->forceDelete();

$count = 0;

foreach ($locations as $loc) {
    foreach ($loc['ads'] as $adData) {
        Ad::create([
            'title' => $adData['title'],
            'description' => $adData['desc'],
            'price' => $adData['price'],
            'slug' => \Illuminate\Support\Str::slug($adData['title']) . '-' . uniqid(),
            'user_id' => $user->id,
            'category_id' => $adData['cat'],
            'location_city' => $loc['city'],  // Important for text fallback
            'city' => $loc['city'],           // Legacy field
            'area' => $loc['location'],
            'latitude' => $loc['lat'],        // CRITICAL: Used for Radius Filter
            'longitude' => $loc['lng'],       // CRITICAL: Used for Radius Filter
            'status' => 'Active',
            'is_active' => true,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ]);
        $count++;
        echo "Created ad: {$adData['title']} in {$loc['city']} ({$loc['location']})\n";
    }
}

echo "Successfully seeded $count ads across Bangalore, Mysore, Delhi, and Tumkur!\n";
