<?php

require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use Illuminate\Support\Facades\DB;

$exists = DB::table('payment_gateways')->where('slug', 'free')->exists();

if (!$exists) {
    echo "Inserting 'free' payment gateway...\n";
    DB::table('payment_gateways')->insert([
        'name' => 'Free / Manual',
        'slug' => 'free',
        'api_key' => 'free_key_placeholder',
        'api_secret' => 'free_secret_placeholder',
        'webhook_secret' => null,
        'is_active' => true,
        'is_test_mode' => false,
        'supported_currencies' => json_encode(['INR', 'USD']),
        'supported_methods' => json_encode(['manual']),
        'transaction_fee_percent' => 0,
        'transaction_fee_fixed' => 0,
        'description' => 'For free plans and manual activations',
        'sort_order' => 99,
        'created_at' => now(),
        'updated_at' => now(),
    ]);
    echo "✅ 'free' gateway inserted successfully.\n";
} else {
    echo "ℹ️ 'free' gateway already exists.\n";
}
