<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;

Route::get('/test-analytics-access', function() {
    $user = Auth::user();
    
    if (!$user) {
        return response()->json(['error' => 'Not authenticated']);
    }
    
    $user = $user->fresh('currentPlan');
    
    return response()->json([
        'user_id' => $user->id,
        'user_name' => $user->name,
        'current_plan_id' => $user->current_plan_id,
        'has_current_plan' => $user->currentPlan ? true : false,
        'plan_details' => $user->currentPlan,
        'has_analytics' => $user->currentPlan->has_analytics ?? null,
    ]);
})->middleware('auth:sanctum');
