<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CLX Platform - Installation</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
        }
        .install-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 15px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            backdrop-filter: blur(10px);
        }
        .logo-section {
            text-align: center;
            margin-bottom: 2rem;
        }
        .logo-section h1 {
            font-weight: 700;
            color: #333;
            margin-bottom: 0.5rem;
        }
        .logo-section p {
            color: #666;
            font-size: 1.1rem;
        }
        .step-indicator {
            display: flex;
            justify-content: center;
            margin-bottom: 2rem;
        }
        .step {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: #e9ecef;
            color: #666;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            margin: 0 10px;
            position: relative;
        }
        .step.active {
            background: #667eea;
            color: white;
            box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.3);
        }
        .step.completed {
            background: #28a745;
            color: white;
        }
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 25px;
            padding: 12px 30px;
            font-weight: 600;
            transition: transform 0.2s;
        }
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card install-card border-0">
                    <div class="card-body p-5">
                        <div class="logo-section">
                            <div class="mb-3">
                                <i class="fas fa-rocket fa-3x text-primary"></i>
                            </div>
                            <h1>CLX Premium Classifieds Platform</h1>
                            <p>Complete Installation Setup</p>
                        </div>

                        <div class="step-indicator">
                            <div class="step active">1</div>
                            <div class="step">2</div>
                            <div class="step">3</div>
                        </div>

                        <div class="text-center">
                            <h3>Welcome to CLX Platform Setup</h3>
                            <p class="text-muted mb-4">
                                This installer will guide you through setting up your CLX Premium Classifieds Platform.
                                Estimated time: 5 minutes.
                            </p>

                            <div class="row text-center mb-4">
                                <div class="col-md-4">
                                    <div class="p-3">
                                        <i class="fas fa-check-circle fa-2x text-success mb-2"></i>
                                        <h6>System Check</h6>
                                        <small class="text-muted">Verify requirements</small>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="p-3">
                                        <i class="fas fa-database fa-2x text-info mb-2"></i>
                                        <h6>Database Setup</h6>
                                        <small class="text-muted">Configure database</small>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="p-3">
                                        <i class="fas fa-cog fa-2x text-warning mb-2"></i>
                                        <h6>Finalize</h6>
                                        <small class="text-muted">Complete installation</small>
                                    </div>
                                </div>
                            </div>

                            <div class="alert alert-info">
                                <i class="fas fa-info-circle"></i>
                                <strong>Before you begin:</strong>
                                <ul class="mt-2 mb-0">
                                    <li>Ensure your database server is running</li>
                                    <li>Have your database credentials ready</li>
                                    <li>Make sure file permissions are correct</li>
                                </ul>
                            </div>

                            <div class="d-grid gap-3">
                                <a href="{{ route('install.requirements') }}" class="btn btn-primary btn-lg">
                                    <i class="fas fa-play"></i> Start Installation
                                </a>
                                <a href="{{ url('/') }}" class="btn btn-outline-secondary">
                                    <i class="fas fa-arrow-left"></i> Return to Website
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
