<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>System Requirements - CLX Platform Installation</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        .install-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 15px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            backdrop-filter: blur(10px);
        }
        .requirement-item {
            border: 1px solid #e9ecef;
            border-radius: 10px;
            padding: 1.5rem;
            margin-bottom: 1rem;
            transition: all 0.3s ease;
        }
        .requirement-item:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .status-badge {
            font-size: 0.8rem;
            padding: 4px 8px;
            border-radius: 20px;
            font-weight: bold;
        }
        .status-pass {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .status-fail {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .step-indicator {
            display: flex;
            justify-content: center;
            margin-bottom: 2rem;
        }
        .step {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: #e9ecef;
            color: #666;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            margin: 0 10px;
        }
        .step.completed {
            background: #28a745;
            color: white;
        }
        .step.active {
            background: #667eea;
            color: white;
            box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.3);
        }
        .progress-container {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 1rem;
            margin-bottom: 2rem;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-10">
                <div class="card install-card border-0">
                    <div class="card-body p-5">
                        <div class="step-indicator">
                            <div class="step completed">
                                <i class="fas fa-check"></i>
                            </div>
                            <div class="step active">2</div>
                            <div class="step">3</div>
                        </div>

                        <div class="text-center mb-4">
                            <h2>System Requirements Check</h2>
                            <p class="text-muted">Verifying your server meets all requirements</p>
                        </div>

                        <div class="progress-container">
                            <div class="d-flex justify-content-between mb-2">
                                <span>Checking Requirements</span>
                                <span id="progress-text">0%</span>
                            </div>
                            <div class="progress" style="height: 10px;">
                                <div id="progress-bar" class="progress-bar" style="width: 0%"></div>
                            </div>
                        </div>

                        <div id="requirements-list">
                            <!-- PHP Version -->
                            <div class="requirement-item">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h6 class="mb-1">PHP Version</h6>
                                        <p class="mb-0 text-muted">Required: 8.0+, Current: {{ $requirements['php_version']['current'] }}</p>
                                    </div>
                                    <div class="text-end">
                                        <span class="status-badge {{ $requirements['php_version']['status'] ? 'status-pass' : 'status-fail' }}">
                                            <i class="fas fa-{{ $requirements['php_version']['status'] ? 'check' : 'times' }}"></i>
                                            {{ $requirements['php_version']['status'] ? 'PASS' : 'FAIL' }}
                                        </span>
                                    </div>
                                </div>
                            </div>

                            <!-- Required Extensions -->
                            <div class="requirement-item">
                                <h6 class="mb-3">Required PHP Extensions</h6>
                                <div class="row">
                                    @foreach($requirements['extensions'] as $extension => $status)
                                    <div class="col-md-4 mb-2">
                                        <div class="d-flex justify-content-between">
                                            <span>{{ ucfirst($extension) }}</span>
                                            <span class="status-badge {{ $status ? 'status-pass' : 'status-fail' }}">
                                                <i class="fas fa-{{ $status ? 'check' : 'times' }}"></i>
                                            </span>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                            </div>

                            <!-- File Permissions -->
                            <div class="requirement-item">
                                <h6 class="mb-3">File Permissions</h6>
                                <div class="row">
                                    @foreach($requirements['permissions'] as $permission => $status)
                                    <div class="col-md-4 mb-2">
                                        <div class="d-flex justify-content-between">
                                            <span>{{ ucfirst(str_replace('_', ' ', $permission)) }}</span>
                                            <span class="status-badge {{ $status ? 'status-pass' : 'status-fail' }}">
                                                <i class="fas fa-{{ $status ? 'check' : 'times' }}"></i>
                                            </span>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>

                        <div id="results-summary" class="text-center mt-4" style="display: none;">
                            <div id="summary-icon" class="mb-3"></div>
                            <h4 id="summary-title"></h4>
                            <p id="summary-message" class="text-muted"></p>
                        </div>

                        <div class="d-grid gap-3 mt-4">
                            <button id="check-btn" class="btn btn-primary btn-lg" onclick="checkRequirements()">
                                <i class="fas fa-sync-alt fa-spin" id="check-spinner" style="display: none;"></i>
                                <span id="check-text">Re-check Requirements</span>
                            </button>
                            
                            <div id="continue-btn" style="display: none;">
                                <a href="{{ route('install.database') }}" class="btn btn-success btn-lg">
                                    <i class="fas fa-arrow-right"></i> Continue to Database Setup
                                </a>
                            </div>

                            <a href="{{ route('install.welcome') }}" class="btn btn-outline-secondary">
                                <i class="fas fa-arrow-left"></i> Go Back
                            </a>
                        </div>

                        <div id="error-alert" class="alert alert-danger mt-3" style="display: none;">
                            <i class="fas fa-exclamation-triangle"></i>
                            <strong>Requirements Not Met:</strong>
                            <ul id="error-list" class="mt-2 mb-0"></ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function checkRequirements() {
            const btn = document.getElementById('check-btn');
            const spinner = document.getElementById('check-spinner');
            const text = document.getElementById('check-text');
            
            btn.disabled = true;
            spinner.style.display = 'inline-block';
            text.textContent = 'Checking...';
            
            // Simulate checking (in real app, this would be an AJAX call)
            setTimeout(() => {
                // This would normally be handled by the server-side logic
                // For now, we'll assume the check is done server-side
                location.reload();
            }, 1000);
        }

        // Initialize progress bar
        document.addEventListener('DOMContentLoaded', function() {
            const progressBar = document.getElementById('progress-bar');
            const progressText = document.getElementById('progress-text');
            
            let width = 0;
            const interval = setInterval(function() {
                if (width >= 100) {
                    clearInterval(interval);
                } else {
                    width++;
                    progressBar.style.width = width + '%';
                    progressText.textContent = width + '%';
                }
            }, 20);
        });
    </script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
