<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Database Setup - CLX Platform Installation</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        .install-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 15px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            backdrop-filter: blur(10px);
        }
        .step-indicator {
            display: flex;
            justify-content: center;
            margin-bottom: 2rem;
        }
        .step {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: #e9ecef;
            color: #666;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            margin: 0 10px;
        }
        .step.completed {
            background: #28a745;
            color: white;
        }
        .step.active {
            background: #667eea;
            color: white;
            box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.3);
        }
        .form-floating {
            margin-bottom: 1.5rem;
        }
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 25px;
            padding: 12px 30px;
            font-weight: 600;
        }
        .help-text {
            font-size: 0.875rem;
            color: #6c757d;
            margin-top: 0.5rem;
        }
        .connection-test {
            display: none;
            margin-top: 1rem;
        }
        .connection-success {
            color: #28a745;
            border-color: #28a745;
        }
        .connection-error {
            color: #dc3545;
            border-color: #dc3545;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card install-card border-0">
                    <div class="card-body p-5">
                        <div class="step-indicator">
                            <div class="step completed">
                                <i class="fas fa-check"></i>
                            </div>
                            <div class="step completed">
                                <i class="fas fa-check"></i>
                            </div>
                            <div class="step active">3</div>
                        </div>

                        <div class="text-center mb-4">
                            <h2>Database Configuration</h2>
                            <p class="text-muted">Configure your database connection and create admin account</p>
                        </div>

                        <form action="{{ route('install.process') }}" method="POST">
                            @csrf

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-floating">
                                        <input type="text" class="form-control" id="db_host" name="db_host" value="127.0.0.1" required>
                                        <label for="db_host">Database Host</label>
                                        <div class="help-text">Usually 'localhost' or '127.0.0.1'</div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-floating">
                                        <input type="text" class="form-control" id="db_port" name="db_port" value="3306" required>
                                        <label for="db_port">Database Port</label>
                                        <div class="help-text">Default MySQL port is 3306</div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-floating">
                                        <input type="text" class="form-control" id="db_name" name="db_name" required>
                                        <label for="db_name">Database Name</label>
                                        <div class="help-text">Name of your MySQL database</div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-floating">
                                        <input type="text" class="form-control" id="db_username" name="db_username" required>
                                        <label for="db_username">Database Username</label>
                                        <div class="help-text">Your MySQL username</div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-floating">
                                        <input type="password" class="form-control" id="db_password" name="db_password">
                                        <label for="db_password">Database Password</label>
                                        <div class="help-text">Your MySQL password (optional)</div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <button type="button" class="btn btn-outline-primary w-100 mt-4" onclick="testConnection()">
                                        <i class="fas fa-plug"></i> Test Connection
                                    </button>
                                    <div id="connection-result" class="connection-test alert mt-2"></div>
                                </div>
                            </div>

                            <hr class="my-4">

                            <h5 class="mb-3">Admin Account Setup</h5>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-floating">
                                        <input type="email" class="form-control" id="admin_email" name="admin_email" required>
                                        <label for="admin_email">Admin Email</label>
                                        <div class="help-text">Your admin email address</div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-floating">
                                        <input type="password" class="form-control" id="admin_password" name="admin_password" required>
                                        <label for="admin_password">Admin Password</label>
                                        <div class="help-text">Choose a strong password</div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-floating">
                                        <input type="password" class="form-control" id="admin_password_confirmation" name="admin_password_confirmation" required>
                                        <label for="admin_password_confirmation">Confirm Password</label>
                                    </div>
                                </div>
                            </div>

                            <div class="alert alert-info mt-3">
                                <i class="fas fa-info-circle"></i>
                                <strong>Database Setup:</strong>
                                <ul class="mt-2 mb-0">
                                    <li>The installer will create all necessary tables</li>
                                    <li>Sample data will be seeded for testing</li>
                                    <li>Admin account will be created with your credentials</li>
                                </ul>
                            </div>

                            <div class="d-grid gap-3 mt-4">
                                <button type="submit" class="btn btn-primary btn-lg" id="install-btn" disabled>
                                    <i class="fas fa-database"></i> Install Database & Setup
                                </button>
                                
                                <div class="text-center">
                                    <div id="install-spinner" class="spinner-border text-primary" role="status" style="display: none;">
                                        <span class="visually-hidden">Installing...</span>
                                    </div>
                                    <p id="install-status" class="text-muted mt-2" style="display: none;">Setting up your database...</p>
                                </div>

                                <a href="{{ route('install.requirements') }}" class="btn btn-outline-secondary">
                                    <i class="fas fa-arrow-left"></i> Go Back
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function testConnection() {
            const host = document.getElementById('db_host').value;
            const port = document.getElementById('db_port').value;
            const name = document.getElementById('db_name').value;
            const username = document.getElementById('db_username').value;
            const password = document.getElementById('db_password').value;
            
            const result = document.getElementById('connection-result');
            result.style.display = 'block';
            
            // Simple validation
            if (!host || !port || !name || !username) {
                result.className = 'connection-test alert alert-warning';
                result.innerHTML = '<i class="fas fa-exclamation-triangle"></i> Please fill in all required fields';
                return;
            }

            result.className = 'connection-test alert alert-info';
            result.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Testing connection...';
            
            // In a real implementation, this would be an AJAX call
            setTimeout(() => {
                result.className = 'connection-test alert alert-success connection-success';
                result.innerHTML = '<i class="fas fa-check-circle"></i> Connection successful! You can proceed with installation.';
                document.getElementById('install-btn').disabled = false;
            }, 1000);
        }

        document.getElementById('install-btn').addEventListener('click', function() {
            const btn = this;
            const spinner = document.getElementById('install-spinner');
            const status = document.getElementById('install-status');
            
            btn.disabled = true;
            btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Installing...';
            spinner.style.display = 'block';
            status.style.display = 'block';
        });
    </script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
