<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Installation Complete - CLX Platform</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        .install-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 15px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            backdrop-filter: blur(10px);
        }
        .success-icon {
            font-size: 4rem;
            color: #28a745;
            margin-bottom: 1rem;
        }
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 25px;
            padding: 12px 30px;
            font-weight: 600;
        }
        .feature-card {
            border: 1px solid #e9ecef;
            border-radius: 10px;
            padding: 1.5rem;
            margin-bottom: 1rem;
            transition: all 0.3s ease;
        }
        .feature-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .credentials-box {
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            border-radius: 10px;
            padding: 1.5rem;
            margin-bottom: 2rem;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card install-card border-0">
                    <div class="card-body p-5 text-center">
                        <div class="success-icon">
                            <i class="fas fa-check-circle"></i>
                        </div>
                        
                        <h1 class="text-success mb-3">Installation Complete!</h1>
                        <p class="text-muted fs-5 mb-4">
                            Your CLX Premium Classifieds Platform has been successfully installed and configured.
                        </p>

                        <div class="credentials-box">
                            <h5 class="mb-3">Your Admin Credentials</h5>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="text-start">
                                        <strong>Email:</strong><br>
                                        <span class="text-primary">{{ session('admin_email', 'admin@example.com') }}</span>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="text-start">
                                        <strong>Password:</strong><br>
                                        <span class="text-primary">Your chosen password</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-md-4">
                                <div class="feature-card">
                                    <i class="fas fa-rocket fa-2x text-primary mb-3"></i>
                                    <h6>Ready to Use</h6>
                                    <p class="text-muted small">All features are active and ready for your users</p>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="feature-card">
                                    <i class="fas fa-shield-alt fa-2x text-success mb-3"></i>
                                    <h6>Secure Setup</h6>
                                    <p class="text-muted small">Security features are configured and enabled</p>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="feature-card">
                                    <i class="fas fa-chart-line fa-2x text-info mb-3"></i>
                                    <h6>Analytics Ready</h6>
                                    <p class="text-muted small">Business intelligence and tracking are active</p>
                                </div>
                            </div>
                        </div>

                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i>
                            <strong>Next Steps:</strong>
                            <ul class="mt-2 mb-0">
                                <li>Access your admin dashboard to customize settings</li>
                                <li>Configure payment gateways for monetization</li>
                                <li>Set up push notifications for user engagement</li>
                                <li>Add your business information and branding</li>
                            </ul>
                        </div>

                        <div class="d-grid gap-3">
                            <a href="/admin" class="btn btn-primary btn-lg">
                                <i class="fas fa-tachometer-alt"></i> Access Admin Dashboard
                            </a>
                            <a href="/admin/notifications" class="btn btn-success btn-lg">
                                <i class="fas fa-bell"></i> Setup Push Notifications
                            </a>
                            <a href="/admin/settings" class="btn btn-info btn-lg">
                                <i class="fas fa-cog"></i> Configure Settings
                            </a>
                            <a href="/docs" class="btn btn-outline-secondary">
                                <i class="fas fa-book"></i> View Documentation
                            </a>
                        </div>

                        <hr class="my-4">

                        <div class="text-center">
                            <h6 class="text-muted">Need Help?</h6>
                            <p class="text-muted small">
                                Visit our documentation or contact support if you need assistance.<br>
                                Your CLX Platform is now ready to help you build a successful classifieds business!
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
