<!-- Enhanced User Profile Modal -->
<div id="userProfileModal" class="modal" style="display: none;">
    <div class="modal-content" style="max-width: 1200px; max-height: 90vh; overflow: hidden; border-radius: 16px;">
        <div class="modal-header" style="padding: 24px; border-bottom: 1px solid #e5e7eb; display: flex; justify-content: space-between; align-items: center; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
            <div style="color: white;">
                <h3 style="margin: 0; font-size: 1.5rem; font-weight: 700;" id="userProfileTitle">User Profile</h3>
                <div style="font-size: 0.875rem; opacity: 0.9; margin-top: 4px;" id="userProfileSubtitle">Loading user details...</div>
            </div>
            <div style="display: flex; gap: 12px; align-items: center;">
                <button onclick="exportUserReport()" style="padding: 10px 16px; background: rgba(255,255,255,0.2); color: white; border: 1px solid rgba(255,255,255,0.3); border-radius: 8px; font-size: 0.875rem; cursor: pointer; backdrop-filter: blur(10px);">Export Report</button>
                <button onclick="openUserActions()" style="padding: 10px 16px; background: rgba(255,255,255,0.2); color: white; border: 1px solid rgba(255,255,255,0.3); border-radius: 8px; font-size: 0.875rem; cursor: pointer; backdrop-filter: blur(10px);">Quick Actions</button>
                <button onclick="closeUserProfileModal()" style="background: rgba(255,255,255,0.2); border: 1px solid rgba(255,255,255,0.3); color: white; border-radius: 50%; width: 40px; height: 40px; cursor: pointer; display: flex; align-items: center; justify-content: center; backdrop-filter: blur(10px);">✕</button>
            </div>
        </div>
        
        <div style="display: flex; height: calc(90vh - 100px);">
            <!-- Sidebar Navigation -->
            <div style="width: 320px; background: #f8fafc; border-right: 1px solid #e5e7eb; padding: 24px; overflow-y: auto; position: sticky; top: 0;">
                <!-- User Header -->
                <div style="text-align: center; margin-bottom: 32px;">
                    <div id="profileSidebarAvatar" style="width: 100px; height: 100px; border-radius: 50%; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); margin: 0 auto 16px; display: flex; align-items: center; justify-content: center; color: white; font-size: 2.5rem; font-weight: bold; box-shadow: 0 10px 30px rgba(102, 126, 234, 0.3);">
                        JD
                    </div>
                    <h4 id="profileSidebarName" style="margin: 0 0 8px 0; font-size: 1.25rem; color: #1f2937;">Loading...</h4>
                    <p id="profileSidebarEmail" style="margin: 0 0 12px 0; color: #6b7280; font-size: 0.875rem;">...</p>
                    <div id="profileSidebarBadges" style="display: flex; justify-content: center; gap: 8px; margin-bottom: 16px;">
                        <!-- Badges will be injected here -->
                    </div>
                    <div style="display: flex; justify-content: center; align-items: center; gap: 16px; color: #6b7280; font-size: 0.875rem;">
                        <span id="profileSidebarLocation">📍 ...</span>
                        <span id="profileSidebarPhone">📱 ...</span>
                    </div>
                </div>

                <!-- Navigation -->
                <div style="display: flex; flex-direction: column; gap: 8px;">
                    <button onclick="showUserSection('overview')" class="nav-btn active" data-section="overview">
                        <span style="font-size: 1.2rem; margin-right: 12px;">👤</span>
                        <div style="text-align: left; flex: 1;">
                            <div style="font-weight: 600; font-size: 0.875rem;">Overview</div>
                            <div style="font-size: 0.75rem; color: #6b7280;">Basic info & stats</div>
                        </div>
                        <span style="width: 4px; height: 4px; background: #667eea; border-radius: 50%;"></span>
                    </button>
                    
                    <button onclick="showUserSection('ads')" class="nav-btn" data-section="ads">
                        <span style="font-size: 1.2rem; margin-right: 12px;">📊</span>
                        <div style="text-align: left; flex: 1;">
                            <div style="font-weight: 600; font-size: 0.875rem;">Ads & Listings</div>
                            <div style="font-size: 0.75rem; color: #6b7280;">Active & expired ads</div>
                        </div>
                    </button>
                    
                    <button onclick="showUserSection('transactions')" class="nav-btn" data-section="transactions">
                        <span style="font-size: 1.2rem; margin-right: 12px;">💳</span>
                        <div style="text-align: left; flex: 1;">
                            <div style="font-weight: 600; font-size: 0.875rem;">Transactions</div>
                            <div style="font-size: 0.75rem; color: #6b7280;">Payments & purchases</div>
                        </div>
                    </button>
                    
                    <button onclick="showUserSection('security')" class="nav-btn" data-section="security">
                        <span style="font-size: 1.2rem; margin-right: 12px;">🔒</span>
                        <div style="text-align: left; flex: 1;">
                            <div style="font-weight: 600; font-size: 0.875rem;">Security</div>
                            <div style="font-size: 0.75rem; color: #6b7280;">Login history & 2FA</div>
                        </div>
                    </button>
                    
                    <button onclick="showUserSection('analytics')" class="nav-btn" data-section="analytics">
                        <span style="font-size: 1.2rem; margin-right: 12px;">📈</span>
                        <div style="text-align: left; flex: 1;">
                            <div style="font-weight: 600; font-size: 0.875rem;">Analytics</div>
                            <div style="font-size: 0.75rem; color: #6b7280;">Behavior & engagement</div>
                        </div>
                    </button>
                    
                    <button onclick="showUserSection('reports')" class="nav-btn" data-section="reports">
                        <span style="font-size: 1.2rem; margin-right: 12px;">⚠️</span>
                        <div style="text-align: left; flex: 1;">
                            <div style="font-weight: 600; font-size: 0.875rem;">Reports</div>
                            <div style="font-size: 0.75rem; color: #6b7280;">Safety & violations</div>
                        </div>
                    </button>
                    
                    <button onclick="showUserSection('settings')" class="nav-btn" data-section="settings">
                        <span style="font-size: 1.2rem; margin-right: 12px;">⚙️</span>
                        <div style="text-align: left; flex: 1;">
                            <div style="font-weight: 600; font-size: 0.875rem;">Settings</div>
                            <div style="font-size: 0.75rem; color: #6b7280;">Preferences & controls</div>
                        </div>
                    </button>
                </div>

                <!-- Quick Stats -->
                <div style="margin-top: 32px; padding: 16px; background: white; border-radius: 12px; border: 1px solid #e5e7eb;">
                    <h5 style="margin: 0 0 12px 0; font-size: 0.875rem; color: #6b7280; text-transform: uppercase; letter-spacing: 0.05em;">Quick Stats</h5>
                    <div style="display: grid; gap: 8px;">
                        <div style="display: flex; justify-content: space-between; align-items: center; padding: 8px; background: #f9fafb; border-radius: 8px;">
                            <span style="color: #6b7280; font-size: 0.875rem;">Total Ads</span>
                            <span style="font-weight: 700; color: #1f2937;">12</span>
                        </div>
                        <div style="display: flex; justify-content: space-between; align-items: center; padding: 8px; background: #f9fafb; border-radius: 8px;">
                            <span style="color: #6b7280; font-size: 0.875rem;">Trust Score</span>
                            <span style="font-weight: 700; color: #1f2937;">85%</span>
                        </div>
                        <div style="display: flex; justify-content: space-between; align-items: center; padding: 8px; background: #f9fafb; border-radius: 8px;">
                            <span style="color: #6b7280; font-size: 0.875rem;">Last Login</span>
                            <span style="font-weight: 700; color: #1f2937;">2h ago</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Main Content Area -->
            <div style="flex: 1; overflow-y: auto; padding: 24px; background: #ffffff;">
                <div id="userProfileContent">
                    <!-- Content will be loaded here based on selected section -->
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions Modal -->
<div id="userActionsModal" class="modal" style="display: none;">
    <div class="modal-content" style="max-width: 600px; border-radius: 16px;">
        <div class="modal-header" style="padding: 24px; border-bottom: 1px solid #e5e7eb; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
            <h3 style="margin: 0; font-size: 1.25rem; color: white;">Quick Actions</h3>
            <button onclick="closeUserActionsModal()" style="background: rgba(255,255,255,0.2); border: 1px solid rgba(255,255,255,0.3); color: white; border-radius: 50%; width: 40px; height: 40px; cursor: pointer; display: flex; align-items: center; justify-content: center; backdrop-filter: blur(10px); position: absolute; top: 24px; right: 24px;">✕</button>
        </div>
        <div style="padding: 24px;">
            <div style="display: grid; gap: 16px;">
                <div class="action-card" style="background: #f8fafc; padding: 20px; border-radius: 12px; border: 1px solid #e5e7eb; transition: all 0.3s ease;">
                    <div style="display: flex; align-items: center; gap: 16px;">
                        <div style="width: 48px; height: 48px; border-radius: 12px; background: #dcfce7; color: #10b981; display: flex; align-items: center; justify-content: center; font-weight: bold; font-size: 1.5rem;">✅</div>
                        <div style="flex: 1;">
                            <div style="font-weight: 700; color: #1f2937; margin-bottom: 4px;">Verify User</div>
                            <div style="font-size: 0.875rem; color: #6b7280;">Manually verify user identity</div>
                        </div>
                        <button onclick="verifyUserQuick()" style="padding: 10px 20px; background: #10b981; color: white; border: none; border-radius: 8px; font-weight: 600; cursor: pointer; transition: all 0.2s ease;">Verify Now</button>
                    </div>
                </div>
                
                <div class="action-card" style="background: #f8fafc; padding: 20px; border-radius: 12px; border: 1px solid #e5e7eb; transition: all 0.3s ease;">
                    <div style="display: flex; align-items: center; gap: 16px;">
                        <div style="width: 48px; height: 48px; border-radius: 12px; background: #fee2e2; color: #ef4444; display: flex; align-items: center; justify-content: center; font-weight: bold; font-size: 1.5rem;">🚫</div>
                        <div style="flex: 1;">
                            <div style="font-weight: 700; color: #1f2937; margin-bottom: 4px;">Suspend User</div>
                            <div style="font-size: 0.875rem; color: #6b7280;">Temporarily disable account</div>
                        </div>
                        <button onclick="suspendUserQuick()" style="padding: 10px 20px; background: #ef4444; color: white; border: none; border-radius: 8px; font-weight: 600; cursor: pointer; transition: all 0.2s ease;">Suspend User</button>
                    </div>
                    <div style="margin-top: 16px; display: grid; gap: 8px;">
                        <select id="suspendDuration" style="padding: 10px 12px; border: 1px solid #e5e7eb; border-radius: 8px; font-size: 0.875rem;">
                            <option value="1">1 Hour</option>
                            <option value="24">1 Day</option>
                            <option value="168">1 Week</option>
                            <option value="720">1 Month</option>
                            <option value="permanent">Permanent</option>
                        </select>
                        <textarea id="suspendReason" rows="3" style="padding: 10px 12px; border: 1px solid #e5e7eb; border-radius: 8px; font-size: 0.875rem;" placeholder="Reason for suspension..."></textarea>
                    </div>
                </div>
                
                <div class="action-card" style="background: #f8fafc; padding: 20px; border-radius: 12px; border: 1px solid #e5e7eb; transition: all 0.3s ease;">
                    <div style="display: flex; align-items: center; gap: 16px;">
                        <div style="width: 48px; height: 48px; border-radius: 12px; background: #e0f2fe; color: #0ea5e9; display: flex; align-items: center; justify-content: center; font-weight: bold; font-size: 1.5rem;">📧</div>
                        <div style="flex: 1;">
                            <div style="font-weight: 700; color: #1f2937; margin-bottom: 4px;">Send Notification</div>
                            <div style="font-size: 0.875rem; color: #6b7280;">Send push/email notification</div>
                        </div>
                        <button onclick="sendNotificationQuick()" style="padding: 10px 20px; background: #3b82f6; color: white; border: none; border-radius: 8px; font-weight: 600; cursor: pointer; transition: all 0.2s ease;">Send Notification</button>
                    </div>
                    <div style="margin-top: 16px; display: grid; gap: 8px;">
                        <select id="notificationType" style="padding: 10px 12px; border: 1px solid #e5e7eb; border-radius: 8px; font-size: 0.875rem;">
                            <option value="info">Information</option>
                            <option value="warning">Warning</option>
                            <option value="error">Error</option>
                            <option value="success">Success</option>
                        </select>
                        <textarea id="notificationMessage" rows="3" style="padding: 10px 12px; border: 1px solid #e5e7eb; border-radius: 8px; font-size: 0.875rem;" placeholder="Notification message..."></textarea>
                    </div>
                </div>
                
                <div class="action-card" style="background: #f8fafc; padding: 20px; border-radius: 12px; border: 1px solid #e5e7eb; transition: all 0.3s ease;">
                    <div style="display: flex; align-items: center; gap: 16px;">
                        <div style="width: 48px; height: 48px; border-radius: 12px; background: #fef3c7; color: #f59e0b; display: flex; align-items: center; justify-content: center; font-weight: bold; font-size: 1.5rem;">💎</div>
                        <div style="flex: 1;">
                            <div style="font-weight: 700; color: #1f2937; margin-bottom: 4px;">Upgrade Plan</div>
                            <div style="font-size: 0.875rem; color: #6b7280;">Change user subscription</div>
                        </div>
                        <div style="display: flex; gap: 8px;">
                            <button onclick="upgradePlanQuick()" style="padding: 10px 20px; background: #10b981; color: white; border: none; border-radius: 8px; font-weight: 600; cursor: pointer; transition: all 0.2s ease;">Upgrade</button>
                            <button onclick="downgradePlanQuick()" style="padding: 10px 20px; background: #f59e0b; color: white; border: none; border-radius: 8px; font-weight: 600; cursor: pointer; transition: all 0.2s ease;">Downgrade</button>
                        </div>
                    </div>
                    <div style="margin-top: 16px; display: grid; gap: 8px;">
                        <select id="newPlan" style="padding: 10px 12px; border: 1px solid #e5e7eb; border-radius: 8px; font-size: 0.875rem;">
                            <option value="free">Free Plan</option>
                            <option value="basic">Basic Plan</option>
                            <option value="premium">Premium Plan</option>
                            <option value="enterprise">Enterprise Plan</option>
                        </select>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // Enhanced User Profile Functions
    function viewUserProfile(userId) {
        window.currentUserId = userId;
        document.getElementById('userProfileTitle').textContent = `User Profile: User #${userId}`;
        document.getElementById('userProfileSubtitle').textContent = 'Loading user details...';
        
        // Show modal immediately with loading state
        document.getElementById('userProfileModal').style.display = 'flex';
        
        // Fetch real data
        fetch(`/admin/users/${userId}/details`)
            .then(response => response.json())
            .then(data => {
                window.currentUserData = data;
                updateSidebar(data);
                document.getElementById('userProfileSubtitle').textContent = `Member since ${new Date(data.user.created_at).toLocaleDateString()}`;
                // Refresh current section if it's open, defaulting to overview
                showUserSection('overview');
            })
            .catch(err => {
                console.error(err);
                document.getElementById('userProfileSubtitle').textContent = 'Error loading data';
            });
    }

    function updateSidebar(data) {
        const user = data.user;
        document.getElementById('profileSidebarName').textContent = user.name || 'No Name';
        document.getElementById('profileSidebarEmail').textContent = user.email;
        document.getElementById('profileSidebarAvatar').textContent = user.name ? user.name.substring(0, 2).toUpperCase() : '??';
        
        const loc = [user.city, user.country].filter(Boolean).join(', ');
        document.getElementById('profileSidebarLocation').textContent = loc ? `📍 ${loc}` : '📍 N/A';
        document.getElementById('profileSidebarPhone').textContent = user.mobile_number ? `📱 ${user.mobile_number}` : '📱 N/A';

        // Badges
        const badgesDiv = document.getElementById('profileSidebarBadges');
        badgesDiv.innerHTML = '';
        if (user.is_verified) {
             badgesDiv.innerHTML += `<span style="background: #dcfce7; color: #10b981; padding: 4px 8px; border-radius: 20px; font-size: 0.75rem; font-weight: 600;">Verified</span>`;
        }
        if (user.current_plan) { // backend might return plan details, assumed in user object or logic
             // For now simpler
             badgesDiv.innerHTML += `<span style="background: #e0f2fe; color: #0ea5e9; padding: 4px 8px; border-radius: 20px; font-size: 0.75rem; font-weight: 600;">Plan: ${user.current_plan_id || 'Free'}</span>`;
        }
    }

    function showUserSection(section) {
        // Update navigation buttons
        document.querySelectorAll('.nav-btn').forEach(btn => {
            btn.classList.remove('active');
            btn.style.background = 'transparent';
            btn.style.borderLeft = 'none';
        });
        
        const activeBtn = document.querySelector(`.nav-btn[data-section="${section}"]`);
        if (activeBtn) {
            activeBtn.classList.add('active');
            activeBtn.style.background = 'rgba(102, 126, 234, 0.1)';
            activeBtn.style.borderLeft = '4px solid #667eea';
        }

        // Load section content
        const contentDiv = document.getElementById('userProfileContent');
        
        switch(section) {
            case 'overview':
                loadOverviewSection(contentDiv);
                break;
            case 'ads':
                loadAdsSection(contentDiv);
                break;
            case 'transactions':
                loadTransactionsSection(contentDiv);
                break;
            case 'security':
                loadSecuritySection(contentDiv);
                break;
            case 'analytics':
                loadAnalyticsSection(contentDiv);
                break;
            case 'reports':
                loadReportsSection(contentDiv);
                break;
            case 'settings':
                loadSettingsSection(contentDiv);
                break;
        }
    }

    function loadOverviewSection(contentDiv) {
        if (!window.currentUserData) return;
        const data = window.currentUserData;
        const user = data.user;
        const stats = data.stats;

        contentDiv.innerHTML = `
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 24px;">
                <!-- User Info Card -->
                <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 24px; border-radius: 16px; color: white; position: relative; overflow: hidden;">
                    <div style="position: absolute; top: -50px; right: -50px; width: 150px; height: 150px; background: rgba(255,255,255,0.1); border-radius: 50%;"></div>
                    <div style="position: absolute; bottom: -30px; left: -30px; width: 100px; height: 100px; background: rgba(255,255,255,0.1); border-radius: 50%;"></div>
                    <div style="position: relative; z-index: 1;">
                        <div style="display: flex; align-items: center; gap: 20px; margin-bottom: 20px;">
                            <div style="width: 80px; height: 80px; border-radius: 50%; background: rgba(255,255,255,0.2); display: flex; align-items: center; justify-content: center; font-weight: bold; font-size: 2rem; border: 3px solid rgba(255,255,255,0.3);">
                                ${user.name ? user.name.substring(0, 2).toUpperCase() : '??'}
                            </div>
                            <div>
                                <div style="font-size: 1.5rem; font-weight: 800; margin-bottom: 4px;">${user.name || 'No Name'}</div>
                                <div style="font-size: 0.875rem; opacity: 0.9;">User ID: #${user.id}</div>
                            </div>
                        </div>
                        <div style="display: grid; gap: 12px;">
                            <div style="display: flex; justify-content: space-between; align-items: center; padding: 12px; background: rgba(255,255,255,0.1); border-radius: 8px; border: 1px solid rgba(255,255,255,0.2);">
                                <span style="opacity: 0.8; font-size: 0.875rem;">Email</span>
                                <span style="font-weight: 600;">${user.email}</span>
                            </div>
                            <div style="display: flex; justify-content: space-between; align-items: center; padding: 12px; background: rgba(255,255,255,0.1); border-radius: 8px; border: 1px solid rgba(255,255,255,0.2);">
                                <span style="opacity: 0.8; font-size: 0.875rem;">Phone</span>
                                <span style="font-weight: 600;">${user.mobile_number || 'N/A'}</span>
                            </div>
                            <div style="display: flex; justify-content: space-between; align-items: center; padding: 12px; background: rgba(255,255,255,0.1); border-radius: 8px; border: 1px solid rgba(255,255,255,0.2);">
                                <span style="opacity: 0.8; font-size: 0.875rem;">Location</span>
                                <span style="font-weight: 600;">📍 ${[user.city, user.country].filter(Boolean).join(', ') || 'Unknown'}</span>
                            </div>
                            <div style="display: flex; justify-content: space-between; align-items: center; padding: 12px; background: rgba(255,255,255,0.1); border-radius: 8px; border: 1px solid rgba(255,255,255,0.2);">
                                <span style="opacity: 0.8; font-size: 0.875rem;">Joined</span>
                                <span style="font-weight: 600;">${new Date(user.created_at).toLocaleDateString()}</span>
                            </div>
                            <div style="display: flex; justify-content: space-between; align-items: center; padding: 12px; background: rgba(255,255,255,0.1); border-radius: 8px; border: 1px solid rgba(255,255,255,0.2);">
                                <span style="opacity: 0.8; font-size: 0.875rem;">Last Login</span>
                                <span style="font-weight: 600;">${user.last_login ? new Date(user.last_login).toLocaleString() : 'Never'}</span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Account Stats -->
                <div style="display: grid; gap: 16px;">
                    <div style="background: #f8fafc; padding: 20px; border-radius: 12px; border: 1px solid #e5e7eb; transition: all 0.3s ease;">
                        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 12px;">
                            <div>
                                <div style="font-size: 0.875rem; color: #6b7280; margin-bottom: 4px;">Subscription Plan</div>
                                <div style="font-weight: 800; font-size: 1.25rem; color: #1f2937;">${user.current_plan_id || 'Free Plan'}</div>
                            </div>
                            <div style="display: flex; gap: 8px;">
                                <button onclick="upgradePlanQuick()" style="padding: 8px 16px; background: #667eea; color: white; border: none; border-radius: 8px; font-weight: 600; cursor: pointer; transition: all 0.2s ease;">Manage Plan</button>
                            </div>
                        </div>
                        <div style="display: flex; justify-content: space-between; align-items: center; padding: 12px; background: white; border-radius: 8px; border: 1px solid #e5e7eb;">
                            <div>
                                <div style="font-size: 0.875rem; color: #6b7280;">Status</div>
                                <div style="font-weight: 700; color: #10b981;">Active</div>
                            </div>
                            <div>
                                <div style="font-size: 0.875rem; color: #6b7280;">Trust Score</div>
                                <div style="font-weight: 700; color: #f59e0b;">${stats.trust_score}%</div>
                            </div>
                            <div>
                                <div style="font-size: 0.875rem; color: #6b7280;">Total Ads</div>
                                <div style="font-weight: 700; color: #3b82f6;">${stats.total_ads}</div>
                            </div>
                        </div>
                    </div>

                    <div style="background: #f8fafc; padding: 20px; border-radius: 12px; border: 1px solid #e5e7eb; transition: all 0.3s ease;">
                        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 12px;">
                            <div>
                                <div style="font-size: 0.875rem; color: #6b7280; margin-bottom: 4px;">Account Verification</div>
                                <div style="font-weight: 800; font-size: 1.25rem; color: #1f2937;">${user.is_verified ? 'Verified' : 'Unverified'}</div>
                            </div>
                            <div style="display: flex; gap: 8px;">
                                ${!user.is_verified ? '<button onclick="verifyUserQuick()" style="padding: 8px 16px; background: #10b981; color: white; border: none; border-radius: 8px; font-weight: 600; cursor: pointer;">Verify</button>' : ''}
                            </div>
                        </div>
                        <div style="display: flex; justify-content: space-between; align-items: center; padding: 12px; background: white; border-radius: 8px; border: 1px solid #e5e7eb;">
                            <div>
                                <div style="font-size: 0.875rem; color: #6b7280;">Active Ads</div>
                                <div style="font-weight: 700; color: #10b981;">${stats.active_ads}</div>
                            </div>
                            <div>
                                <div style="font-size: 0.875rem; color: #6b7280;">Sold Ads</div>
                                <div style="font-weight: 700; color: #3b82f6;">${stats.sold_ads}</div>
                            </div>
                             <div>
                                <div style="font-size: 0.875rem; color: #6b7280;">Reports</div>
                                <div style="font-weight: 700; color: #ef4444;">${stats.safety_reports}</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recent Activity Placeholder -> this could be improved later -->
            <div style="margin-top: 24px; background: #f8fafc; padding: 24px; border-radius: 12px; border: 1px solid #e5e7eb;">
                 <h4 style="margin: 0 0 16px 0; font-size: 1.1rem; color: #1f2937;">Recent Ads</h4>
                 <div style="display: grid; gap: 12px;">
                    ${data.user_ads && data.user_ads.length > 0 ? data.user_ads.map(ad => `
                        <div style="display: flex; justify-content: space-between; align-items: center; padding: 16px; background: white; border-radius: 8px; border-left: 4px solid #3b82f6; box-shadow: 0 2px 4px rgba(0,0,0,0.05);">
                            <div style="display: flex; align-items: center; gap: 16px;">
                                <span style="width: 12px; height: 12px; background: #3b82f6; border-radius: 50%;"></span>
                                <div>
                                    <div style="font-weight: 700; color: #1f2937;">${ad.title}</div>
                                    <div style="font-size: 0.875rem; color: #6b7280;">${ad.currency} ${ad.price} - ${ad.status}</div>
                                </div>
                            </div>
                            <span style="color: #6b7280; font-size: 0.875rem;">${new Date(ad.created_at).toLocaleDateString()}</span>
                        </div>
                    `).join('') : '<p style="color: #6b7280;">No recent ads found.</p>'}
                 </div>
            </div>
        `;
    }

    function loadAdsSection(contentDiv) {
        contentDiv.innerHTML = `
            <div style="display: grid; gap: 16px;">
                <div style="display: flex; justify-content: space-between; align-items: center;">
                    <h4 style="margin: 0; font-size: 1.25rem; color: #1f2937;">Ads & Listings</h4>
                    <div style="display: flex; gap: 8px; align-items: center;">
                        <select style="padding: 10px 12px; border: 1px solid #e5e7eb; border-radius: 8px; font-size: 0.875rem;">
                            <option>All Status</option>
                            <option>Active</option>
                            <option>Expired</option>
                            <option>Suspended</option>
                        </select>
                        <button style="padding: 10px 20px; background: #3b82f6; color: white; border: none; border-radius: 8px; font-weight: 600; cursor: pointer; transition: all 0.2s ease;">+ Add New Ad</button>
                    </div>
                </div>
                
                <div class="table-card" style="border: none; padding: 0;">
                    <table class="table" style="border-radius: 12px; overflow: hidden; box-shadow: 0 4px 6px rgba(0,0,0,0.1);">
                        <thead style="background: #f8fafc; border-bottom: 2px solid #e5e7eb;">
                            <tr>
                                <th style="padding: 16px; text-align: left; font-weight: 700; color: #374151;">Ad Title</th>
                                <th style="padding: 16px; text-align: left; font-weight: 700; color: #374151;">Category</th>
                                <th style="padding: 16px; text-align: left; font-weight: 700; color: #374151;">Price</th>
                                <th style="padding: 16px; text-align: left; font-weight: 700; color: #374151;">Status</th>
                                <th style="padding: 16px; text-align: left; font-weight: 700; color: #374151;">Views</th>
                                <th style="padding: 16px; text-align: left; font-weight: 700; color: #374151;">Created</th>
                                <th style="padding: 16px; text-align: left; font-weight: 700; color: #374151;">Actions</th>
                            </tr>
                        </thead>
                        <tbody style="background: white;">
                            <tr style="border-bottom: 1px solid #e5e7eb;">
                                <td style="padding: 16px;">
                                    <div style="display: flex; align-items: center; gap: 16px;">
                                        <div style="width: 50px; height: 50px; border-radius: 8px; background: #e2e8f0; display: flex; align-items: center; justify-content: center; font-size: 1.5rem;">📱</div>
                                        <div>
                                            <div style="font-weight: 700; color: #1f2937;">iPhone 15 Pro</div>
                                            <div style="font-size: 0.875rem; color: #6b7280;">Like new, 128GB</div>
                                        </div>
                                    </div>
                                </td>
                                <td style="padding: 16px; color: #6b7280;">Electronics</td>
                                <td style="padding: 16px; font-weight: 700; color: #1f2937;">$950</td>
                                <td style="padding: 16px;"><span style="background: #dcfce7; color: #10b981; padding: 6px 12px; border-radius: 20px; font-size: 0.75rem; font-weight: 600;">Active</span></td>
                                <td style="padding: 16px; font-weight: 700; color: #1f2937;">1,234</td>
                                <td style="padding: 16px; color: #6b7280;">2 hours ago</td>
                                <td style="padding: 16px;">
                                    <div style="display: flex; gap: 8px;">
                                        <button style="padding: 6px 12px; background: #3b82f6; color: white; border: none; border-radius: 6px; font-size: 0.75rem; cursor: pointer;">View</button>
                                        <button style="padding: 6px 12px; background: #10b981; color: white; border: none; border-radius: 6px; font-size: 0.75rem; cursor: pointer;">Edit</button>
                                        <button style="padding: 6px 12px; background: #ef4444; color: white; border: none; border-radius: 6px; font-size: 0.75rem; cursor: pointer;">Suspend</button>
                                    </div>
                                </td>
                            </tr>
                            <tr style="border-bottom: 1px solid #e5e7eb;">
                                <td style="padding: 16px;">
                                    <div style="display: flex; align-items: center; gap: 16px;">
                                        <div style="width: 50px; height: 50px; border-radius: 8px; background: #e2e8f0; display: flex; align-items: center; justify-content: center; font-size: 1.5rem;">🏠</div>
                                        <div>
                                            <div style="font-weight: 700; color: #1f2937;">2BHK Apartment</div>
                                            <div style="font-size: 0.875rem; color: #6b7280;">Downtown area</div>
                                        </div>
                                    </div>
                                </td>
                                <td style="padding: 16px; color: #6b7280;">Real Estate</td>
                                <td style="padding: 16px; font-weight: 700; color: #1f2937;">$1,200/mo</td>
                                <td style="padding: 16px;"><span style="background: #dcfce7; color: #10b981; padding: 6px 12px; border-radius: 20px; font-size: 0.75rem; font-weight: 600;">Active</span></td>
                                <td style="padding: 16px; font-weight: 700; color: #1f2937;">892</td>
                                <td style="padding: 16px; color: #6b7280;">1 day ago</td>
                                <td style="padding: 16px;">
                                    <div style="display: flex; gap: 8px;">
                                        <button style="padding: 6px 12px; background: #3b82f6; color: white; border: none; border-radius: 6px; font-size: 0.75rem; cursor: pointer;">View</button>
                                        <button style="padding: 6px 12px; background: #10b981; color: white; border: none; border-radius: 6px; font-size: 0.75rem; cursor: pointer;">Edit</button>
                                        <button style="padding: 6px 12px; background: #ef4444; color: white; border: none; border-radius: 6px; font-size: 0.75rem; cursor: pointer;">Suspend</button>
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <td style="padding: 16px;">
                                    <div style="display: flex; align-items: center; gap: 16px;">
                                        <div style="width: 50px; height: 50px; border-radius: 8px; background: #fee2e2; display: flex; align-items: center; justify-content: center; font-size: 1.5rem;">⚠️</div>
                                        <div>
                                            <div style="font-weight: 700; color: #1f2937;">Used Laptop</div>
                                            <div style="font-size: 0.875rem; color: #6b7280;">Dell XPS 15</div>
                                        </div>
                                    </div>
                                </td>
                                <td style="padding: 16px; color: #6b7280;">Electronics</td>
                                <td style="padding: 16px; font-weight: 700; color: #1f2937;">$600</td>
                                <td style="padding: 16px;"><span style="background: #fee2e2; color: #ef4444; padding: 6px 12px; border-radius: 20px; font-size: 0.75rem; font-weight: 600;">Suspended</span></td>
                                <td style="padding: 16px; font-weight: 700; color: #1f2937;">156</td>
                                <td style="padding: 16px; color: #6b7280;">3 days ago</td>
                                <td style="padding: 16px;">
                                    <div style="display: flex; gap: 8px;">
                                        <button style="padding: 6px 12px; background: #3b82f6; color: white; border: none; border-radius: 6px; font-size: 0.75rem; cursor: pointer;">View</button>
                                        <button style="padding: 6px 12px; background: #f59e0b; color: white; border: none; border-radius: 6px; font-size: 0.75rem; cursor: pointer;">Review</button>
                                        <button style="padding: 6px 12px; background: #10b981; color: white; border: none; border-radius: 6px; font-size: 0.75rem; cursor: pointer;">Approve</button>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        `;
    }

    function loadTransactionsSection(contentDiv) {
        contentDiv.innerHTML = `
            <div style="display: grid; gap: 16px;">
                <div style="display: flex; justify-content: space-between; align-items: center;">
                    <h4 style="margin: 0; font-size: 1.25rem; color: #1f2937;">Transaction History</h4>
                    <div style="display: flex; gap: 8px; align-items: center;">
                        <select style="padding: 10px 12px; border: 1px solid #e5e7eb; border-radius: 8px; font-size: 0.875rem;">
                            <option>All Types</option>
                            <option>Subscription</option>
                            <option>Ad Promotion</option>
                            <option>Withdrawal</option>
                        </select>
                        <button style="padding: 10px 20px; background: #10b981; color: white; border: none; border-radius: 8px; font-weight: 600; cursor: pointer; transition: all 0.2s ease;">Export</button>
                    </div>
                </div>
                
                <div class="dashboard-grid" style="margin-bottom: 20px;">
                    <div class="card" style="background: linear-gradient(135deg, #10b981 0%, #34d399 100%); color: white; border: none;">
                        <div class="card-header" style="color: white;">
                            <div>
                                <div class="card-title" style="color: rgba(255,255,255,0.8);">Total Spent</div>
                                <div class="card-value" style="color: white;">$245.50</div>
                            </div>
                            <div class="stat-icon">💸</div>
                        </div>
                        <div class="card-change" style="color: rgba(255,255,255,0.8);">Last 6 months</div>
                    </div>

                    <div class="card" style="background: linear-gradient(135deg, #3b82f6 0%, #60a5fa 100%); color: white; border: none;">
                        <div class="card-header" style="color: white;">
                            <div>
                                <div class="card-title" style="color: rgba(255,255,255,0.8);">Total Earned</div>
                                <div class="card-value" style="color: white;">$1,230.00</div>
                            </div>
                            <div class="stat-icon">💰</div>
                        </div>
                        <div class="card-change" style="color: rgba(255,255,255,0.8);">From ad sales</div>
                    </div>

                    <div class="card" style="background: linear-gradient(135deg, #f59e0b 0%, #fbbf24 100%); color: white; border: none;">
                        <div class="card-header" style="color: white;">
                            <div>
                                <div class="card-title" style="color: rgba(255,255,255,0.8);">Balance</div>
                                <div class="card-value" style="color: white;">$984.50</div>
                            </div>
                            <div class="stat-icon">💳</div>
                        </div>
                        <div class="card-change" style="color: rgba(255,255,255,0.8);">Available for withdrawal</div>
                    </div>
                </div>

                <div class="table-card" style="border: none; padding: 0;">
                    <table class="table" style="border-radius: 12px; overflow: hidden; box-shadow: 0 4px 6px rgba(0,0,0,0.1);">
                        <thead style="background: #f8fafc; border-bottom: 2px solid #e5e7eb;">
                            <tr>
                                <th style="padding: 16px; text-align: left; font-weight: 700; color: #374151;">Date</th>
                                <th style="padding: 16px; text-align: left; font-weight: 700; color: #374151;">Type</th>
                                <th style="padding: 16px; text-align: left; font-weight: 700; color: #374151;">Description</th>
                                <th style="padding: 16px; text-align: left; font-weight: 700; color: #374151;">Amount</th>
                                <th style="padding: 16px; text-align: left; font-weight: 700; color: #374151;">Status</th>
                                <th style="padding: 16px; text-align: left; font-weight: 700; color: #374151;">Actions</th>
                            </tr>
                        </thead>
                        <tbody style="background: white;">
                            <tr style="border-bottom: 1px solid #e5e7eb;">
                                <td style="padding: 16px; color: #6b7280;">Jan 15, 2024</td>
                                <td style="padding: 16px;"><span style="background: #e0f2fe; color: #0ea5e9; padding: 6px 12px; border-radius: 20px; font-size: 0.75rem; font-weight: 600;">Subscription</span></td>
                                <td style="padding: 16px;">Premium Plan Monthly</td>
                                <td style="padding: 16px; font-weight: 700; color: #ef4444;">-$19.99</td>
                                <td style="padding: 16px;"><span style="background: #dcfce7; color: #10b981; padding: 6px 12px; border-radius: 20px; font-size: 0.75rem; font-weight: 600;">Completed</span></td>
                                <td style="padding: 16px;"><button style="padding: 6px 12px; background: #3b82f6; color: white; border: none; border-radius: 6px; font-size: 0.75rem; cursor: pointer;">Receipt</button></td>
                            </tr>
                            <tr style="border-bottom: 1px solid #e5e7eb;">
                                <td style="padding: 16px; color: #6b7280;">Jan 12, 2024</td>
                                <td style="padding: 16px;"><span style="background: #dcfce7; color: #10b981; padding: 6px 12px; border-radius: 20px; font-size: 0.75rem; font-weight: 600;">Payment</span></td>
                                <td style="padding: 16px;">iPhone 15 Pro Sale</td>
                                <td style="padding: 16px; font-weight: 700; color: #10b981;">+$950.00</td>
                                <td style="padding: 16px;"><span style="background: #dcfce7; color: #10b981; padding: 6px 12px; border-radius: 20px; font-size: 0.75rem; font-weight: 600;">Completed</span></td>
                                <td style="padding: 16px;"><button style="padding: 6px 12px; background: #3b82f6; color: white; border: none; border-radius: 6px; font-size: 0.75rem; cursor: pointer;">Details</button></td>
                            </tr>
                            <tr>
                                <td style="padding: 16px; color: #6b7280;">Jan 10, 2024</td>
                                <td style="padding: 16px;"><span style="background: #fef3c7; color: #f59e0b; padding: 6px 12px; border-radius: 20px; font-size: 0.75rem; font-weight: 600;">Promotion</span></td>
                                <td style="padding: 16px;">Ad Boost - 7 days</td>
                                <td style="padding: 16px; font-weight: 700; color: #ef4444;">-$25.50</td>
                                <td style="padding: 16px;"><span style="background: #dcfce7; color: #10b981; padding: 6px 12px; border-radius: 20px; font-size: 0.75rem; font-weight: 600;">Completed</span></td>
                                <td style="padding: 16px;"><button style="padding: 6px 12px; background: #3b82f6; color: white; border: none; border-radius: 6px; font-size: 0.75rem; cursor: pointer;">Receipt</button></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        `;
    }

    function loadSecuritySection(contentDiv) {
        contentDiv.innerHTML = `
            <div style="display: grid; gap: 16px;">
                <div style="display: flex; justify-content: space-between; align-items: center;">
                    <h4 style="margin: 0; font-size: 1.25rem; color: #1f2937;">Security & Login</h4>
                    <div style="display: flex; gap: 8px; align-items: center;">
                        <button style="padding: 10px 20px; background: #ef4444; color: white; border: none; border-radius: 8px; font-weight: 600; cursor: pointer; transition: all 0.2s ease;">Force Logout</button>
                        <button style="padding: 10px 20px; background: #f59e0b; color: white; border: none; border-radius: 8px; font-weight: 600; cursor: pointer; transition: all 0.2s ease;">Reset Password</button>
                    </div>
                </div>
                
                <div class="dashboard-grid">
                    <div class="card" style="background: linear-gradient(135deg, #10b981 0%, #34d399 100%); color: white; border: none;">
                        <div class="card-header" style="color: white;">
                            <div>
                                <div class="card-title" style="color: rgba(255,255,255,0.8);">Two-Factor Auth</div>
                                <div class="card-value" style="color: white;">Enabled</div>
                            </div>
                            <div class="stat-icon">🔐</div>
                        </div>
                        <div class="card-change" style="color: rgba(255,255,255,0.8);">SMS + Authenticator App</div>
                    </div>

                    <div class="card" style="background: linear-gradient(135deg, #3b82f6 0%, #60a5fa 100%); color: white; border: none;">
                        <div class="card-header" style="color: white;">
                            <div>
                                <div class="card-title" style="color: rgba(255,255,255,0.8);">Last Login</div>
                                <div class="card-value" style="color: white;">2 hours ago</div>
                            </div>
                            <div class="stat-icon">📍</div>
                        </div>
                        <div class="card-change" style="color: rgba(255,255,255,0.8);">New York, USA</div>
                    </div>

                    <div class="card" style="background: linear-gradient(135deg, #f59e0b 0%, #fbbf24 100%); color: white; border: none;">
                        <div class="card-header" style="color: white;">
                            <div>
                                <div class="card-title" style="color: rgba(255,255,255,0.8);">Active Sessions</div>
                                <div class="card-value" style="color: white;">3</div>
                            </div>
                            <div class="stat-icon">💻</div>
                        </div>
                        <div class="card-change" style="color: rgba(255,255,255,0.8);">Web, Mobile, Tablet</div>
                    </div>
                </div>

                <div style="background: #f8fafc; padding: 24px; border-radius: 12px; border: 1px solid #e5e7eb;">
                    <h4 style="margin: 0 0 16px 0; font-size: 1.1rem; color: #1f2937;">Recent Login Activity</h4>
                    <div style="display: grid; gap: 12px;">
                        <div style="display: flex; justify-content: space-between; align-items: center; padding: 16px; background: white; border-radius: 8px; border-left: 4px solid #10b981; box-shadow: 0 2px 4px rgba(0,0,0,0.05);">
                            <div style="display: flex; align-items: center; gap: 16px;">
