@extends('admin.layouts.app')

@section('content')
<div class="content-header">
    <h1>Ticket #{{ $ticket->ticket_number }}</h1>
    <a href="{{ route('admin.support.tickets') }}" style="padding: 8px 16px; background: #e5e7eb; border-radius: 6px; text-decoration: none; color: #333;">← Back to Tickets</a>
</div>

@if(session('success'))
<div style="padding: 16px; background: #10b981; color: white; border-radius: 8px; margin-bottom: 24px;">✓ {{ session('success') }}</div>
@endif

<div class="card" style="margin-bottom: 24px;">
    <div class="card-header"><h3>Ticket Details</h3></div>
    <div style="padding: 24px;">
        <div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 24px; margin-bottom: 24px;">
            <div>
                <strong>User:</strong> {{ $ticket->user->name }}<br>
                <strong>Category:</strong> {{ $ticket->category }}<br>
                <strong>Created:</strong> {{ $ticket->created_at->format('M d, Y h:i A') }}
            </div>
            <form action="{{ route('admin.support.tickets.update', $ticket->id) }}" method="POST">
                @csrf
                <div style="display: grid; gap: 12px;">
                    <select name="status" style="padding: 8px; border: 1px solid #ddd; border-radius: 6px;">
                        <option value="open" {{ $ticket->status == 'open' ? 'selected' : '' }}>Open</option>
                        <option value="in_progress" {{ $ticket->status == 'in_progress' ? 'selected' : '' }}>In Progress</option>
                        <option value="resolved" {{ $ticket->status == 'resolved' ? 'selected' : '' }}>Resolved</option>
                        <option value="closed" {{ $ticket->status == 'closed' ? 'selected' : '' }}>Closed</option>
                    </select>
                    <select name="priority" style="padding: 8px; border: 1px solid #ddd; border-radius: 6px;">
                        <option value="low" {{ $ticket->priority == 'low' ? 'selected' : '' }}>Low</option>
                        <option value="medium" {{ $ticket->priority == 'medium' ? 'selected' : '' }}>Medium</option>
                        <option value="high" {{ $ticket->priority == 'high' ? 'selected' : '' }}>High</option>
                        <option value="urgent" {{ $ticket->priority == 'urgent' ? 'selected' : '' }}>Urgent</option>
                    </select>
                    <select name="assigned_to" style="padding: 8px; border: 1px solid #ddd; border-radius: 6px;">
                        <option value="">Unassigned</option>
                        @foreach($admins as $admin)
                            <option value="{{ $admin->id }}" {{ $ticket->assigned_to == $admin->id ? 'selected' : '' }}>{{ $admin->name }}</option>
                        @endforeach
                    </select>
                    <button type="submit" style="padding: 8px 16px; background: #7c3aed; color: white; border: none; border-radius: 6px; cursor: pointer;">Update Ticket</button>
                </div>
            </form>
        </div>
        
        <div style="border-top: 1px solid #ddd; padding-top: 20px;">
            <h4>{{ $ticket->subject }}</h4>
            <p style="margin-top: 12px; line-height: 1.6;">{{ $ticket->description }}</p>
            
            @if($ticket->attachments)
                <div style="margin-top: 16px;">
                    <strong>Attachments:</strong><br>
                    @foreach($ticket->attachments as $attachment)
                        <a href="{{ Storage::url($attachment) }}" target="_blank" style="color: #7c3aed; margin-right: 12px;">📎 {{ basename($attachment) }}</a>
                    @endforeach
                </div>
            @endif
        </div>
    </div>
</div>

<div class="card" style="margin-bottom: 24px;">
    <div class="card-header"><h3>Conversation ({{ $ticket->replies->count() }} replies)</h3></div>
    <div style="padding: 24px;">
        @foreach($ticket->replies as $reply)
            <div style="margin-bottom: 20px; padding: 16px; background: {{ $reply->is_admin ? '#f0f9ff' : '#f9fafb' }}; border-radius: 8px; border-left: 4px solid {{ $reply->is_admin ? '#3b82f6' : '#94a3b8' }};">
                <div style="display: flex; justify-content: space-between; margin-bottom: 8px;">
                    <strong>{{ $reply->is_admin ? '🛡️ ' . ($reply->user->name ?? 'Support Admin') : $reply->user->name }}</strong>
                    <span style="color: #666; font-size: 0.875rem;">{{ $reply->created_at->diffForHumans() }}</span>
                </div>
                <p style="margin: 0; line-height: 1.6;">{{ $reply->message }}</p>
                @if($reply->attachments)
                    <div style="margin-top: 12px;">
                        @foreach($reply->attachments as $attachment)
                            <a href="{{ Storage::url($attachment) }}" target="_blank" style="color: #7c3aed; margin-right: 12px; font-size: 0.875rem;">📎 {{ basename($attachment) }}</a>
                        @endforeach
                    </div>
                @endif
            </div>
        @endforeach
    </div>
</div>

<div class="card">
    <div class="card-header"><h3>Reply to Ticket</h3></div>
    <form action="{{ route('admin.support.tickets.reply', $ticket->id) }}" method="POST" enctype="multipart/form-data">
        @csrf
        <div style="padding: 24px;">
            <textarea name="message" rows="5" placeholder="Type your reply..." style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 8px;" required></textarea>
            <div style="margin-top: 16px; display: flex; justify-content: space-between; align-items: center;">
                <input type="file" name="attachments[]" multiple accept="image/*,.pdf" style="font-size: 0.875rem;">
                <button type="submit" style="padding: 12px 24px; background: #7c3aed; color: white; border: none; border-radius: 8px; font-weight: 600; cursor: pointer;">Send Reply</button>
            </div>
        </div>
    </form>
</div>
@endsection
