@extends('admin.layouts.app')

@section('content')
<div class="content-header">
    <h1>Support Tickets</h1>
</div>

<div class="card" style="margin-bottom: 24px;">
    <div style="padding: 16px; display: grid; grid-template-columns: repeat(5, 1fr); gap: 12px;">
        <div style="text-align: center;">
            <div style="font-size: 1.5rem; font-weight: 700; color: #7c3aed;">{{ $stats['total'] }}</div>
            <div style="font-size: 0.875rem; color: #666;">Total</div>
        </div>
        <div style="text-align: center;">
            <div style="font-size: 1.5rem; font-weight: 700; color: #10b981;">{{ $stats['open'] }}</div>
            <div style="font-size: 0.875rem; color: #666;">Open</div>
        </div>
        <div style="text-align: center;">
            <div style="font-size: 1.5rem; font-weight: 700; color: #f59e0b;">{{ $stats['in_progress'] }}</div>
            <div style="font-size: 0.875rem; color: #666;">In Progress</div>
        </div>
        <div style="text-align: center;">
            <div style="font-size: 1.5rem; font-weight: 700; color: #3b82f6;">{{ $stats['resolved'] }}</div>
            <div style="font-size: 0.875rem; color: #666;">Resolved</div>
        </div>
        <div style="text-align: center;">
            <div style="font-size: 1.5rem; font-weight: 700; color: #94a3b8;">{{ $stats['closed'] }}</div>
            <div style="font-size: 0.875rem; color: #666;">Closed</div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
        <h3>All Tickets</h3>
        <div style="display: flex; gap: 12px;">
            <form method="GET" style="display: flex; gap: 12px;">
                <select name="status" onchange="this.form.submit()" style="padding: 8px 12px; border: 1px solid #ddd; border-radius: 6px;">
                    <option value="">All Status</option>
                    <option value="open" {{ request('status') == 'open' ? 'selected' : '' }}>Open</option>
                    <option value="in_progress" {{ request('status') == 'in_progress' ? 'selected' : '' }}>In Progress</option>
                    <option value="resolved" {{ request('status') == 'resolved' ? 'selected' : '' }}>Resolved</option>
                    <option value="closed" {{ request('status') == 'closed' ? 'selected' : '' }}>Closed</option>
                </select>
                <input type="text" name="search" placeholder="Search..." value="{{ request('search') }}" style="padding: 8px 12px; border: 1px solid #ddd; border-radius: 6px;">
                <button type="submit" style="padding: 8px 16px; background: #7c3aed; color: white; border: none; border-radius: 6px; cursor: pointer;">Filter</button>
            </form>
        </div>
    </div>
    
    <table class="table">
        <thead>
            <tr>
                <th>Ticket #</th>
                <th>User</th>
                <th>Subject</th>
                <th>Category</th>
                <th>Status</th>
                <th>Priority</th>
                <th>Created</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @forelse($tickets as $ticket)
            <tr>
                <td style="font-weight: 600;">{{ $ticket->ticket_number }}</td>
                <td>{{ $ticket->user->name }}</td>
                <td>{{ Str::limit($ticket->subject, 40) }}</td>
                <td><span style="padding: 4px 8px; background: #f3f4f6; border-radius: 4px; font-size: 0.75rem;">{{ $ticket->category }}</span></td>
                <td>
                    @if($ticket->status == 'open')
                        <span style="padding: 4px 8px; background: #10b981; color: white; border-radius: 4px; font-size: 0.75rem;">Open</span>
                    @elseif($ticket->status == 'in_progress')
                        <span style="padding: 4px 8px; background: #f59e0b; color: white; border-radius: 4px; font-size: 0.75rem;">In Progress</span>
                    @elseif($ticket->status == 'resolved')
                        <span style="padding: 4px 8px; background: #3b82f6; color: white; border-radius: 4px; font-size: 0.75rem;">Resolved</span>
                    @else
                        <span style="padding: 4px 8px; background: #94a3b8; color: white; border-radius: 4px; font-size: 0.75rem;">Closed</span>
                    @endif
                </td>
                <td>
                    @if($ticket->priority == 'urgent')
                        <span style="color: #ef4444; font-weight: 600;">⚠️ Urgent</span>
                    @elseif($ticket->priority == 'high')
                        <span style="color: #f59e0b; font-weight: 600;">High</span>
                    @else
                        {{ ucfirst($ticket->priority) }}
                    @endif
                </td>
                <td>{{ $ticket->created_at->diffForHumans() }}</td>
                <td>
                    <a href="{{ route('admin.support.tickets.show', $ticket->id) }}" style="padding: 6px 12px; background: #7c3aed; color: white; border-radius: 4px; text-decoration: none; font-size: 0.875rem;">View</a>
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="8" style="text-align: center; padding: 40px; color: #666;">No tickets found</td>
            </tr>
            @endforelse
        </tbody>
    </table>
    
    <div style="padding: 16px;">
        {{ $tickets->links() }}
    </div>
</div>
@endsection
