@extends('admin.layouts.app')

@section('content')
<div class="content-header">
    <h1>Support Settings</h1>
    <p>Configure help & support options for users</p>
</div>

@if(session('success'))
<div style="padding: 16px; background: #10b981; color: white; border-radius: 8px; margin-bottom: 24px;">
    {{ session('success') }}
</div>
@endif

<div class="card">
    <form action="{{ route('admin.support.settings.update') }}" method="POST">
        @csrf
        
        <div class="card-header">
            <h3>Contact Information</h3>
        </div>
        
        <div style="padding: 24px; display: grid; gap: 20px;">
            <div>
                <label style="display: block; margin-bottom: 8px; font-weight: 600;">Support Email</label>
                <input type="email" name="support_email" value="{{ $settings->support_email }}" 
                       style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px;" required>
            </div>
            
            <div>
               <label style="display: block; margin-bottom: 8px; font-weight: 600;">Support Phone</label>
                <input type="text" name="support_phone" value="{{ $settings->support_phone }}" 
                       style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px;" required>
            </div>
        </div>

        <div class="card-header" style="border-top: 1px solid var(--border-color);">
            <h3>Feature Toggles</h3>
            <p style="font-size: 0.875rem; color: var(--text-secondary); margin: 8px 0 0;">Enable or disable support features</p>
        </div>
        
        <div style="padding: 24px; display: grid; gap: 16px;">
            <label style="display: flex; align-items: center; gap: 12px; cursor: pointer;">
                <input type="checkbox" name="ticket_enabled" value="1" {{ $settings->ticket_enabled ? 'checked' : '' }}
                       style="width: 20px; height: 20px; cursor: pointer;">
                <span style="font-weight: 600;">Enable Ticket System</span>
            </label>
            
            <label style="display: flex; align-items: center; gap: 12px; cursor: pointer;">
                <input type="checkbox" name="chat_enabled" value="1" {{ $settings->chat_enabled ? 'checked' : '' }}
                       style="width: 20px; height: 20px; cursor: pointer;">
                <span style="font-weight: 600;">Enable Live Chat</span>
            </label>
            
            <label style="display: flex; align-items: center; gap: 12px; cursor: pointer;">
                <input type="checkbox" name="email_enabled" value="1" {{ $settings->email_enabled ? 'checked' : '' }}
                       style="width: 20px; height: 20px; cursor: pointer;">
                <span style="font-weight: 600;">Enable Email Support</span>
            </label>
            
            <label style="display: flex; align-items: center; gap: 12px; cursor: pointer;">
                <input type="checkbox" name="call_enabled" value="1" {{ $settings->call_enabled ? 'checked' : '' }}
                       style="width: 20px; height: 20px; cursor: pointer;">
                <span style="font-weight: 600;">Enable Call Support</span>
            </label>
        </div>

        <div class="card-header" style="border-top: 1px solid var(--border-color);">
            <h3>Auto-Reply Message</h3>
        </div>
        
        <div style="padding: 24px;">
            <textarea name="auto_reply_message" rows="4"
                      style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px; font-family: inherit;">{{ $settings->auto_reply_message }}</textarea>
            <p style="font-size: 0.875rem; color: var(--text-secondary); margin-top: 8px;">This message will be sent automatically when a user creates a ticket</p>
        </div>

        <div style="padding: 24px; border-top: 1px solid var(--border-color);">
            <button type="submit" style="padding: 12px 24px; background: #7c3aed; color: white; border: none; border-radius: 8px; font-weight: 600; cursor: pointer;">
                Save Settings
            </button>
        </div>
    </form>
</div>
@endsection
