@extends('admin.layouts.app')

@section('content')
<div class="content-header" style="margin-bottom: 24px;">
    <div style="display: flex; align-items: center; justify-content: space-between;">
        <div>
            <h1>Chat with {{ $chat->user->name ?? 'Unknown User' }}</h1>
            <p>{{ $chat->user->email ?? 'N/A' }}</p>
        </div>
        <div style="display: flex; gap: 12px;">
            <a href="{{ route('admin.support.chats') }}" 
               style="padding: 10px 20px; background: var(--border-color); color: var(--text-primary); border-radius: 8px; text-decoration: none; font-weight: 600;">
                ← Back to Chats
            </a>
            @if($chat->status !== 'closed')
            <form action="{{ route('admin.support.chats.close', $chat->id) }}" method="POST" style="margin: 0;">
                @csrf
                <button type="submit" 
                        style="padding: 10px 20px; background: #ef4444; color: white; border: none; border-radius: 8px; cursor: pointer; font-weight: 600;">
                    Close Chat
                </button>
            </form>
            @endif
        </div>
    </div>
</div>

@if(session('success'))
<div style="padding: 16px; background: #10b981; color: white; border-radius: 8px; margin-bottom: 24px;">
    {{ session('success') }}
</div>
@endif

<div class="content-grid">
    <!-- Left Column: Chat Area -->
    <div class="chat-main" style="display: flex; flex-direction: column; gap: 24px;">
        
        <!-- Chat Messages -->
        <div class="card" style="display: flex; flex-direction: column; height: 600px;">
            <div style="padding: 20px; border-bottom: 1px solid var(--border-color); display: flex; justify-content: space-between; align-items: center;">
                <h3 style="margin: 0;">Conversation</h3>
                <span style="font-size: 0.875rem; color: var(--text-secondary);">
                    {{ $chat->created_at->format('M d, Y H:i') }}
                </span>
            </div>
            
            <div id="chat-messages" style="flex: 1; padding: 20px; overflow-y: auto; display: flex; flex-direction: column; gap: 16px; background: var(--bg-color);">
                @forelse($chat->messages as $message)
                <div style="display: flex; {{ $message->is_admin ? 'justify-content: flex-end;' : 'justify-content: flex-start;' }}">
                    <div style="max-width: 80%; {{ $message->is_admin ? 'background: #7c3aed; color: white;' : 'background: var(--card-bg); border: 1px solid var(--border-color); color: var(--text-primary);' }} padding: 12px 16px; border-radius: 12px; box-shadow: 0 1px 2px var(--shadow-color);">
                        <div style="margin-bottom: 6px; line-height: 1.5;">{{ $message->message }}</div>
                        <div style="font-size: 0.75rem; opacity: 0.8; display: flex; align-items: center; gap: 8px; justify-content: {{ $message->is_admin ? 'flex-end' : 'flex-start' }};">
                            <span>{{ $message->created_at->format('H:i') }}</span>
                            @if(!$message->is_admin)
                                <span>• {{ $message->user->name ?? 'User' }}</span>
                            @endif
                        </div>
                    </div>
                </div>
                @empty
                <div style="text-align: center; padding: 40px; color: var(--text-secondary);">
                    <div style="font-size: 48px; margin-bottom: 12px;">💬</div>
                    <p>No messages yet</p>
                </div>
                @endforelse
            </div>

            <!-- Send Message Form -->
            @if($chat->status !== 'closed')
            <div style="padding: 20px; border-top: 1px solid var(--border-color); background: var(--card-bg);">
                <form action="{{ route('admin.support.chats.message', $chat->id) }}" method="POST">
                    @csrf
                    <div style="display: flex; gap: 12px;">
                        <textarea name="message" rows="2" required
                                  placeholder="Type your message here..."
                                  style="flex: 1; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px; font-family: inherit; resize: none;"></textarea>
                        <button type="submit" 
                                style="padding: 0 24px; background: #7c3aed; color: white; border: none; border-radius: 8px; font-weight: 600; cursor: pointer; display: flex; align-items: center; gap: 8px;">
                            <span>Send</span>
                            <span>➤</span>
                        </button>
                    </div>
                    @error('message')
                        <div style="color: #ef4444; font-size: 0.875rem; margin-top: 4px;">{{ $message }}</div>
                    @enderror
                </form>
            </div>
            @else
            <div style="padding: 20px; border-top: 1px solid var(--border-color); background: #f3f4f6; text-align: center; color: var(--text-secondary);">
                🔒 This chat is closed
            </div>
            @endif
        </div>

    </div>

    <!-- Right Column: User Info & Ads -->
    <div class="chat-sidebar" style="display: flex; flex-direction: column; gap: 24px;">
        
        <!-- User Profile Card -->
        <div class="card">
            <div class="card-header">
                <h3 style="margin: 0; font-size: 1rem;">User Details</h3>
                <a href="{{ route('admin.users.details', $chat->user_id) }}" style="font-size: 0.875rem; color: #7c3aed; text-decoration: none;">View Profile →</a>
            </div>
            <div style="padding: 20px; display: flex; flex-direction: column; gap: 16px; align-items: center; border-bottom: 1px solid var(--border-color);">
                <div style="width: 80px; height: 80px; border-radius: 50%; background: #7c3aed; color: white; display: flex; align-items: center; justify-content: center; font-size: 32px; font-weight: 600;">
                    {{ substr($chat->user->name ?? 'U', 0, 1) }}
                </div>
                <div style="text-align: center;">
                    <h4 style="margin: 0 0 4px;">{{ $chat->user->name ?? 'Unknown' }}</h4>
                    <p style="margin: 0; color: var(--text-secondary); font-size: 0.875rem;">{{ $chat->user->email ?? '' }}</p>
                </div>
            </div>
            <div style="padding: 20px;">
                <div style="display: flex; justify-content: space-between; margin-bottom: 12px;">
                    <span style="color: var(--text-secondary);">Status</span>
                    @if($chat->status === 'active')
                        <span class="status-badge status-active">Active</span>
                    @elseif($chat->status === 'pending')
                        <span class="status-badge status-pending">Pending</span>
                    @else
                        <span class="status-badge status-inactive">Closed</span>
                    @endif
                </div>
                <div style="display: flex; justify-content: space-between; margin-bottom: 12px;">
                    <span style="color: var(--text-secondary);">Joined</span>
                    <span style="font-weight: 600;">{{ $chat->user->created_at->format('M Y') }}</span>
                </div>
                <div style="display: flex; justify-content: space-between;">
                    <span style="color: var(--text-secondary);">Last Active</span>
                    <span style="font-weight: 600;">{{ $chat->updated_at->diffForHumans() }}</span>
                </div>
            </div>
        </div>

        <!-- User Ads Card -->
        <div class="card">
            <div class="card-header">
                <h3 style="margin: 0; font-size: 1rem;">Recent Ads</h3>
                <span style="font-size: 0.75rem; background: #f3e8ff; color: #7c3aed; padding: 2px 8px; border-radius: 99px;">{{ count($userAds) }}</span>
            </div>
            @if(count($userAds) > 0)
                <div style="display: flex; flex-direction: column;">
                    @foreach($userAds as $ad)
                    <a href="{{ route('admin.ads.show', $ad->id) }}" style="display: flex; gap: 12px; padding: 16px; border-bottom: 1px solid var(--border-color); text-decoration: none; color: inherit; transition: background 0.2s;">
                        <div style="width: 48px; height: 48px; background: #f3f4f6; border-radius: 8px; flex-shrink: 0; display: flex; align-items: center; justify-content: center; overflow: hidden;">
                            @if($ad->images && count($ad->images) > 0)
                                <img src="{{ Storage::url($ad->images[0]->image_path) }}" style="width: 100%; height: 100%; object-fit: cover;">
                            @else
                                <span style="font-size: 20px;">📷</span>
                            @endif
                        </div>
                        <div style="flex: 1; min-width: 0;">
                            <div style="font-weight: 600; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; margin-bottom: 4px;">
                                {{ $ad->title }}
                            </div>
                            <div style="display: flex; justify-content: space-between; align-items: center; font-size: 0.75rem;">
                                <span style="color: #7c3aed; font-weight: 600;">{{ number_format($ad->price) }}</span>
                                <span style="color: var(--text-secondary);">{{ $ad->created_at->diffForHumans() }}</span>
                            </div>
                        </div>
                    </a>
                    @endforeach
                    <div style="padding: 12px; text-align: center;">
                        <a href="{{ route('admin.ads.index') }}?user_id={{ $chat->user_id }}" style="font-size: 0.875rem; color: #7c3aed; text-decoration: none; font-weight: 600;">
                            View All Ads
                        </a>
                    </div>
                </div>
            @else
                <div style="padding: 30px; text-align: center; color: var(--text-secondary);">
                    <div style="font-size: 24px; margin-bottom: 8px;">📭</div>
                    <p style="margin: 0; font-size: 0.875rem;">No ads posted yet</p>
                </div>
            @endif
        </div>

    </div>
</div>

<script>
// Auto-scroll to bottom of messages
document.addEventListener('DOMContentLoaded', function() {
    const messagesContainer = document.getElementById('chat-messages');
    if (messagesContainer) {
        messagesContainer.scrollTop = messagesContainer.scrollHeight;
    }
});
</script>
@endsection
