@extends('admin.layouts.app')

@section('content')
<div class="content-header" style="margin-bottom: 24px;">
    <h1>Support Chats</h1>
    <p>Manage live chat conversations with users</p>
</div>

<!-- Stats Cards -->
<div class="dashboard-grid" style="margin-bottom: 24px;">
    <div class="card">
        <div class="card-header">
            <span class="card-title">Total Chats</span>
            <div class="stat-icon">💬</div>
        </div>
        <div class="card-value">{{ $stats['total'] }}</div>
    </div>
    
    <div class="card">
        <div class="card-header">
            <span class="card-title">Active</span>
            <div class="stat-icon" style="background: #dcfce7; color: #10b981;">✓</div>
        </div>
        <div class="card-value">{{ $stats['active'] }}</div>
    </div>
    
    <div class="card">
        <div class="card-header">
            <span class="card-title">Pending</span>
            <div class="stat-icon" style="background: #fef3c7; color: #f59e0b;">⏳</div>
        </div>
        <div class="card-value">{{ $stats['pending'] }}</div>
    </div>
    
    <div class="card">
        <div class="card-header">
            <span class="card-title">Closed</span>
            <div class="stat-icon" style="background: #fee2e2; color: #ef4444;">✕</div>
        </div>
        <div class="card-value">{{ $stats['closed'] }}</div>
    </div>
</div>

<!-- Filters -->
<div class="card" style="margin-bottom: 24px;">
    <form method="GET" style="padding: 20px; display: flex; gap: 16px; align-items: end;">
        <div style="flex: 1;">
            <label style="display: block; margin-bottom: 8px; font-weight: 600;">Search</label>
            <input type="text" name="search" value="{{ request('search') }}" 
                   placeholder="Search by user name or email..."
                   style="width: 100%; padding: 10px; border: 1px solid var(--border-color); border-radius: 8px;">
        </div>
        
        <div style="flex: 0 0 200px;">
            <label style="display: block; margin-bottom: 8px; font-weight: 600;">Status</label>
            <select name="status" style="width: 100%; padding: 10px; border: 1px solid var(--border-color); border-radius: 8px;">
                <option value="">All Statuses</option>
                <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
                <option value="closed" {{ request('status') == 'closed' ? 'selected' : '' }}>Closed</option>
            </select>
        </div>
        
        <button type="submit" style="padding: 10px 24px; background: #7c3aed; color: white; border: none; border-radius: 8px; cursor: pointer; font-weight: 600;">
            Filter
        </button>
        <a href="{{ route('admin.support.chats') }}" style="padding: 10px 24px; background: var(--border-color); color: var(--text-primary); border: none; border-radius: 8px; cursor: pointer; font-weight: 600; text-decoration: none; display: inline-block;">
            Reset
        </a>
    </form>
</div>

<!-- Chats Table -->
<div class="card">
    <div style="padding: 20px; border-bottom: 1px solid var(--border-color);">
        <h3 style="margin: 0;">All Chats ({{ $chats->total() }})</h3>
    </div>
    
    @if($chats->count() > 0)
    <div style="overflow-x: auto;">
        <table class="table">
            <thead>
                <tr>
                    <th>User</th>
                    <th>Last Message</th>
                    <th>Status</th>
                    <th>Started</th>
                    <th>Last Active</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach($chats as $chat)
                <tr>
                    <td>
                        <div style="font-weight: 600;">{{ $chat->user->name ?? 'Unknown' }}</div>
                        <div style="font-size: 0.875rem; color: var(--text-secondary);">{{ $chat->user->email ?? 'N/A' }}</div>
                    </td>
                    <td>
                        <div style="max-width: 300px; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;">
                            {{ $chat->latestMessage->message ?? 'No messages yet' }}
                        </div>
                    </td>
                    <td>
                        @if($chat->status === 'active')
                            <span class="status-badge status-active">Active</span>
                        @elseif($chat->status === 'pending')
                            <span class="status-badge status-pending">Pending</span>
                        @else
                            <span class="status-badge status-inactive">Closed</span>
                        @endif
                    </td>
                    <td>{{ $chat->created_at->format('M d, Y') }}</td>
                    <td>{{ $chat->updated_at->diffForHumans() }}</td>
                    <td>
                        <a href="{{ route('admin.support.chats.show', $chat->id) }}" 
                           style="padding: 6px 12px; background: #7c3aed; color: white; border-radius: 6px; text-decoration: none; font-size: 0.875rem;">
                            View Chat
                        </a>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    
    <div style="padding: 20px; border-top: 1px solid var(--border-color);">
        {{ $chats->links() }}
    </div>
    @else
    <div style="padding: 60px 20px; text-align: center; color: var(--text-secondary);">
        <div style="font-size: 48px; margin-bottom: 16px;">💬</div>
        <h3 style="margin: 0 0 8px;">No chats found</h3>
        <p style="margin: 0;">Chat conversations will appear here when users start chatting.</p>
    </div>
    @endif
</div>
@endsection
