@extends('admin.layouts.app')

@section('title', 'Push Notification Settings')

@section('content')
    <div class="card" style="margin-bottom: 24px;">
        <div class="card-header">
            <h3 style="margin: 0; font-size: 1.1rem; color: var(--text-primary);">Push Notification Configuration</h3>
            <div style="font-size: 0.875rem; color: var(--text-secondary);">Configure Firebase Cloud Messaging for push notifications</div>
        </div>
        
        <div style="padding: 20px;">
            @if(session('success'))
                <div style="background: #dcfce7; color: #166534; padding: 12px; border-radius: 8px; margin-bottom: 20px;">
                    {{ session('success') }}
                </div>
            @endif

            <div style="display: grid; grid-template-columns: 2fr 1fr; gap: 24px;">
                <!-- Configuration Form -->
                <div>
                    <form action="{{ route('admin.settings.notifications.update') }}" method="POST">
                        @csrf
                        <div style="margin-bottom: 20px;">
                            <label style="display: block; margin-bottom: 8px; font-weight: 600;">Firebase Server Key (Legacy)</label>
                            <input type="password" name="firebase_server_key" value="{{ $settings['firebase_server_key'] }}" placeholder="Enter FCM Server Key" 
                                   style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px;">
                            <small style="color: var(--text-secondary); display: block; margin-top: 4px;">Found in Firebase Console -> Project Settings -> Cloud Messaging</small>
                        </div>

                        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 16px;">
                            <div style="margin-bottom: 20px;">
                                <label style="display: block; margin-bottom: 8px; font-weight: 600;">Sender ID</label>
                                <input type="text" name="firebase_sender_id" value="{{ $settings['firebase_sender_id'] }}" placeholder="e.g., 548737358373" 
                                       style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px;">
                            </div>
                            <div style="margin-bottom: 20px;">
                                <label style="display: block; margin-bottom: 8px; font-weight: 600;">Project ID</label>
                                <input type="text" name="firebase_project_id" value="{{ $settings['firebase_project_id'] }}" placeholder="e.g., clx-app-8fe93" 
                                       style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px;">
                            </div>
                        </div>

                        <div style="margin-bottom: 20px;">
                            <label style="display: block; margin-bottom: 8px; font-weight: 600;">Firebase API URL</label>
                            <input type="url" name="firebase_api_url" value="{{ $settings['firebase_api_url'] }}" 
                                   style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px;">
                        </div>

                        <div style="margin-top: 24px; display: flex; gap: 12px; justify-content: flex-end;">
                            <button type="submit" style="padding: 12px 24px; background: var(--primary-color); color: white; border: none; border-radius: 8px; font-weight: 600; cursor: pointer;">
                                Save Configuration
                            </button>
                        </div>
                    </form>
                </div>

                <!-- Status and Test -->
                <div>
                    <div style="background: var(--bg-color); padding: 20px; border-radius: 12px; border: 1px solid var(--border-color); margin-bottom: 20px;">
                        <h4 style="margin: 0 0 16px 0; font-size: 1rem;">Configuration Status</h4>
                        <div style="display: flex; align-items: center; justify-content: space-between; margin-bottom: 12px;">
                            <span style="color: var(--text-secondary);">Status</span>
                            <span class="status-badge {{ $configured ? 'status-active' : 'status-inactive' }}">
                                {{ $configured ? 'Configured' : 'Missing Key' }}
                            </span>
                        </div>
                        <div style="font-size: 0.875rem; color: var(--text-secondary); line-height: 1.5;">
                            {{ $status }}
                        </div>
                    </div>

                    <div style="background: var(--bg-color); padding: 20px; border-radius: 12px; border: 1px solid var(--border-color);">
                        <h4 style="margin: 0 0 16px 0; font-size: 1rem;">Service Test</h4>
                        <p style="font-size: 0.875rem; color: var(--text-secondary); margin-bottom: 16px;">
                            Send a test notification to the first available device token in the database.
                        </p>
                        <button id="testPushBtn" style="width: 100%; padding: 12px; background: #3b82f6; color: white; border: none; border-radius: 8px; font-weight: 600; cursor: pointer;">
                            Send Test Notification
                        </button>
                        <div id="testResult" style="margin-top: 12px; font-size: 0.875rem; display: none;"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.getElementById('testPushBtn').addEventListener('click', function() {
            const btn = this;
            const resultDiv = document.getElementById('testResult');
            
            btn.disabled = true;
            btn.textContent = 'Sending...';
            resultDiv.style.display = 'none';

            fetch('{{ route("admin.settings.notifications.test") }}', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Content-Type': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                resultDiv.style.display = 'block';
                resultDiv.textContent = data.message;
                resultDiv.style.color = data.success ? '#166534' : '#991b1b';
                
                if (data.success) {
                    btn.textContent = 'Sent Successfully ✅';
                    btn.style.background = '#10b981';
                } else {
                    btn.textContent = 'Failed ❌';
                    btn.style.background = '#ef4444';
                }
                
                setTimeout(() => {
                    btn.disabled = false;
                    btn.textContent = 'Send Test Notification';
                    btn.style.background = '#3b82f6';
                }, 3000);
            })
            .catch(error => {
                resultDiv.style.display = 'block';
                resultDiv.textContent = 'An error occurred while testing. Check console.';
                resultDiv.style.color = '#991b1b';
                btn.disabled = false;
                btn.textContent = 'Send Test Notification';
            });
        });
    </script>

    <style>
        .status-badge {
            padding: 4px 10px;
            border-radius: 6px;
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
        }
        .status-active { background: #dcfce7; color: #166534; }
        .status-inactive { background: #fee2e2; color: #991b1b; }
    </style>
@endsection
