@extends('admin.layouts.app')

@section('title', 'Platform Settings')

@section('content')
<style>
    /* Premium Settings Layout with Theme Support */
    :root {
        --primary-soft: rgba(124, 58, 237, 0.1); 
    }

    .settings-layout {
        display: grid;
        grid-template-columns: 260px 1fr;
        gap: 32px;
        align-items: start;
        margin-top: 20px;
    }
    
    /* Sidebar Navigation */
    .settings-sidebar {
        background: var(--card-bg);
        border-radius: 16px;
        box-shadow: 0 4px 6px -1px var(--shadow-color);
        overflow: hidden;
        position: sticky;
        top: 24px;
        border: 1px solid var(--border-color);
        transition: background-color 0.3s ease, border-color 0.3s ease;
    }

    .settings-nav-header {
        padding: 20px;
        border-bottom: 1px solid var(--border-color);
        background: var(--bg-color); /* Slightly simplified, or use a variable if available */
        transition: background-color 0.3s ease, border-color 0.3s ease;
    }

    .settings-nav-title {
        font-size: 0.85rem;
        text-transform: uppercase;
        letter-spacing: 0.05em;
        color: var(--text-secondary);
        font-weight: 700;
    }

    .settings-nav-list {
        padding: 12px;
        list-style: none;
        margin: 0;
    }

    .settings-nav-item {
        display: flex;
        align-items: center;
        gap: 12px;
        padding: 12px 16px;
        color: var(--text-secondary);
        text-decoration: none;
        transition: all 0.2s ease;
        border-radius: 8px;
        cursor: pointer;
        font-weight: 500;
        margin-bottom: 4px;
    }

    .settings-nav-item:hover {
        background: var(--bg-color);
        color: var(--text-primary);
    }

    .settings-nav-item.active {
        background: var(--primary-soft);
        color: var(--primary-color);
        font-weight: 600;
    }

    .settings-nav-item i {
        width: 20px;
        text-align: center;
        font-size: 1.1rem;
    }

    /* Content Area */
    .settings-content {
        min-height: 80vh;
    }

    .settings-section {
        display: none;
        animation: fadeIn 0.4s cubic-bezier(0.16, 1, 0.3, 1);
    }

    .settings-section.active {
        display: block;
    }

    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(10px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .section-header {
        margin-bottom: 32px;
    }
    
    .section-title {
        font-size: 1.75rem;
        font-weight: 700;
        color: var(--text-primary);
        margin: 0 0 8px 0;
        letter-spacing: -0.025em;
    }
    
    .section-desc {
        color: var(--text-secondary);
        font-size: 1rem;
    }

    /* Form Cards */
    .form-card {
        background: var(--card-bg);
        border-radius: 16px;
        box-shadow: 0 1px 2px 0 var(--shadow-color);
        padding: 32px;
        margin-bottom: 32px;
        border: 1px solid var(--border-color);
        transition: box-shadow 0.2s, background-color 0.3s ease, border-color 0.3s ease;
    }

    .form-card:hover {
        box-shadow: 0 4px 6px -1px var(--shadow-color);
    }

    .form-card-title {
        font-size: 1.1rem;
        font-weight: 600;
        color: var(--text-primary);
        margin-bottom: 24px;
        padding-bottom: 16px;
        border-bottom: 1px solid var(--border-color);
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .form-group {
        margin-bottom: 24px;
    }

    .form-group:last-child {
        margin-bottom: 0;
    }

    .form-label {
        display: block;
        margin-bottom: 8px;
        font-weight: 500;
        color: var(--text-primary);
        font-size: 0.95rem;
    }

    .form-input, .form-select {
        width: 100%;
        padding: 12px 16px;
        border: 1px solid var(--border-color);
        border-radius: 10px;
        font-size: 1rem;
        transition: all 0.2s;
        background: var(--bg-color);
        color: var(--text-primary);
    }

    .form-input:focus, .form-select:focus {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 4px var(--primary-soft);
        outline: none;
    }
    
    .form-note {
        font-size: 0.85rem;
        color: var(--text-secondary);
        margin-top: 8px;
        display: flex;
        align-items: center;
        gap: 6px;
    }

    /* Toggles */
    .toggle-wrapper {
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 20px;
        background: var(--bg-color);
        border-radius: 12px;
        border: 1px solid var(--border-color);
        margin-bottom: 16px;
        transition: border-color 0.2s, background-color 0.3s ease;
        cursor: pointer;
    }
    
    .toggle-wrapper:hover {
        border-color: var(--text-secondary);
    }

    /* Floating Action Bar */
    .floating-actions {
        position: fixed;
        bottom: 32px;
        right: 32px;
        z-index: 100;
    }

    .btn-save {
        padding: 16px 32px;
        background: linear-gradient(135deg, var(--primary-color), var(--primary-hover));
        color: white;
        border: none;
        border-radius: 50px;
        font-weight: 600;
        font-size: 1.1rem;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        gap: 10px;
        box-shadow: 0 10px 25px -5px rgba(37, 99, 235, 0.4);
        transition: transform 0.2s, box-shadow 0.2s;
    }

    .btn-save:hover {
        transform: translateY(-2px);
        box-shadow: 0 15px 30px -5px rgba(37, 99, 235, 0.5);
    }
    
    .btn-save:active {
        transform: translateY(0);
    }

    /* Quick Stats Badge */
    .service-status {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        padding: 6px 12px;
        border-radius: 20px;
        font-size: 0.85rem;
        font-weight: 600;
    }
    .status-active { background: #dcfce7; color: #166534; }
    .status-inactive { background: #fee2e2; color: #991b1b; }
    .status-pending { background: #fef9c3; color: #854d0e; }
</style>

<div class="settings-layout">
    <!-- Sidebar Navigation -->
    <div class="settings-sidebar">
        <div class="settings-nav-header">
            <div class="settings-nav-title">Configuration</div>
        </div>
        <ul class="settings-nav-list">
            <li class="settings-nav-item active" onclick="switchSection('general')">
                <i class="fas fa-globe"></i> General
            </li>
            <li class="settings-nav-item" onclick="switchSection('auth')">
                <i class="fas fa-key"></i> Authentication
            </li>

            <li class="settings-nav-item" onclick="switchSection('communication')">
                <i class="fas fa-envelope"></i> Communication
            </li>
            <li class="settings-nav-item" onclick="switchSection('security')">
                <i class="fas fa-shield-alt"></i> Security
            </li>
            <li class="settings-nav-item" onclick="switchSection('services')">
                <i class="fas fa-plug"></i> Services
            </li>
        </ul>
        
        <div class="settings-nav-header" style="border-top: 1px solid var(--border-color);">
            <div class="settings-nav-title">System Info</div>
        </div>
        <div style="padding: 20px;">
            <div style="font-size: 0.9rem; color: var(--text-primary); font-weight: 600;">CLX Premium</div>
            <div style="font-size: 0.8rem; color: var(--text-secondary);">v2.4.0 (Build 892)</div>
            <div style="margin-top: 12px; font-size: 0.8rem; color: #10b981; display: flex; align-items: center; gap: 6px;">
                <div style="width: 8px; height: 8px; background: #10b981; border-radius: 50%;"></div>
                System Healthy
            </div>
        </div>
    </div>

    <!-- Main Content Area -->
    <div class="settings-content">
        <form action="{{ route('admin.settings.general.update') }}" method="POST">
            @csrf
            
            <!-- General Section -->
            <div id="section-general" class="settings-section active">
                <div class="section-header">
                    <h2 class="section-title">General Settings</h2>
                    <p class="section-desc">Manage basic platform details, localization, and branding.</p>
                </div>

                <div class="form-card">
                    <div class="form-card-title">
                        <i class="fas fa-info-circle" style="color: var(--primary-color);"></i> Platform Information
                    </div>
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 32px;">
                        <div class="form-group">
                            <label class="form-label">Platform Name</label>
                            <input type="text" class="form-input" name="platform_name" value="{{ \App\Models\Setting::where('key', 'platform_name')->value('value') ?? 'CLX Premium Classifieds' }}">
                            <div class="form-note">Visible in emails and page titles</div>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Contact Email</label>
                            <input type="email" class="form-input" name="contact_email" value="{{ \App\Models\Setting::where('key', 'contact_email')->value('value') ?? 'support@clx.com' }}">
                            <div class="form-note">Used for system notifications</div>
                        </div>
                    </div>
                </div>

                <div class="form-card">
                    <div class="form-card-title">
                        <i class="fas fa-wallet" style="color: #8b5cf6;"></i> Localization
                    </div>
                    <div class="form-group">
                        <label class="form-label">Default Currency</label>
                        <select class="form-select" name="currency" style="max-width: 300px;">
                            <option value="USD" {{ (\App\Models\Setting::where('key', 'currency')->value('value') ?? 'USD') == 'USD' ? 'selected' : '' }}>USD - US Dollar ($)</option>
                            <option value="EUR" {{ (\App\Models\Setting::where('key', 'currency')->value('value') ?? 'USD') == 'EUR' ? 'selected' : '' }}>EUR - Euro (€)</option>
                            <option value="GBP" {{ (\App\Models\Setting::where('key', 'currency')->value('value') ?? 'USD') == 'GBP' ? 'selected' : '' }}>GBP - British Pound (£)</option>
                            <option value="INR" {{ (\App\Models\Setting::where('key', 'currency')->value('value') ?? 'USD') == 'INR' ? 'selected' : '' }}>INR - Indian Rupee (₹)</option>
                        </select>
                    </div>
                </div>
            </div>

            <!-- Authentication Section -->
            <div id="section-auth" class="settings-section">
                <div class="section-header">
                    <h2 class="section-title">Authentication</h2>
                    <p class="section-desc">Control how users log in and register.</p>
                </div>

                <div class="form-card">
                    <div class="form-card-title">
                        <i class="fas fa-lock" style="color: #ef4444;"></i> Login Methods
                    </div>
                    
                    <label class="toggle-wrapper">
                        <div>
                            <div style="font-weight: 600; color: var(--text-primary);">Email & Password Login</div>
                            <div style="font-size: 0.9rem; color: var(--text-secondary);">The standard way for users to log in</div>
                        </div>
                        <label class="switch">
                            <input type="checkbox" name="enable_email_login" value="1" {{ (\App\Models\Setting::where('key', 'enable_email_login')->value('value') ?? '1') == '1' ? 'checked' : '' }}>
                            <span class="slider round"></span>
                        </label>
                    </label>

                    <label class="toggle-wrapper">
                        <div>
                            <div style="font-weight: 600; color: var(--text-primary);">Google Login</div>
                            <div style="font-size: 0.9rem; color: var(--text-secondary);">One-tap social login integration</div>
                        </div>
                        <label class="switch">
                            <input type="checkbox" name="enable_google_login" value="1" {{ (\App\Models\Setting::where('key', 'enable_google_login')->value('value') ?? '0') == '1' ? 'checked' : '' }}>
                            <span class="slider round"></span>
                        </label>
                    </label>
                </div>
            </div>



        <!-- AI Guardian Section -->
        <div id="guardian-settings" class="settings-section">
            <div class="section-header">
                <h2 class="section-title">AI Moderate & Protect</h2>
                <div class="section-desc">Configure the autonomous AI Guardian to manage platform safety.</div>
            </div>

            <!-- Master Switch Card -->
            <div class="form-card" style="border: 2px solid var(--primary-soft);">
                <div style="display: flex; justify-content: space-between; align-items: start;">
                    <div>
                        <div style="font-size: 1.2rem; font-weight: 700; color: var(--text-primary); margin-bottom: 8px; display: flex; align-items: center; gap: 10px;">
                            <span style="font-size: 1.5rem;">🛡️</span> AI Guardian System
                        </div>
                        <div style="color: var(--text-secondary); line-height: 1.5; max-width: 600px;">
                            The Guardian autonomous system monitors ad submissions, chat messages, and user reports. It automatically blocks harmful content and suspends malicious users based on your sensitivity preferences.
                        </div>
                    </div>
                    <label class="switch" style="transform: scale(1.2);">
                        <input type="checkbox" name="guardian_enabled" value="1" {{ (\App\Models\Setting::where('key', 'guardian_enabled')->value('value') ?? '0') == '1' ? 'checked' : '' }}>
                        <span class="slider round"></span>
                    </label>
                </div>
            </div>

            <div class="form-card">
                <div class="form-card-title">
                    <i class="fas fa-brain"></i> Guardian Configuration
                </div>
                
                <div class="form-group">
                    <label class="form-label">Protection Mode</label>
                    <div style="display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 16px;">
                        <label style="cursor: pointer;">
                            <input type="radio" name="guardian_mode" value="STRICT" class="card-input-element" style="display: none;" {{ (\App\Models\Setting::where('key', 'guardian_mode')->value('value') == 'STRICT') ? 'checked' : '' }}>
                            <div class="card-input" style="padding: 16px; border: 2px solid var(--border-color); border-radius: 12px; text-align: center; transition: all 0.2s;">
                                <div style="font-size: 1.5rem; margin-bottom: 8px;">👮‍♂️</div>
                                <div style="font-weight: 700; color: var(--text-primary); margin-bottom: 4px;">Strict</div>
                                <div style="font-size: 0.8rem; color: var(--text-secondary);">Trust Score > 80 required. Zero tolerance for profanity.</div>
                            </div>
                        </label>
                        <label style="cursor: pointer;">
                            <input type="radio" name="guardian_mode" value="BALANCED" class="card-input-element" style="display: none;" {{ (\App\Models\Setting::where('key', 'guardian_mode')->value('value') ?? 'BALANCED') == 'BALANCED' ? 'checked' : '' }}>
                            <div class="card-input" style="padding: 16px; border: 2px solid var(--border-color); border-radius: 12px; text-align: center; transition: all 0.2s;">
                                <div style="font-size: 1.5rem; margin-bottom: 8px;">⚖️</div>
                                <div style="font-weight: 700; color: var(--text-primary); margin-bottom: 4px;">Balanced</div>
                                <div style="font-size: 0.8rem; color: var(--text-secondary);">Trust Score > 50. Suggests fixes for minor issues.</div>
                            </div>
                        </label>
                        <label style="cursor: pointer;">
                            <input type="radio" name="guardian_mode" value="RELAXED" class="card-input-element" style="display: none;" {{ (\App\Models\Setting::where('key', 'guardian_mode')->value('value') == 'RELAXED') ? 'checked' : '' }}>
                            <div class="card-input" style="padding: 16px; border: 2px solid var(--border-color); border-radius: 12px; text-align: center; transition: all 0.2s;">
                                <div style="font-size: 1.5rem; margin-bottom: 8px;">🕊️</div>
                                <div style="font-weight: 700; color: var(--text-primary); margin-bottom: 4px;">Relaxed</div>
                                <div style="font-size: 0.8rem; color: var(--text-secondary);">Minimal intervention. Blocks only severe threats.</div>
                            </div>
                        </label>
                    </div>
                    <style>
                        .card-input-element:checked + .card-input {
                            border-color: var(--primary-color) !important;
                            background: var(--primary-soft);
                            box-shadow: 0 0 0 2px var(--primary-soft);
                        }
                    </style>
                </div>

                <div class="form-group" style="margin-top: 32px;">
                    <div style="display: flex; gap: 32px;">
                        <div style="flex: 1;">
                            <label class="toggle-wrapper" style="height: 100%;">
                                <div>
                                    <div style="font-weight: 600; color: var(--text-primary);">Auto-Ban Offenders</div>
                                    <div style="font-size: 0.9rem; color: var(--text-secondary);">Automatically ban users who post high-risk illegal content</div>
                                </div>
                                <label class="switch">
                                    <input type="checkbox" name="guardian_auto_ban" value="1" {{ (\App\Models\Setting::where('key', 'guardian_auto_ban')->value('value') ?? '0') == '1' ? 'checked' : '' }}>
                                    <span class="slider round"></span>
                                </label>
                            </label>
                        </div>
                        <div style="flex: 1;">
                            <label class="toggle-wrapper" style="height: 100%;">
                                <div>
                                    <div style="font-weight: 600; color: var(--text-primary);">Chat Sentinel</div>
                                    <div style="font-size: 0.9rem; color: var(--text-secondary);">Scan chat messages for scam patterns (e.g. "Wire Transfer")</div>
                                </div>
                                <label class="switch">
                                    <input type="checkbox" name="guardian_chat_monitor" value="1" {{ (\App\Models\Setting::where('key', 'guardian_chat_monitor')->value('value') ?? '1') == '1' ? 'checked' : '' }}>
                                    <span class="slider round"></span>
                                </label>
                            </label>
                        </div>
                    </div>
                </div>

                <!-- Advanced Sensitivity Config -->
                <div style="margin-top: 32px; padding-top: 24px; border-top: 1px solid var(--border-color);">
                    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 16px;">
                        <div class="form-card-title" style="margin: 0; font-size: 1rem;"><i class="fas fa-sliders-h"></i> Advanced Sensitivity</div>
                        <a href="{{ route('admin.guardian.logs') }}" class="btn btn-outline-primary btn-sm" style="text-decoration: none;">
                            <i class="fas fa-history"></i> View Activity Log
                        </a>
                    </div>
                    
                    <div style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 16px;">
                        <div class="form-group">
                            <label class="form-label" style="font-size: 0.85rem;">Strict Mode Threshold</label>
                            <div class="input-group">
                                <input type="number" class="form-input" name="guardian_strict_threshold" value="{{ \App\Models\Setting::where('key', 'guardian_strict_threshold')->value('value') ?? 80 }}">
                                <span style="background: #f1f5f9; padding: 10px; border-radius: 0 8px 8px 0; border: 1px solid #cbd5e1; border-left: 0; color: #64748b;">Trust</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="form-label" style="font-size: 0.85rem;">Balanced Mode Threshold</label>
                             <div class="input-group">
                                <input type="number" class="form-input" name="guardian_balanced_threshold" value="{{ \App\Models\Setting::where('key', 'guardian_balanced_threshold')->value('value') ?? 50 }}">
                                <span style="background: #f1f5f9; padding: 10px; border-radius: 0 8px 8px 0; border: 1px solid #cbd5e1; border-left: 0; color: #64748b;">Trust</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="form-label" style="font-size: 0.85rem;">Relaxed Mode Threshold</label>
                             <div class="input-group">
                                <input type="number" class="form-input" name="guardian_relaxed_threshold" value="{{ \App\Models\Setting::where('key', 'guardian_relaxed_threshold')->value('value') ?? 20 }}">
                                <span style="background: #f1f5f9; padding: 10px; border-radius: 0 8px 8px 0; border: 1px solid #cbd5e1; border-left: 0; color: #64748b;">Trust</span>
                            </div>
                        </div>
                    </div>
                    <div class="form-note" style="margin-top: 8px;">
                        Higher Trust Score = More users must prove themselves. Lower = Any user can post.
                    </div>
                </div>
            </div>
        </div>

            <!-- Communication Section -->
            <div id="section-communication" class="settings-section">
                <div class="section-header">
                    <h2 class="section-title">Communication</h2>
                    <p class="section-desc">Manage system emails and push notifications.</p>
                </div>

                <!-- EMAIL SMTP -->
                <div class="form-card">
                    <div class="form-card-title">
                        <i class="fas fa-server" style="color: #64748b;"></i> Mail Server (SMTP)
                        <span class="service-status status-active" style="margin-left: auto;">Recommended</span>
                    </div>
                    <div style="display: grid; grid-template-columns: 2fr 1fr; gap: 24px;">
                        <div class="form-group">
                            <label class="form-label">Mail Host</label>
                            <input type="text" class="form-input" name="mail_host" value="{{ \App\Models\Setting::where('key', 'mail_host')->value('value') ?? env('MAIL_HOST') }}" placeholder="smtp.example.com">
                        </div>
                        <div class="form-group">
                            <label class="form-label">Port</label>
                            <input type="number" class="form-input" name="mail_port" value="{{ \App\Models\Setting::where('key', 'mail_port')->value('value') ?? env('MAIL_PORT') }}" placeholder="587">
                        </div>
                    </div>
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 24px;">
                        <div class="form-group">
                            <label class="form-label">Username</label>
                            <input type="text" class="form-input" name="mail_username" value="{{ \App\Models\Setting::where('key', 'mail_username')->value('value') ?? env('MAIL_USERNAME') }}">
                        </div>
                        <div class="form-group">
                            <label class="form-label">Password</label>
                            <input type="password" class="form-input" name="mail_password" value="{{ \App\Models\Setting::where('key', 'mail_password')->value('value') ?? env('MAIL_PASSWORD') }}">
                        </div>
                    </div>
                    <div style="display: grid; grid-template-columns: 1fr 2fr; gap: 24px; margin-top: 16px;">
                        <div class="form-group">
                            <label class="form-label">Encryption</label>
                            <select class="form-select" name="mail_encryption">
                                <option value="tls" {{ (\App\Models\Setting::where('key', 'mail_encryption')->value('value') ?? env('MAIL_ENCRYPTION')) == 'tls' ? 'selected' : '' }}>TLS (Standard)</option>
                                <option value="ssl" {{ (\App\Models\Setting::where('key', 'mail_encryption')->value('value') ?? env('MAIL_ENCRYPTION')) == 'ssl' ? 'selected' : '' }}>SSL (Secure)</option>
                                <option value="null" {{ (\App\Models\Setting::where('key', 'mail_encryption')->value('value') ?? env('MAIL_ENCRYPTION')) == 'null' ? 'selected' : '' }}>None</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label class="form-label">From Address</label>
                            <input type="email" class="form-input" name="mail_from_address" value="{{ \App\Models\Setting::where('key', 'mail_from_address')->value('value') ?? env('MAIL_FROM_ADDRESS') }}" placeholder="noreply@yourdomain.com">
                        </div>
                    </div>
                </div>

                <!-- PHONE / FIREBASE -->
                <div class="form-card">
                    <div class="form-card-title">
                        <i class="fas fa-mobile-alt" style="color: #f97316;"></i> SMS & Phone Verification
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">Provider</label>
                        <select class="form-select" name="phone_provider">
                            <option value="firebase" selected>Firebase Auth (Free Tier)</option>
                            <option value="twilio" disabled>Twilio (Enterprise - Coming Soon)</option>
                        </select>
                        <div class="form-note">
                            <i class="fas fa-check-circle" style="color: #10b981;"></i> Firebase is currently active. Client-side verification is enabled.
                        </div>
                    </div>

                    <div style="background: #fff7ed; border: 1px solid #fed7aa; border-radius: 12px; padding: 20px; margin-top: 20px;">
                        <h5 style="margin: 0 0 12px 0; color: #9a3412;">Firebase Configuration</h5>
                        <div style="display: grid; grid-template-columns: 1fr; gap: 16px;">
                            <div class="form-group">
                                <label class="form-label">Server Key (Legacy)</label>
                                <input type="text" class="form-input" name="firebase_server_key" value="{{ \App\Models\Setting::where('key', 'firebase_server_key')->value('value') ?? env('FIREBASE_SERVER_KEY') }}" placeholder="AAAA...">
                            </div>
                            <div class="form-group">
                                <label class="form-label">Sender ID</label>
                                <input type="text" class="form-input" name="firebase_sender_id" value="{{ \App\Models\Setting::where('key', 'firebase_sender_id')->value('value') ?? env('FIREBASE_SENDER_ID') }}" placeholder="123456789">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Security Section -->
            <div id="section-security" class="settings-section">
                <div class="section-header">
                    <h2 class="section-title">Security & Moderation</h2>
                    <p class="section-desc">Protect your platform and manage user trust.</p>
                </div>

                <div class="form-card">
                    <div class="form-card-title">
                        <i class="fas fa-user-check" style="color: #3b82f6;"></i> Verification Requirements
                    </div>
                    
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 24px;">
                        <label class="toggle-wrapper">
                            <div>
                                <div style="font-weight: 600; color: var(--text-primary);">Email Verification</div>
                                <div style="font-size: 0.9rem; color: var(--text-secondary);">Required to post ads</div>
                            </div>
                            <label class="switch">
                                <input type="checkbox" name="email_verification_required" value="1" {{ (\App\Models\Setting::where('key', 'email_verification_required')->value('value') ?? '1') == '1' ? 'checked' : '' }}>
                                <span class="slider round"></span>
                            </label>
                        </label>

                        <label class="toggle-wrapper">
                            <div>
                                <div style="font-weight: 600; color: var(--text-primary);">Phone Verification</div>
                                <div style="font-size: 0.9rem; color: var(--text-secondary);">Required to post ads</div>
                            </div>
                            <label class="switch">
                                <input type="checkbox" name="phone_verification_required" value="1" {{ (\App\Models\Setting::where('key', 'phone_verification_required')->value('value') ?? '1') == '1' ? 'checked' : '' }}>
                                <span class="slider round"></span>
                            </label>
                        </label>
                    </div>
                </div>

                <div class="form-card">
                    <div class="form-card-title">
                        <i class="fas fa-gavel" style="color: #ef4444;"></i> Moderation
                    </div>
                    
                    <label class="toggle-wrapper">
                        <div>
                            <div style="font-weight: 600; color: var(--text-primary);">Auto-Approve Ads</div>
                            <div style="font-size: 0.9rem; color: var(--text-secondary);">Ads go live immediately without review</div>
                        </div>
                        <label class="switch">
                            <input type="checkbox" name="auto_approve_ads" value="1" {{ (\App\Models\Setting::where('key', 'auto_approve_ads')->value('value') ?? '0') == '1' ? 'checked' : '' }}>
                            <span class="slider round"></span>
                        </label>
                    </label>
                    
                    <div class="form-group" style="margin-top: 24px;">
                        <label class="form-label">Max Login Attempts</label>
                        <input type="number" class="form-input" value="5" style="max-width: 150px;">
                        <div class="form-note">Account locks after X failed attempts</div>
                    </div>
                </div>
            </div>

            <!-- Services Section -->
            <div id="section-services" class="settings-section">
                <div class="section-header">
                    <h2 class="section-title">Connected Services</h2>
                    <p class="section-desc">External APIs and Gateway integrations.</p>
                </div>

                <div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 24px;">
                    <!-- Location Service -->
                    <div class="form-card" style="margin: 0; display: flex; flex-direction: column;">
                        <div style="display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 16px;">
                            <div>
                                <h4 style="margin: 0; font-size: 1.1rem;">Location Data</h4>
                                <div style="color: var(--text-dim); font-size: 0.9rem; margin-top: 4px;">OpenStreetMap (Nominatim)</div>
                            </div>
                            <span class="service-status status-active">Active</span>
                        </div>
                        <p style="font-size: 0.95rem; color: var(--text-dim); margin-bottom: 24px; flex-grow: 1; line-height: 1.5;">
                            Currently using the free OpenStreetMap Nominatim API for geocoding and reverse geocoding. No API key required.
                        </p>
                        <div style="display: flex; gap: 12px;">
                            <a href="{{ route('admin.settings.location') }}" style="padding: 10px 20px; background: #eff6ff; color: var(--primary-color); border-radius: 8px; text-decoration: none; font-weight: 600; font-size: 0.9rem; text-align: center; flex: 1;">Configure</a>
                            <button type="button" style="padding: 10px 20px; background: white; border: 1px solid var(--border-light); color: var(--text-dark); border-radius: 8px; font-weight: 600; cursor: pointer;">Test</button>
                        </div>
                    </div>

                    <!-- Payment Gateways -->
                     <div class="form-card" style="margin: 0; display: flex; flex-direction: column;">
                        <div style="display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 16px;">
                            <div>
                                <h4 style="margin: 0; font-size: 1.1rem;">Payment Gateways</h4>
                                <div style="color: var(--text-dim); font-size: 0.9rem; margin-top: 4px;">
                                    {{ \App\Models\PaymentGateway::where('is_active', true)->count() }} Active Providers
                                </div>
                            </div>
                            <div style="font-size: 1.5rem;">💳</div>
                        </div>
                        <p style="font-size: 0.95rem; color: var(--text-dim); margin-bottom: 24px; flex-grow: 1; line-height: 1.5;">
                            Manage Stripe, Razorpay, and other payment providers. Configure API keys and webhooks.
                        </p>
                        <a href="{{ route('admin.payment-gateways.index') }}" style="padding: 10px 20px; background: #eff6ff; color: var(--primary-color); border-radius: 8px; text-decoration: none; font-weight: 600; font-size: 0.9rem; text-align: center;">Manage Gateways</a>
                    </div>
                </div>
            </div>

            <!-- Floating Actions -->
            <div class="floating-actions">
                <button type="submit" class="btn-save">
                    <i class="fas fa-save"></i> Save Changes
                </button>
            </div>
        </form>
    </div>
</div>

<script>
    function switchSection(sectionId) {
        // Update URL hash without scrolling
        if(history.pushState) {
            history.pushState(null, null, '#' + sectionId);
        } else {
            location.hash = '#' + sectionId;
        }

        // Update Nav
        document.querySelectorAll('.settings-nav-item').forEach(item => {
            item.classList.remove('active');
            // Check both onclick attribute and data-target to match the current section
            if (item.getAttribute('onclick')?.includes(`'${sectionId}'`)) {
                item.classList.add('active');
            }
        });

        // Update Content
        document.querySelectorAll('.settings-section').forEach(section => {
            section.classList.remove('active');
        });
        
        // Try to find the section by ID directly or with prefix 'section-'
        const activeSection = document.getElementById(sectionId) || document.getElementById('section-' + sectionId);
        
        if (activeSection) {
            activeSection.classList.add('active');
        } else {
             console.warn("Section not found:", sectionId);
        }

        // Scroll to top
        window.scrollTo({ top: 0, behavior: 'smooth' });
    }

    document.addEventListener('DOMContentLoaded', function() {
        // Check hash on load
        function handleHash() {
            const hash = window.location.hash.replace('#', '');
            if (hash) {
                switchSection(hash);
            }
        }
        
        handleHash();
        window.addEventListener('hashchange', handleHash);
    });
</script>
@endsection
