@extends('admin.layouts.app')

@section('title', 'Safety & Security')

@section('content')
<div class="row">
    <div class="col-12 mb-4">
        <h3>Safety & Security Dashboard</h3>
        <p class="text-muted">Manage platform safety, algorithms, and user reports.</p>
    </div>
</div>

<div class="dashboard-grid">
    <!-- Ad Reports -->
    <a href="{{ route('admin.safety.reports') }}" class="card" style="text-decoration: none;">
        <div class="card-header">
            <div>
                <div class="card-title">Ad Reports</div>
                <div class="card-value">{{ \App\Models\AdReport::where('status', 'pending')->count() }}</div>
            </div>
            <div class="stat-icon">🚩</div>
        </div>
        <div class="card-change">Pending Reports</div>
    </a>

    <!-- Algorithm Settings -->
    <a href="{{ route('admin.safety.algorithm_settings') }}" class="card" style="text-decoration: none;">
        <div class="card-header">
            <div>
                <div class="card-title">Algorithm Settings</div>
                <div class="card-value">⚙️</div>
            </div>
            <div class="stat-icon">🤖</div>
        </div>
        <div class="card-change">Configure Safety Algo</div>
    </a>

    <!-- Trust Management -->
    <a href="{{ route('admin.safety.trust_management') }}" class="card" style="text-decoration: none;">
        <div class="card-header">
            <div>
                <div class="card-title">Trust Management</div>
                <div class="card-value">🛡️</div>
            </div>
            <div class="stat-icon">✅</div>
        </div>
        <div class="card-change">User Trust Scores</div>
    </a>
</div>

<div class="row mt-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h3>System Status</h3>
            </div>
            <div class="card-body">
                <div class="d-flex align-items-center gap-3">
                    <div class="status-badge status-active">System Active</div>
                    <div class="text-muted">Safety algorithm is running normally.</div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
