@extends('admin.layouts.app')

@section('title', 'Admin Profile')

@section('content')
    <div class="dashboard-grid" style="grid-template-columns: 1fr;">
        <div class="card">
            <div class="card-header">
                <h3 style="margin: 0; font-size: 1.25rem; color: var(--text-primary);">Admin Profile</h3>
                <div style="font-size: 0.875rem; color: var(--text-secondary);">Manage your admin account</div>
            </div>
            
            <div style="margin-top: 20px;">
                @if(session('success'))
                    <div style="background: #dcfce7; color: var(--success-color); padding: 12px; border-radius: 8px; margin-bottom: 20px; border: 1px solid #bbf7d0;">
                        {{ session('success') }}
                    </div>
                @endif

                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                    <div>
                        <div style="display: flex; align-items: center; gap: 16px; padding: 20px; background: var(--bg-color); border-radius: 12px; border: 1px solid var(--border-color);">
                            <div style="width: 80px; height: 80px; border-radius: 50%; background: var(--primary-color); display: flex; align-items: center; justify-content: center; color: white; font-size: 24px; font-weight: bold;">
                                {{ substr($user->name, 0, 2) }}
                            </div>
                            <div>
                                <div style="font-size: 1.25rem; font-weight: 700; color: var(--text-primary);">{{ $user->name }}</div>
                                <div style="color: var(--text-secondary); margin-top: 4px;">{{ $user->email }}</div>
                                <div style="color: var(--primary-color); font-weight: 600; margin-top: 4px;">Administrator</div>
                            </div>
                        </div>

                        <div style="margin-top: 20px;">
                            <h4 style="margin: 0 0 12px 0; font-size: 1rem; color: var(--text-primary);">Account Information</h4>
                            <div style="background: var(--bg-color); padding: 16px; border-radius: 8px; border: 1px solid var(--border-color);">
                                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 12px;">
                                    <div>
                                        <div style="font-size: 0.75rem; color: var(--text-secondary); text-transform: uppercase; margin-bottom: 4px;">Full Name</div>
                                        <div style="font-weight: 600; color: var(--text-primary);">{{ $user->name }}</div>
                                    </div>
                                    <div>
                                        <div style="font-size: 0.75rem; color: var(--text-secondary); text-transform: uppercase; margin-bottom: 4px;">Email Address</div>
                                        <div style="font-weight: 600; color: var(--text-primary);">{{ $user->email }}</div>
                                    </div>
                                    <div>
                                        <div style="font-size: 0.75rem; color: var(--text-secondary); text-transform: uppercase; margin-bottom: 4px;">Mobile Number</div>
                                        <div style="font-weight: 600; color: var(--text-primary);">{{ $user->mobile_number ?? 'Not provided' }}</div>
                                    </div>
                                    <div>
                                        <div style="font-size: 0.75rem; color: var(--text-secondary); text-transform: uppercase; margin-bottom: 4px;">Account Type</div>
                                        <div style="font-weight: 600; color: var(--primary-color);">Administrator</div>
                                    </div>
                                    <div>
                                        <div style="font-size: 0.75rem; color: var(--text-secondary); text-transform: uppercase; margin-bottom: 4px;">Account Status</div>
                                        <div style="font-weight: 600; color: var(--success-color);">Active</div>
                                    </div>
                                    <div>
                                        <div style="font-size: 0.75rem; color: var(--text-secondary); text-transform: uppercase; margin-bottom: 4px;">Member Since</div>
                                        <div style="font-weight: 600; color: var(--text-primary);">{{ $user->created_at->format('M d, Y') }}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div>
                        <div style="background: var(--bg-color); padding: 20px; border-radius: 12px; border: 1px solid var(--border-color);">
                            <h4 style="margin: 0 0 16px 0; font-size: 1rem; color: var(--text-primary);">Quick Actions</h4>
                            
                            <div style="display: flex; flex-direction: column; gap: 12px;">
                                <a href="{{ route('admin.profile.edit') }}" style="display: flex; align-items: center; gap: 12px; padding: 12px 16px; background: var(--card-bg); border: 1px solid var(--border-color); border-radius: 8px; text-decoration: none; color: var(--text-primary); transition: all 0.2s ease;">
                                    <span style="font-size: 20px;">✏️</span>
                                    <span style="font-weight: 600;">Edit Profile</span>
                                </a>

                                <div style="height: 1px; background: var(--border-color); margin: 8px 0;"></div>

                                <div style="padding: 12px; background: #fef3c7; border: 1px solid #f59e0b; border-radius: 8px;">
                                    <div style="font-weight: 600; color: #92400e; margin-bottom: 8px;">Change Password</div>
                                    <form action="{{ route('admin.profile.password.update') }}" method="POST" style="display: flex; flex-direction: column; gap: 12px;">
                                        @csrf
                                        @method('PUT')
                                        
                                        <div>
                                            <input type="password" name="current_password" placeholder="Current Password" required style="width: 100%; padding: 8px 12px; border: 1px solid var(--border-color); border-radius: 6px; background: white; color: var(--text-primary);">
                                            @error('current_password')
                                                <div style="color: var(--danger-color); font-size: 0.75rem; margin-top: 4px;">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        
                                        <div>
                                            <input type="password" name="password" placeholder="New Password" required style="width: 100%; padding: 8px 12px; border: 1px solid var(--border-color); border-radius: 6px; background: white; color: var(--text-primary);">
                                            @error('password')
                                                <div style="color: var(--danger-color); font-size: 0.75rem; margin-top: 4px;">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        
                                        <div>
                                            <input type="password" name="password_confirmation" placeholder="Confirm New Password" required style="width: 100%; padding: 8px 12px; border: 1px solid var(--border-color); border-radius: 6px; background: white; color: var(--text-primary);">
                                        </div>
                                        
                                        <button type="submit" style="background: var(--primary-color); color: white; border: none; padding: 10px 16px; border-radius: 6px; font-weight: 600; cursor: pointer; transition: background 0.2s ease;">
                                            Update Password
                                        </button>
                                    </form>
                                </div>

                                <div style="height: 1px; background: var(--border-color); margin: 8px 0;"></div>

                                <div style="padding: 16px; background: #e0f2fe; border: 1px solid #7dd3fc; border-radius: 8px;">
                                    <div style="font-weight: 600; color: #0369a1; margin-bottom: 8px;">Admin Privileges</div>
                                    <div style="font-size: 0.875rem; color: #075985; line-height: 1.5;">
                                        • Full access to all admin features<br>
                                        • User management capabilities<br>
                                        • System configuration access<br>
                                        • Analytics and reporting access
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
