@extends('admin.layouts.app')

@section('title', 'Edit Admin Profile')

@section('content')
    <div class="dashboard-grid" style="grid-template-columns: 1fr;">
        <div class="card">
            <div class="card-header">
                <h3 style="margin: 0; font-size: 1.25rem; color: var(--text-primary);">Edit Profile</h3>
                <div style="font-size: 0.875rem; color: var(--text-secondary);">Update your admin account information</div>
            </div>
            
            <div style="margin-top: 20px;">
                @if(session('success'))
                    <div style="background: #dcfce7; color: var(--success-color); padding: 12px; border-radius: 8px; margin-bottom: 20px; border: 1px solid #bbf7d0;">
                        {{ session('success') }}
                    </div>
                @endif

                <form action="{{ route('admin.profile.update') }}" method="POST" style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                    @csrf
                    @method('PUT')

                    <div>
                        <div style="margin-bottom: 16px;">
                            <label for="name" style="display: block; font-size: 0.875rem; color: var(--text-secondary); margin-bottom: 4px; font-weight: 600;">Full Name</label>
                            <input type="text" id="name" name="name" value="{{ old('name', $user->name) }}" required style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px; background: var(--card-bg); color: var(--text-primary); font-size: 1rem;">
                            @error('name')
                                <div style="color: var(--danger-color); font-size: 0.75rem; margin-top: 4px;">{{ $message }}</div>
                            @enderror
                        </div>

                        <div style="margin-bottom: 16px;">
                            <label for="email" style="display: block; font-size: 0.875rem; color: var(--text-secondary); margin-bottom: 4px; font-weight: 600;">Email Address</label>
                            <input type="email" id="email" name="email" value="{{ old('email', $user->email) }}" required style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px; background: var(--card-bg); color: var(--text-primary); font-size: 1rem;">
                            @error('email')
                                <div style="color: var(--danger-color); font-size: 0.75rem; margin-top: 4px;">{{ $message }}</div>
                            @enderror
                        </div>

                        <div style="margin-bottom: 16px;">
                            <label for="mobile_number" style="display: block; font-size: 0.875rem; color: var(--text-secondary); margin-bottom: 4px; font-weight: 600;">Mobile Number</label>
                            <input type="tel" id="mobile_number" name="mobile_number" value="{{ old('mobile_number', $user->mobile_number) }}" style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px; background: var(--card-bg); color: var(--text-primary); font-size: 1rem;">
                            @error('mobile_number')
                                <div style="color: var(--danger-color); font-size: 0.75rem; margin-top: 4px;">{{ $message }}</div>
                            @enderror
                        </div>

                        <div style="display: flex; gap: 12px; margin-top: 24px;">
                            <button type="submit" style="flex: 1; background: var(--primary-color); color: white; border: none; padding: 12px; border-radius: 8px; font-weight: 600; font-size: 1rem; cursor: pointer; transition: background 0.2s ease;">
                                Update Profile
                            </button>
                            <a href="{{ route('admin.profile.show') }}" style="flex: 1; text-decoration: none; background: var(--bg-color); color: var(--text-primary); border: 1px solid var(--border-color); padding: 12px; border-radius: 8px; font-weight: 600; font-size: 1rem; text-align: center; transition: all 0.2s ease;">
                                Cancel
                            </a>
                        </div>
                    </div>

                    <div>
                        <div style="background: var(--bg-color); padding: 20px; border-radius: 12px; border: 1px solid var(--border-color);">
                            <h4 style="margin: 0 0 16px 0; font-size: 1rem; color: var(--text-primary);">Profile Information</h4>
                            
                            <div style="display: flex; align-items: center; gap: 16px; margin-bottom: 20px; padding: 16px; background: var(--card-bg); border-radius: 8px; border: 1px solid var(--border-color);">
                                <div style="width: 60px; height: 60px; border-radius: 50%; background: var(--primary-color); display: flex; align-items: center; justify-content: center; color: white; font-size: 20px; font-weight: bold;">
                                    {{ substr($user->name, 0, 2) }}
                                </div>
                                <div>
                                    <div style="font-size: 1.1rem; font-weight: 700; color: var(--text-primary);">{{ $user->name }}</div>
                                    <div style="color: var(--text-secondary); margin-top: 2px;">{{ $user->email }}</div>
                                    <div style="color: var(--primary-color); font-weight: 600; margin-top: 2px;">Administrator</div>
                                </div>
                            </div>

                            <div style="margin-bottom: 16px;">
                                <div style="font-size: 0.875rem; color: var(--text-secondary); margin-bottom: 8px;">Account Type</div>
                                <div style="padding: 12px; background: #e0f2fe; border: 1px solid #7dd3fc; border-radius: 8px; color: #0369a1; font-weight: 600;">
                                    Administrator
                                </div>
                            </div>

                            <div style="margin-bottom: 16px;">
                                <div style="font-size: 0.875rem; color: var(--text-secondary); margin-bottom: 8px;">Account Status</div>
                                <div style="padding: 12px; background: #dcfce7; border: 1px solid #bbf7d0; border-radius: 8px; color: #166534; font-weight: 600;">
                                    Active
                                </div>
                            </div>

                            <div style="margin-bottom: 16px;">
                                <div style="font-size: 0.875rem; color: var(--text-secondary); margin-bottom: 8px;">Member Since</div>
                                <div style="padding: 12px; background: var(--card-bg); border: 1px solid var(--border-color); border-radius: 8px; color: var(--text-primary);">
                                    {{ $user->created_at->format('M d, Y') }}
                                </div>
                            </div>

                            <div style="padding: 16px; background: #fef3c7; border: 1px solid #f59e0b; border-radius: 8px;">
                                <div style="font-weight: 600; color: #92400e; margin-bottom: 8px;">Note</div>
                                <div style="font-size: 0.875rem; color: #92400e; line-height: 1.5;">
                                    Changes to your profile will be saved immediately. Make sure to double-check your information before updating.
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
