@extends('admin.layouts.app')

@section('title', 'Create New Plan')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 style="margin: 0; font-size: 1.1rem; color: var(--text-primary);">Create New Plan</h3>
            <div style="font-size: 0.875rem; color: var(--text-secondary);">Set up a new subscription plan for users</div>
        </div>
        
        <div style="padding: 20px;">
            <form action="{{ route('admin.admin.plans.store') }}" method="POST">
                @csrf
                
                <!-- Basic Information -->
                <div style="margin-bottom: 24px;">
                    <h4 style="margin: 0 0 16px 0; font-size: 1rem; color: var(--text-primary); border-bottom: 2px solid var(--border-color); padding-bottom: 8px;">Basic Information</h4>
                    
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 16px;">
                        <div>
                            <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Plan Name</label>
                            <input type="text" name="plan_name" required 
                                   style="width: 100%; padding: 10px 12px; border: 1px solid var(--border-color); border-radius: 6px; font-size: 1rem;"
                                   placeholder="e.g., Premium Plan">
                        </div>
                        <div>
                            <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Price (₹)</label>
                            <input type="number" name="price" step="0.01" required 
                                   style="width: 100%; padding: 10px 12px; border: 1px solid var(--border-color); border-radius: 6px; font-size: 1rem;"
                                   placeholder="0.00">
                        </div>
                    </div>

                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 16px; margin-top: 16px;">
                        <div>
                            <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Duration (Days)</label>
                            <input type="number" name="duration_days" required 
                                   style="width: 100%; padding: 10px 12px; border: 1px solid var(--border-color); border-radius: 6px; font-size: 1rem;"
                                   placeholder="30">
                        </div>
                        <div>
                            <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Validity (Days)</label>
                            <input type="number" name="validity_days" required 
                                   style="width: 100%; padding: 10px 12px; border: 1px solid var(--border-color); border-radius: 6px; font-size: 1rem;"
                                   placeholder="365">
                        </div>
                    </div>
                </div>

                <!-- Features Section -->
                <div style="margin-bottom: 24px; padding: 16px; background: #f8fafc; border-radius: 8px; border: 1px solid var(--border-color);">
                    <h4 style="margin: 0 0 16px 0; font-size: 1rem; color: var(--text-primary);">Features</h4>
                    
                    <div style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 16px;">
                        <div>
                            <label style="display: flex; align-items: center; gap: 12px; cursor: pointer; padding: 12px; background: white; border: 1px solid var(--border-color); border-radius: 6px;">
                                <input type="checkbox" name="ad_free" value="1">
                                <div>
                                    <div style="font-weight: 600; color: var(--text-primary);">Ad Free</div>
                                    <div style="font-size: 0.875rem; color: var(--text-secondary);">Remove ads for users</div>
                                </div>
                            </label>
                        </div>
                        
                        <div>
                            <label style="display: flex; align-items: center; gap: 12px; cursor: pointer; padding: 12px; background: white; border: 1px solid var(--border-color); border-radius: 6px;">
                                <input type="checkbox" name="has_analytics" value="1">
                                <div>
                                    <div style="font-weight: 600; color: var(--text-primary);">Analytics</div>
                                    <div style="font-size: 0.875rem; color: var(--text-secondary);">Access to analytics</div>
                                </div>
                            </label>
                        </div>
                        
                        <div>
                            <label style="display: flex; align-items: center; gap: 12px; cursor: pointer; padding: 12px; background: white; border: 1px solid var(--border-color); border-radius: 6px;">
                                <input type="checkbox" name="verified_badge" value="1">
                                <div>
                                    <div style="font-weight: 600; color: var(--text-primary);">Verified Badge</div>
                                    <div style="font-size: 0.875rem; color: var(--text-secondary);">Display verified badge</div>
                                </div>
                            </label>
                        </div>
                        
                        <div>
                            <label style="display: flex; align-items: center; gap: 12px; cursor: pointer; padding: 12px; background: white; border: 1px solid var(--border-color); border-radius: 6px;">
                                <input type="checkbox" name="vip_badge" value="1">
                                <div>
                                    <div style="font-weight: 600; color: var(--text-primary);">VIP Badge</div>
                                    <div style="font-size: 0.875rem; color: var(--text-secondary);">Display VIP status badge</div>
                                </div>
                            </label>
                        </div>
                    </div>

                    <div style="margin-top: 16px; display: grid; grid-template-columns: repeat(3, 1fr); gap: 16px;">
                        <div>
                            <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Post Limit</label>
                            <input type="number" name="post_limit" 
                                   style="width: 100%; padding: 10px 12px; border: 1px solid var(--border-color); border-radius: 6px; font-size: 1rem;"
                                   placeholder="Unlimited">
                        </div>
                        <div>
                            <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Lead Limit</label>
                            <input type="number" name="lead_limit" 
                                   style="width: 100%; padding: 10px 12px; border: 1px solid var(--border-color); border-radius: 6px; font-size: 1rem;"
                                   placeholder="Unlimited">
                        </div>
                        </div>
                        <div>
                            <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Contact Limit (VIP Bypass)</label>
                            <input type="number" name="contact_limit" 
                                   style="width: 100%; padding: 10px 12px; border: 1px solid var(--border-color); border-radius: 6px; font-size: 1rem;"
                                   placeholder="Unlimited">
                            <div style="font-size: 0.75rem; color: var(--text-secondary); margin-top: 4px;">Outgoing contacts allowed when seller limit is reached.</div>
                        </div>
                    </div>
                    
                    <div style="margin-top: 16px; display: grid; grid-template-columns: 1fr 1fr; gap: 16px;">
                        <div>
                            <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Halo Effect (CSS)</label>
                            <input type="text" name="halo_effect" 
                                   style="width: 100%; padding: 10px 12px; border: 1px solid var(--border-color); border-radius: 6px; font-size: 1rem;"
                                   placeholder="e.g., 0 0 15px rgba(255, 215, 0, 0.5)">
                        </div>
                        <div>
                            <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Ad Border (CSS)</label>
                            <input type="text" name="ad_border" 
                                   style="width: 100%; padding: 10px 12px; border: 1px solid var(--border-color); border-radius: 6px; font-size: 1rem;"
                                   placeholder="e.g., 2px solid #FFD700">
                        </div>
                    </div>
                    </div>
                </div>

                <!-- Advanced Settings -->
                <div style="margin-bottom: 24px;">
                    <h4 style="margin: 0 0 16px 0; font-size: 1rem; color: var(--text-primary); border-bottom: 2px solid var(--border-color); padding-bottom: 8px;">Advanced Settings</h4>
                    
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 16px;">
                        <div>
                            <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Analytics Tier</label>
                            <select name="analytics_tier" 
                                    style="width: 100%; padding: 10px 12px; border: 1px solid var(--border-color); border-radius: 6px; font-size: 1rem;">
                                <option value="basic">Basic</option>
                                <option value="advanced">Advanced</option>
                                <option value="premium">Premium</option>
                            </select>
                        </div>
                        <div>
                            <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Status</label>
                            <select name="status" 
                                    style="width: 100%; padding: 10px 12px; border: 1px solid var(--border-color); border-radius: 6px; font-size: 1rem;">
                                <option value="Active">Active</option>
                                <option value="Inactive">Inactive</option>
                            </select>
                        </div>
                    </div>

                    <div style="margin-top: 16px; display: grid; grid-template-columns: 1fr 1fr; gap: 16px;">
                        <div>
                            <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Badge Style</label>
                            <select name="badge_style" 
                                    style="width: 100%; padding: 10px 12px; border: 1px solid var(--border-color); border-radius: 6px; font-size: 1rem;">
                                <option value="vip_buyer">VIP Buyer (Blue)</option>
                                <option value="vip_pro">VIP Pro (Purple)</option>
                                <option value="gold">Gold</option>
                                <option value="silver">Silver</option>
                                <option value="bronze">Bronze</option>
                                <option value="platinum">Platinum</option>
                            </select>
                        </div>
                        <div>
                            <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">Theme</label>
                            <select name="theme" 
                                    style="width: 100%; padding: 10px 12px; border: 1px solid var(--border-color); border-radius: 6px; font-size: 1rem;">
                                <option value="standard">Standard (Blue)</option>
                                <option value="purple">Purple (VIP Pro)</option>
                                <option value="orange">Orange</option>
                                <option value="gold">Gold</option>
                                <option value="dark">Dark</option>
                            </select>
                        </div>
                    </div>
                </div>

                <!-- Submit Section -->
                <div style="display: flex; gap: 12px; justify-content: flex-end; padding-top: 20px; border-top: 1px solid var(--border-color);">
                    <a href="{{ route('admin.admin.plans.index') }}" 
                       style="padding: 10px 20px; background: #6b7280; color: white; text-decoration: none; border-radius: 6px; font-weight: 600; border: none; cursor: pointer;">
                        Cancel
                    </a>
                    <button type="submit" 
                            style="padding: 10px 20px; background: #10b981; color: white; border: none; border-radius: 6px; font-weight: 600; cursor: pointer;">
                        Create Plan
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection
