@extends('admin.layouts.app')

@section('title', 'Payment Gateways')

@section('content')
<div class="dashboard-grid" style="grid-template-columns: 1fr; gap: 24px;">
    
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 8px;">
        <div>
            <h2 style="margin: 0; font-size: 1.5rem; font-weight: 600; color: var(--text-primary);">Payment Settings</h2>
            <p style="margin: 4px 0 0 0; color: var(--text-secondary); font-size: 14px;">Manage payment gateways and configurations</p>
        </div>
        <a href="{{ route('admin.settings.index') }}" style="padding: 10px 20px; background: var(--bg-color); color: var(--text-secondary); border: 1px solid var(--border-color); border-radius: 8px; cursor: pointer; font-weight: 600; text-decoration: none; display: flex; align-items: center; gap: 8px;">
            <span>⬅️</span> Back to Settings
        </a>
    </div>

    @if(session('success'))
        <div style="padding: 16px; background: #dcfce7; border: 1px solid #86efac; border-radius: 8px; color: #166534; margin-bottom: 16px;">
            ✅ {{ session('success') }}
        </div>
    @endif

    <div class="dashboard-grid" style="grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 20px;">
        @foreach($gateways as $gateway)
            <div class="card" style="display: flex; flex-direction: column; height: 100%;">
                <div class="card-header" style="padding: 20px; border-bottom: 1px solid var(--border-color);">
                    <div style="display: flex; align-items: center; gap: 12px;">
                        <div style="width: 40px; height: 40px; background: #f3f4f6; border-radius: 8px; display: flex; align-items: center; justify-content: center; font-size: 20px;">
                            @if($gateway->slug == 'stripe') 💳 
                            @elseif($gateway->slug == 'razorpay') 🇮🇳 
                            @elseif($gateway->slug == 'paypal') 🅿️ 
                            @elseif($gateway->slug == 'paytm') 🛍️ 
                            @elseif($gateway->slug == 'phonepe') 📱 
                            @else 💰 @endif
                        </div>
                        <div>
                            <h3 style="margin: 0; font-size: 1.1rem; color: var(--text-primary);">{{ $gateway->name }}</h3>
                            <div style="display: flex; align-items: center; gap: 6px; margin-top: 4px;">
                                @if($gateway->is_active)
                                    <span class="status-badge status-active">Active</span>
                                @else
                                    <span class="status-badge status-inactive">Inactive</span>
                                @endif
                                
                                @if($gateway->is_test_mode)
                                    <span style="font-size: 11px; padding: 2px 6px; background: #fef3c7; color: #d97706; border-radius: 4px; font-weight: 600;">TEST MODE</span>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                
                <div style="padding: 20px; flex: 1;">
                    <p style="margin: 0 0 16px 0; color: var(--text-secondary); font-size: 14px; line-height: 1.5;">
                        {{ $gateway->description }}
                    </p>
                    
                    <div style="margin-bottom: 16px;">
                        <div style="font-size: 13px; font-weight: 600; color: var(--text-primary); margin-bottom: 8px;">Supported Currencies</div>
                        <div style="display: flex; flex-wrap: wrap; gap: 6px;">
                            @if($gateway->supported_currencies)
                                @foreach($gateway->supported_currencies as $currency)
                                    <span style="font-size: 11px; padding: 2px 8px; background: var(--bg-color); border: 1px solid var(--border-color); border-radius: 4px; color: var(--text-secondary);">{{ $currency }}</span>
                                @endforeach
                            @endif
                        </div>
                    </div>
                </div>
                
                <div style="padding: 20px; border-top: 1px solid var(--border-color); display: flex; gap: 12px;">
                    <a href="{{ route('admin.payment-gateways.edit', $gateway) }}" style="flex: 1; padding: 10px; background: var(--primary-color); color: white; text-align: center; border-radius: 6px; text-decoration: none; font-weight: 600;">
                        Manage Settings
                    </a>
                    
                    <form action="{{ route('admin.payment-gateways.toggle-status', $gateway) }}" method="POST" style="display: inline;">
                        @csrf
                        <button type="button" onclick="toggleGatewayStatus('{{ $gateway->id }}')" style="padding: 10px; background: var(--bg-color); border: 1px solid var(--border-color); border-radius: 6px; cursor: pointer;" title="Toggle Status">
                            @if($gateway->is_active) 🛑 @else ▶️ @endif
                        </button>
                    </form>
                </div>
            </div>
        @endforeach
    </div>
</div>

<script>
function toggleGatewayStatus(id) {
    if(confirm('Are you sure you want to change the status of this gateway?')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = `/admin/payment-gateways/${id}/toggle-status`;
        
        const csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = '_token';
        csrfToken.value = '{{ csrf_token() }}';
        form.appendChild(csrfToken);
        
        document.body.appendChild(form);
        
        // Use fetch instead of submitting form to handle JSON response if needed, 
        // but for now simple refresh is fine
        fetch(form.action, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Content-Type': 'application/json',
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if(data.success) {
                window.location.reload();
            } else {
                alert('Error: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred');
        });
    }
}
</script>
@endsection
