@extends('admin.layouts.app')

@section('title', 'Edit ' . $paymentGateway->name)

@section('content')
<div style="max-width: 800px; margin: 0 auto;">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 24px;">
        <div>
            <h2 style="margin: 0 0 4px 0; font-size: 1.5rem; font-weight: 600; color: var(--text-primary);">Edit {{ $paymentGateway->name }}</h2>
            <p style="margin: 0; color: var(--text-secondary); font-size: 14px;">Configure API keys and settings</p>
        </div>
        <a href="{{ route('admin.payment-gateways.index') }}" style="padding: 10px 20px; background: var(--bg-color); color: var(--text-secondary); border: 1px solid var(--border-color); border-radius: 8px; cursor: pointer; font-weight: 600; text-decoration: none; display: flex; align-items: center; gap: 8px;">
            <span>❌</span> Cancel
        </a>
    </div>

    @if(session('error'))
        <div style="padding: 16px; background: #fee2e2; border: 1px solid #fca5a5; border-radius: 8px; color: #b91c1c; margin-bottom: 24px;">
            ⚠️ {{ session('error') }}
        </div>
    @endif

    <form action="{{ route('admin.payment-gateways.update', $paymentGateway) }}" method="POST">
        @csrf
        @method('PUT')
        
        <div class="card" style="margin-bottom: 24px;">
            <div class="card-header">
                <h3 style="margin: 0; font-size: 1.1rem; color: var(--text-primary);">Credentials</h3>
            </div>
            
            <div style="padding: 24px;">
                <input type="hidden" name="name" value="{{ $paymentGateway->name }}">
                <input type="hidden" name="slug" value="{{ $paymentGateway->slug }}">
                
                <div style="margin-bottom: 20px;">
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; color: var(--text-primary);">API Key / Public Key / Merchant ID</label>
                    <input type="text" name="api_key" value="{{ old('api_key', $paymentGateway->api_key) }}" style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px; font-size: 15px; font-family: monospace;" placeholder="Enter public key or ID">
                </div>
                
                <div style="margin-bottom: 20px;">
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; color: var(--text-primary);">API Secret / Private Key</label>
                    <input type="password" name="api_secret" value="{{ old('api_secret', $paymentGateway->api_secret) }}" style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px; font-size: 15px; font-family: monospace;" placeholder="Enter secret key">
                    <small style="color: var(--text-secondary); margin-top: 4px; display: block;">Kept secure and encrypted</small>
                </div>
                
                <div style="margin-bottom: 0;">
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; color: var(--text-primary);">Webhook Secret (Optional)</label>
                    <input type="password" name="webhook_secret" value="{{ old('webhook_secret', $paymentGateway->webhook_secret) }}" style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px; font-size: 15px; font-family: monospace;" placeholder="Enter webhook signing secret">
                </div>
            </div>
        </div>
        
        <div class="card" style="margin-bottom: 24px;">
            <div class="card-header">
                <h3 style="margin: 0; font-size: 1.1rem; color: var(--text-primary);">Configuration</h3>
            </div>
            
            <div style="padding: 24px;">
                <label style="display: flex; align-items: center; justify-content: space-between; cursor: pointer; padding: 16px; background: var(--bg-color); border-radius: 8px; margin-bottom: 16px;">
                    <div>
                        <span style="display: block; font-weight: 600; font-size: 16px; color: var(--text-primary);">Enable {{ $paymentGateway->name }}</span>
                        <span style="display: block; font-size: 14px; color: var(--text-secondary); margin-top: 2px;">Allow users to pay using this gateway</span>
                    </div>
                    <div style="position: relative; width: 44px; height: 24px;">
                        <input type="checkbox" name="is_active" value="1" {{ old('is_active', $paymentGateway->is_active) ? 'checked' : '' }} style="opacity: 0; width: 0; height: 0;">
                        <span class="slider" style="position: absolute; cursor: pointer; top: 0; left: 0; right: 0; bottom: 0; background-color: #ccc; transition: .4s; border-radius: 34px;"></span>
                        <style>
                            input:checked + .slider { background-color: var(--success-color); }
                            .slider:before { position: absolute; content: ""; height: 16px; width: 16px; left: 4px; bottom: 4px; background-color: white; transition: .4s; border-radius: 50%; }
                            input:checked + .slider:before { transform: translateX(20px); }
                        </style>
                    </div>
                </label>
                
                <label style="display: flex; align-items: center; justify-content: space-between; cursor: pointer; padding: 16px; background: #fffbeb; border: 1px solid #fcd34d; border-radius: 8px; margin-bottom: 16px;">
                    <div>
                        <span style="display: block; font-weight: 600; font-size: 16px; color: #92400e;">Test Mode (Sandbox)</span>
                        <span style="display: block; font-size: 14px; color: #b45309; margin-top: 2px;">Process transactions without real money</span>
                    </div>
                    <div style="position: relative; width: 44px; height: 24px;">
                        <input type="checkbox" name="is_test_mode" value="1" {{ old('is_test_mode', $paymentGateway->is_test_mode) ? 'checked' : '' }} style="opacity: 0; width: 0; height: 0;">
                        <span class="slider-test" style="position: absolute; cursor: pointer; top: 0; left: 0; right: 0; bottom: 0; background-color: #ccc; transition: .4s; border-radius: 34px;"></span>
                        <style>
                            input:checked + .slider-test { background-color: #f59e0b; }
                            .slider-test:before { position: absolute; content: ""; height: 16px; width: 16px; left: 4px; bottom: 4px; background-color: white; transition: .4s; border-radius: 50%; }
                            input:checked + .slider-test:before { transform: translateX(20px); }
                        </style>
                    </div>
                </label>
                
                <div style="margin-bottom: 16px;">
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; color: var(--text-primary);">Description</label>
                    <textarea name="description" rows="3" style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px;">{{ old('description', $paymentGateway->description) }}</textarea>
                </div>
                
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 16px;">
                    <div>
                        <label style="display: block; margin-bottom: 8px; font-weight: 600; color: var(--text-primary);">Transaction Fee %</label>
                        <input type="number" step="0.01" name="transaction_fee_percent" value="{{ old('transaction_fee_percent', $paymentGateway->transaction_fee_percent) }}" style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px;">
                    </div>
                    <div>
                        <label style="display: block; margin-bottom: 8px; font-weight: 600; color: var(--text-primary);">Fixed Fee</label>
                        <input type="number" step="0.01" name="transaction_fee_fixed" value="{{ old('transaction_fee_fixed', $paymentGateway->transaction_fee_fixed) }}" style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px;">
                    </div>
                </div>
            </div>
        </div>
        
        <div style="display: flex; gap: 12px;">
            <button type="submit" style="flex: 1; padding: 14px; background: var(--success-color); color: white; border: none; border-radius: 8px; font-weight: 600; cursor: pointer; font-size: 16px;">
                💾 Save Changes
            </button>
        </div>
    </form>
</div>
@endsection
