@extends('admin.layouts.app')

@section('title', 'Edit Page')

@section('content')
<div class="dashboard-grid" style="grid-template-columns: 1fr; gap: 24px; max-width: 900px;">
    
    <!-- Header -->
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 16px;">
        <div>
            <h2 style="margin: 0; font-size: 1.5rem; font-weight: 600; color: var(--text-primary);">Edit Page</h2>
            <p style="margin: 4px 0 0 0; color: var(--text-secondary); font-size: 14px;">{{ $page->title }}</p>
        </div>
        <a href="{{ route('admin.pages.index') }}" style="padding: 10px 20px; background: var(--border-color); color: var(--text-primary); border: none; border-radius: 8px; cursor: pointer; font-weight: 600; text-decoration: none;">
            ← Back to Pages
        </a>
    </div>

    <!-- Form Card -->
    <div class="card">
        <form action="{{ route('admin.pages.update', $page) }}" method="POST">
            @csrf
            @method('PUT')
            
            <div style="display: grid; gap: 20px;">
                <!-- Title -->
                <div>
                    <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">
                        Page Title <span style="color: var(--danger-color);">*</span>
                    </label>
                    <input type="text" name="title" value="{{ old('title', $page->title) }}" required
                           placeholder="e.g., About Us, Privacy Policy"
                           style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px; background: var(--bg-color); color: var(--text-primary); font-size: 14px;">
                    @error('title')
                        <p style="color: var(--danger-color); font-size: 13px; margin: 4px 0 0 0;">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Slug -->
                <div>
                    <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">
                        Slug (URL) <span style="color: var(--danger-color);">*</span>
                    </label>
                    <input type="text" name="slug" value="{{ old('slug', $page->slug) }}" required
                           placeholder="e.g., about-us"
                           style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px; background: var(--bg-color); color: var(--text-primary); font-size: 14px;">
                    <p style="color: var(--text-secondary); font-size: 12px; margin: 4px 0 0 0;">
                        Used in app URL. Must be unique.
                    </p>
                    @error('slug')
                        <p style="color: var(--danger-color); font-size: 13px; margin: 4px 0 0 0;">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Content -->
                <div>
                    <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">
                        Content
                    </label>
                    <textarea name="content" rows="15"
                              style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px; background: var(--bg-color); color: var(--text-primary); font-size: 14px; font-family: monospace;">{{ old('content', $page->content) }}</textarea>
                    <p style="color: var(--text-secondary); font-size: 12px; margin: 4px 0 0 0;">
                        Supports HTML. You can add headings, paragraphs, lists, etc.
                    </p>
                    @error('content')
                        <p style="color: var(--danger-color); font-size: 13px; margin: 4px 0 0 0;">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Options Row -->
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                    <!-- Order -->
                    <div>
                        <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">
                            Display Order
                        </label>
                        <input type="number" name="order" value="{{ old('order', $page->order) }}" min="0"
                               style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px; background: var(--bg-color); color: var(--text-primary); font-size: 14px;">
                        <p style="color: var(--text-secondary); font-size: 12px; margin: 4px 0 0 0;">
                            Lower numbers appear first
                        </p>
                    </div>

                    <!-- Active Status -->
                    <div>
                        <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">
                            Status
                        </label>
                        <label style="display: flex; align-items: center; gap: 12px; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px; background: var(--bg-color); cursor: pointer;">
                            <input type="checkbox" name="is_active" value="1" {{ old('is_active', $page->is_active) ? 'checked' : '' }}
                                   style="width: 20px; height: 20px; cursor: pointer;">
                            <span style="color: var(--text-primary); font-size: 14px; font-weight: 500;">Active (visible in app)</span>
                        </label>
                    </div>
                </div>

                <!-- Submit Buttons -->
                <div style="display: flex; gap: 12px; justify-content: flex-end; padding-top: 20px; border-top: 1px solid var(--border-color);">
                    <a href="{{ route('admin.pages.index') }}" style="padding: 12px 24px; background: var(--border-color); color: var(--text-primary); border: none; border-radius: 8px; cursor: pointer; font-weight: 600; text-decoration: none;">
                        Cancel
                    </a>
                    <button type="submit" style="padding: 12px 24px; background: var(--primary-color); color: white; border: none; border-radius: 8px; cursor: pointer; font-weight: 600;">
                        Update Page
                    </button>
                </div>
            </div>
        </form>
    </div>

    <!-- Page Info -->
    <div class="card" style="background: #ede9fe; border: 1px solid #c4b5fd;">
        <h4 style="margin: 0 0 12px 0; color: #5b21b6; display: flex; align-items: center; gap: 8px;">
            <span>ℹ️</span> Page Information
        </h4>
        <div style="color: #4c1d95; font-size: 13px; line-height: 1.6;">
            <p style="margin: 0 0 8px 0;"><strong>Created:</strong> {{ $page->created_at->format('M d, Y \a\t h:i A') }}</p>
            <p style="margin: 0 0 8px 0;"><strong>Last Updated:</strong> {{ $page->updated_at->format('M d, Y \a\t h:i A') }}</p>
            <p style="margin: 0;"><strong>API Endpoint:</strong> <code style="background: white; padding: 2px 6px; border-radius: 3px;">/api/pages/{{ $page->slug }}</code></p>
        </div>
    </div>
</div>
@endsection
