@extends('admin.layouts.app')

@section('title', 'Create New Page')

@section('content')
<div class="dashboard-grid" style="grid-template-columns: 1fr; gap: 24px; max-width: 900px;">
    
    <!-- Header -->
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 16px;">
        <div>
            <h2 style="margin: 0; font-size: 1.5rem; font-weight: 600; color: var(--text-primary);">Create New Page</h2>
            <p style="margin: 4px 0 0 0; color: var(--text-secondary); font-size: 14px;">Add a new static page to your app</p>
        </div>
        <a href="{{ route('admin.pages.index') }}" style="padding: 10px 20px; background: var(--border-color); color: var(--text-primary); border: none; border-radius: 8px; cursor: pointer; font-weight: 600; text-decoration: none;">
            ← Back to Pages
        </a>
    </div>

    <!-- Form Card -->
    <div class="card">
        <form action="{{ route('admin.pages.store') }}" method="POST">
            @csrf
            
            <div style="display: grid; gap: 20px;">
                <!-- Title -->
                <div>
                    <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">
                        Page Title <span style="color: var(--danger-color);">*</span>
                    </label>
                    <input type="text" name="title" value="{{ old('title') }}" required
                           placeholder="e.g., About Us, Privacy Policy"
                           style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px; background: var(--bg-color); color: var(--text-primary); font-size: 14px;">
                    @error('title')
                        <p style="color: var(--danger-color); font-size: 13px; margin: 4px 0 0 0;">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Slug -->
                <div>
                    <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">
                        Slug (URL)
                    </label>
                    <input type="text" name="slug" value="{{ old('slug') }}"
                           placeholder="Auto-generated from title (e.g., about-us)"
                           style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px; background: var(--bg-color); color: var(--text-primary); font-size: 14px;">
                    <p style="color: var(--text-secondary); font-size: 12px; margin: 4px 0 0 0;">
                        Leave empty to auto-generate from title. Used in app URL.
                    </p>
                    @error('slug')
                        <p style="color: var(--danger-color); font-size: 13px; margin: 4px 0 0 0;">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Content -->
                <div>
                    <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">
                        Content
                    </label>
                    <textarea name="content" rows="15"
                              style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px; background: var(--bg-color); color: var(--text-primary); font-size: 14px; font-family: monospace;">{{ old('content') }}</textarea>
                    <p style="color: var(--text-secondary); font-size: 12px; margin: 4px 0 0 0;">
                        Supports HTML. You can add headings, paragraphs, lists, etc.
                    </p>
                    @error('content')
                        <p style="color: var(--danger-color); font-size: 13px; margin: 4px 0 0 0;">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Options Row -->
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                    <!-- Order -->
                    <div>
                        <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">
                            Display Order
                        </label>
                        <input type="number" name="order" value="{{ old('order', 0) }}" min="0"
                               style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px; background: var(--bg-color); color: var(--text-primary); font-size: 14px;">
                        <p style="color: var(--text-secondary); font-size: 12px; margin: 4px 0 0 0;">
                            Lower numbers appear first
                        </p>
                    </div>

                    <!-- Active Status -->
                    <div>
                        <label style="display: block; font-weight: 600; margin-bottom: 8px; color: var(--text-primary);">
                            Status
                        </label>
                        <label style="display: flex; align-items: center; gap: 12px; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px; background: var(--bg-color); cursor: pointer;">
                            <input type="checkbox" name="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }}
                                   style="width: 20px; height: 20px; cursor: pointer;">
                            <span style="color: var(--text-primary); font-size: 14px; font-weight: 500;">Active (visible in app)</span>
                        </label>
                    </div>
                </div>

                <!-- Submit Buttons -->
                <div style="display: flex; gap: 12px; justify-content: flex-end; padding-top: 20px; border-top: 1px solid var(--border-color);">
                    <a href="{{ route('admin.pages.index') }}" style="padding: 12px 24px; background: var(--border-color); color: var(--text-primary); border: none; border-radius: 8px; cursor: pointer; font-weight: 600; text-decoration: none;">
                        Cancel
                    </a>
                    <button type="submit" style="padding: 12px 24px; background: var(--success-color); color: white; border: none; border-radius: 8px; cursor: pointer; font-weight: 600;">
                        Create Page
                    </button>
                </div>
            </div>
        </form>
    </div>

    <!-- HTML Tips Card -->
    <div class="card" style="background: #fef3c7; border: 1px solid #fbbf24;">
        <h4 style="margin: 0 0 12px 0; color: #92400e; display: flex; align-items: center; gap: 8px;">
            <span>📝</span> HTML Formatting Tips
        </h4>
        <div style="color: #78350f; font-size: 13px; line-height: 1.6;">
            <code style="display: block; background: white; padding: 8px; border-radius: 4px; margin-bottom: 8px;">&lt;h1&gt;Main Heading&lt;/h1&gt;</code>
            <code style="display: block; background: white; padding: 8px; border-radius: 4px; margin-bottom: 8px;">&lt;p&gt;Paragraph text&lt;/p&gt;</code>
            <code style="display: block; background: white; padding: 8px; border-radius: 4px; margin-bottom: 8px;">&lt;ul&gt;&lt;li&gt;Bullet point&lt;/li&gt;&lt;/ul&gt;</code>
            <code style="display: block; background: white; padding: 8px; border-radius: 4px;">&lt;a href="url"&gt;Link text&lt;/a&gt;</code>
        </div>
    </div>
</div>
@endsection
