@extends('admin.layouts.app')

@section('title', 'Edit Package')

@section('content')
<div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
    
    <!-- Package Details Section -->
    <div class="md:grid md:grid-cols-3 md:gap-6">
        <div class="md:col-span-1">
            <div class="px-4 sm:px-0">
                <h3 class="text-lg font-medium leading-6 text-gray-900">Package Settings</h3>
                <p class="mt-1 text-sm text-gray-600">
                    Update package information and features.
                </p>
                <div class="mt-4">
                    <a href="{{ route('admin.packages.index') }}" class="text-sm text-indigo-600 hover:text-indigo-500">
                        &larr; Back to Packages
                    </a>
                </div>
            </div>
        </div>
        <div class="mt-5 md:mt-0 md:col-span-2">
            <form action="{{ route('admin.packages.update', $package->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="shadow sm:rounded-md sm:overflow-hidden">
                    <div class="px-4 py-5 bg-white space-y-6 sm:p-6">
                        
                        <div class="grid grid-cols-6 gap-6">
                            <div class="col-span-6">
                                <label class="block text-sm font-medium text-gray-700">Package Icon</label>
                                <div class="mt-1 flex items-center">
                                    @if($package->icon)
                                        <span class="inline-block h-12 w-12 rounded-full overflow-hidden bg-gray-100 mr-3">
                                            <img class="h-full w-full object-cover" src="{{ asset('storage/' . $package->icon) }}" alt="">
                                        </span>
                                    @endif
                                    <input type="file" name="icon" class="focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border-gray-300 border p-2 rounded-md">
                                </div>
                            </div>

                            <div class="col-span-6 sm:col-span-3">
                                <label for="name" class="block text-sm font-medium text-gray-700">Package Name</label>
                                <input type="text" name="name" id="name" value="{{ $package->name }}" required class="mt-1 focus:ring-indigo-500 focus:border-indigo-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md py-2 px-3 border">
                            </div>

                            <div class="col-span-6 sm:col-span-3">
                                <label for="slug" class="block text-sm font-medium text-gray-700">Slug</label>
                                <input type="text" name="slug" id="slug" value="{{ $package->slug }}" required class="mt-1 focus:ring-indigo-500 focus:border-indigo-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md py-2 px-3 border">
                            </div>

                            <div class="col-span-6 sm:col-span-3">
                                <label for="type" class="block text-sm font-medium text-gray-700">Type</label>
                                <select id="type" name="type" required class="mt-1 block w-full py-2 px-3 border border-gray-300 bg-white rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                                    <option value="multiple_ads" {{ $package->type == 'multiple_ads' ? 'selected' : '' }}>Multiple Ads Bundle</option>
                                    <option value="featured" {{ $package->type == 'featured' ? 'selected' : '' }}>Featured Ad</option>
                                    <option value="boost" {{ $package->type == 'boost' ? 'selected' : '' }}>Boost Ad</option>
                                    <option value="combo" {{ $package->type == 'combo' ? 'selected' : '' }}>Combo (Featured + Boost)</option>
                                </select>
                            </div>

                            <div class="col-span-6 sm:col-span-3">
                                <label for="sort_order" class="block text-sm font-medium text-gray-700">Sort Order</label>
                                <input type="number" name="sort_order" id="sort_order" value="{{ $package->sort_order }}" class="mt-1 focus:ring-indigo-500 focus:border-indigo-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md py-2 px-3 border">
                            </div>

                            <div class="col-span-6">
                                <label for="description" class="block text-sm font-medium text-gray-700">Description</label>
                                <div class="mt-1">
                                    <textarea id="description" name="description" rows="3" class="shadow-sm focus:ring-indigo-500 focus:border-indigo-500 mt-1 block w-full sm:text-sm border border-gray-300 rounded-md p-2">{{ $package->description }}</textarea>
                                </div>
                            </div>

                            <div class="col-span-6">
                                <fieldset>
                                    <div class="flex items-start">
                                        <div class="flex items-center h-5">
                                            <input id="isActive" name="is_active" type="checkbox" {{ $package->is_active ? 'checked' : '' }} class="focus:ring-indigo-500 h-4 w-4 text-indigo-600 border-gray-300 rounded">
                                        </div>
                                        <div class="ml-3 text-sm">
                                            <label for="isActive" class="font-medium text-gray-700">Active</label>
                                            <p class="text-gray-500">Available for purchase.</p>
                                        </div>
                                    </div>
                                </fieldset>
                            </div>
                        </div>

                        <div class="relative">
                            <div class="absolute inset-0 flex items-center" aria-hidden="true">
                                <div class="w-full border-t border-gray-300"></div>
                            </div>
                            <div class="relative flex justify-center">
                                <span class="px-2 bg-white text-sm text-gray-500">
                                    Features Configuration
                                </span>
                            </div>
                        </div>

                        <div class="grid grid-cols-6 gap-6 bg-gray-50 p-4 rounded-md border border-gray-100">
                            <div class="col-span-6 sm:col-span-2">
                                <label class="block text-sm font-medium text-gray-700">Post Limit</label>
                                <input type="number" name="features[post_limit]" value="{{ $package->features['post_limit'] ?? '' }}" class="mt-1 focus:ring-indigo-500 focus:border-indigo-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md py-2 px-3 border">
                            </div>
                            <div class="col-span-6 sm:col-span-2">
                                <label class="block text-sm font-medium text-gray-700">Featured Duration (Days)</label>
                                <input type="number" name="features[featured_duration_days]" value="{{ $package->features['featured_duration_days'] ?? '' }}" class="mt-1 focus:ring-indigo-500 focus:border-indigo-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md py-2 px-3 border">
                            </div>
                            <div class="col-span-6 sm:col-span-2">
                                <label class="block text-sm font-medium text-gray-700">Boost Count</label>
                                <input type="number" name="features[boost_count]" value="{{ $package->features['boost_count'] ?? '' }}" class="mt-1 focus:ring-indigo-500 focus:border-indigo-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md py-2 px-3 border">
                            </div>
                        </div>

                    </div>
                    <div class="px-4 py-3 bg-gray-50 text-right sm:px-6">
                        <button type="submit" class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                            Save Changes
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="hidden sm:block" aria-hidden="true">
        <div class="py-5">
            <div class="border-t border-gray-200"></div>
        </div>
    </div>

    <!-- Pricing Options Section -->
    <div class="md:grid md:grid-cols-3 md:gap-6">
        <div class="md:col-span-1">
            <div class="px-4 sm:px-0">
                <h3 class="text-lg font-medium leading-6 text-gray-900">Pricing Options</h3>
                <p class="mt-1 text-sm text-gray-600">
                    Manage price points, validity periods, and discounts.
                </p>
            </div>
        </div>
        <div class="mt-5 md:mt-0 md:col-span-2">
            <div class="shadow sm:rounded-md sm:overflow-hidden bg-white">
                <div class="px-4 py-5 space-y-6 sm:p-6">
                    
                    @if($package->pricingTiers->count() > 0)
                    <div class="overflow-x-auto border border-gray-200 rounded-md">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Validity</th>
                                    <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Ad Limit</th>
                                    <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Base Price</th>
                                    <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Discount</th>
                                    <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Final Price</th>
                                    <th class="px-3 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                    <th class="px-3 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Action</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @foreach($package->pricingTiers as $tier)
                                <tr>
                                    <td class="px-3 py-2 text-sm text-gray-900">{{ $tier->validity_days }} Days</td>
                                    <td class="px-3 py-2 text-sm text-gray-500">{{ $tier->ad_limit ? $tier->ad_limit . ' Ads' : 'Unlimited' }}</td>
                                    <td class="px-3 py-2 text-sm text-gray-500">₹{{ number_format($tier->base_price, 2) }}</td>
                                    <td class="px-3 py-2 text-sm text-red-500">{{ $tier->discount_percentage > 0 ? $tier->discount_percentage . '%' : '-' }}</td>
                                    <td class="px-3 py-2 text-sm font-bold text-green-600">₹{{ number_format($tier->calculateFinalPrice(), 2) }}</td>
                                    <td class="px-3 py-2 text-center">
                                        @if($tier->is_popular)
                                            <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-yellow-100 text-yellow-800">
                                                Popular
                                            </span>
                                        @endif
                                    </td>
                                    <td class="px-3 py-2 text-right text-sm">
                                        <form action="{{ route('admin.packages.pricing.destroy', $tier->id) }}" method="POST" onsubmit="return confirm('Delete this pricing tier?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-red-600 hover:text-red-900 font-medium bg-transparent border-0 cursor-pointer">Delete</button>
                                        </form>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @else 
                        <div class="text-center py-4 bg-gray-50 rounded border border-dashed border-gray-300">
                            <p class="text-sm text-gray-500">No pricing options configured yet.</p>
                        </div>
                    @endif

                    <div class="relative py-2">
                        <div class="absolute inset-0 flex items-center" aria-hidden="true">
                            <div class="w-full border-t border-gray-300"></div>
                        </div>
                        <div class="relative flex justify-center">
                            <span class="px-2 bg-white text-sm font-medium text-gray-500">Add New Option</span>
                        </div>
                    </div>

                    <form action="{{ route('admin.packages.pricing.store', $package->id) }}" method="POST" class="bg-gray-50 p-4 rounded-md border border-gray-200">
                        @csrf
                        <div class="grid grid-cols-5 gap-4 items-end">
                            <div class="col-span-5 sm:col-span-1">
                                <label class="block text-xs font-medium text-gray-500 uppercase">Validity (Days)</label>
                                <input type="number" name="validity_days" required class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md py-1 px-2 border" placeholder="30">
                            </div>
                            <div class="col-span-4 sm:col-span-1">
                                <label class="block text-xs font-medium text-gray-500 uppercase">Ad Limit</label>
                                <input type="number" name="ad_limit" class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md py-1 px-2 border" placeholder="Qty">
                            </div>
                            <div class="col-span-4 sm:col-span-1">
                                <label class="block text-xs font-medium text-gray-500 uppercase">Base Price (₹)</label>
                                <input type="number" name="base_price" required step="0.01" class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md py-1 px-2 border" placeholder="99.00">
                            </div>
                            <div class="col-span-5 sm:col-span-1">
                                <label class="block text-xs font-medium text-gray-500 uppercase">Discount (%)</label>
                                <input type="number" name="discount_percentage" value="0" min="0" max="100" class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md py-1 px-2 border">
                            </div>
                            <div class="col-span-5 sm:col-span-1">
                                <button type="submit" class="w-full inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                                    Add
                                </button>
                            </div>
                        </div>
                        <div class="mt-3">
                            <div class="flex items-start">
                                <div class="flex items-center h-5">
                                    <input id="isPopular" name="is_popular" type="checkbox" class="focus:ring-indigo-500 h-4 w-4 text-indigo-600 border-gray-300 rounded">
                                </div>
                                <div class="ml-3 text-sm">
                                    <label for="isPopular" class="font-medium text-gray-700">Mark as Popular</label>
                                </div>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>
@endsection
