@extends('admin.layouts.app')

@section('title', 'Create Package')

@section('content')
<div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
    <div class="md:grid md:grid-cols-3 md:gap-6">
        <div class="md:col-span-1">
            <div class="px-4 sm:px-0">
                <h3 class="text-lg font-medium leading-6 text-gray-900">Package Details</h3>
                <p class="mt-1 text-sm text-gray-600">
                    Define the core attributes of your new ad package.
                </p>
            </div>
        </div>
        <div class="mt-5 md:mt-0 md:col-span-2">
            <form action="{{ route('admin.packages.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="shadow sm:rounded-md sm:overflow-hidden">
                    <div class="px-4 py-5 bg-white space-y-6 sm:p-6">
                        
                        <div class="grid grid-cols-6 gap-6">
                            <div class="col-span-6">
                                <label class="block text-sm font-medium text-gray-700">Package Icon</label>
                                <div class="mt-1 flex items-center">
                                    <input type="file" name="icon" class="focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border-gray-300 border p-2 rounded-md">
                                    <small class="block mt-1 text-gray-500">Allowed: JPEG, PNG, GIF, SVG</small>
                                </div>
                            </div>

                            <div class="col-span-6 sm:col-span-3">
                                <label for="name" class="block text-sm font-medium text-gray-700">Package Name</label>
                                <input type="text" name="name" id="name" required class="mt-1 focus:ring-indigo-500 focus:border-indigo-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md py-2 px-3 border" placeholder="e.g. Premium Bundle">
                            </div>

                            <div class="col-span-6 sm:col-span-3">
                                <label for="slug" class="block text-sm font-medium text-gray-700">Slug</label>
                                <input type="text" name="slug" id="slug" required class="mt-1 focus:ring-indigo-500 focus:border-indigo-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md py-2 px-3 border" placeholder="e.g. premium-bundle">
                            </div>

                            <div class="col-span-6 sm:col-span-3">
                                <label for="type" class="block text-sm font-medium text-gray-700">Type</label>
                                <select id="type" name="type" required class="mt-1 block w-full py-2 px-3 border border-gray-300 bg-white rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                                    <option value="multiple_ads">Multiple Ads Bundle</option>
                                    <option value="featured">Featured Ad</option>
                                    <option value="boost">Boost Ad</option>
                                    <option value="combo">Combo (Featured + Boost)</option>
                                </select>
                            </div>

                            <div class="col-span-6 sm:col-span-3">
                                <label for="sort_order" class="block text-sm font-medium text-gray-700">Sort Order</label>
                                <input type="number" name="sort_order" id="sort_order" value="0" class="mt-1 focus:ring-indigo-500 focus:border-indigo-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md py-2 px-3 border">
                            </div>

                            <div class="col-span-6">
                                <label for="description" class="block text-sm font-medium text-gray-700">Description</label>
                                <div class="mt-1">
                                    <textarea id="description" name="description" rows="3" class="shadow-sm focus:ring-indigo-500 focus:border-indigo-500 mt-1 block w-full sm:text-sm border border-gray-300 rounded-md p-2" placeholder="Brief description of the package benefits..."></textarea>
                                </div>
                            </div>

                            <div class="col-span-6">
                                <fieldset>
                                    <div class="flex items-start">
                                        <div class="flex items-center h-5">
                                            <input id="isActive" name="is_active" type="checkbox" checked class="focus:ring-indigo-500 h-4 w-4 text-indigo-600 border-gray-300 rounded">
                                        </div>
                                        <div class="ml-3 text-sm">
                                            <label for="isActive" class="font-medium text-gray-700">Activte</label>
                                            <p class="text-gray-500">Make this package available for purchase immediately.</p>
                                        </div>
                                    </div>
                                </fieldset>
                            </div>
                        </div>

                        <div class="relative">
                            <div class="absolute inset-0 flex items-center" aria-hidden="true">
                                <div class="w-full border-t border-gray-300"></div>
                            </div>
                            <div class="relative flex justify-center">
                                <span class="px-2 bg-white text-sm text-gray-500">
                                    Features Configuration
                                </span>
                            </div>
                        </div>

                        <div class="grid grid-cols-6 gap-6 bg-gray-50 p-4 rounded-md border border-gray-100">
                            <div class="col-span-6 sm:col-span-2">
                                <label class="block text-sm font-medium text-gray-700">Post Limit</label>
                                <input type="number" name="features[post_limit]" class="mt-1 focus:ring-indigo-500 focus:border-indigo-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md py-2 px-3 border" placeholder="e.g. 10">
                            </div>
                            <div class="col-span-6 sm:col-span-2">
                                <label class="block text-sm font-medium text-gray-700">Featured Duration (Days)</label>
                                <input type="number" name="features[featured_duration_days]" class="mt-1 focus:ring-indigo-500 focus:border-indigo-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md py-2 px-3 border" placeholder="e.g. 7">
                            </div>
                            <div class="col-span-6 sm:col-span-2">
                                <label class="block text-sm font-medium text-gray-700">Boost Count</label>
                                <input type="number" name="features[boost_count]" class="mt-1 focus:ring-indigo-500 focus:border-indigo-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md py-2 px-3 border" placeholder="e.g. 3">
                            </div>
                        </div>

                    </div>
                    <div class="px-4 py-3 bg-gray-50 text-right sm:px-6">
                        <a href="{{ route('admin.packages.index') }}" class="mr-3 inline-flex justify-center py-2 px-4 border border-gray-300 shadow-sm text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                            Cancel
                        </a>
                        <button type="submit" class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                            Create Package
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
